/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoteInterpreterTest
extends AbstractInterpreterTest {
    private InterpreterSetting interpreterSetting;
    private String note1Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName("test");
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testSharedMode() throws InterpreterException, IOException {
        this.interpreterSetting.getOption().setPerUser("shared");
        Interpreter interpreter1 = this.interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Interpreter interpreter2 = this.interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertTrue((boolean)(interpreter1 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter1 = (RemoteInterpreter)interpreter1;
        Assertions.assertTrue((boolean)(interpreter2 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter2 = (RemoteInterpreter)interpreter2;
        Assertions.assertEquals((Object)remoteInterpreter1.getScheduler(), (Object)remoteInterpreter2.getScheduler());
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter1.interpret("hello", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)Interpreter.FormType.NATIVE, (Object)interpreter1.getFormType());
        Assertions.assertEquals((int)0, (int)remoteInterpreter1.getProgress(context1));
        Assertions.assertNotNull((Object)remoteInterpreter1.getOrCreateInterpreterProcess());
        Assertions.assertTrue((boolean)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess().isRunning());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter2.interpret("hello", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess(), (Object)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess());
        remoteInterpreter1.getInterpreterGroup().close(remoteInterpreter1.getSessionId());
        Assertions.assertNull((Object)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess());
        InterpreterResult result = remoteInterpreter1.interpret("hello", context1);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        Assertions.assertEquals((Object)"Interpreter process is not running\n", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
    }

    @Test
    public void testScopedMode() throws InterpreterException, IOException {
        this.interpreterSetting.getOption().setPerUser("scoped");
        Interpreter interpreter1 = this.interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Interpreter interpreter2 = this.interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertTrue((boolean)(interpreter1 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter1 = (RemoteInterpreter)interpreter1;
        Assertions.assertTrue((boolean)(interpreter2 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter2 = (RemoteInterpreter)interpreter2;
        Assertions.assertNotEquals((Object)interpreter1.getScheduler(), (Object)interpreter2.getScheduler());
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter1.interpret("hello", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter2.interpret("hello", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)Interpreter.FormType.NATIVE, (Object)interpreter1.getFormType());
        Assertions.assertEquals((int)0, (int)remoteInterpreter1.getProgress(context1));
        Assertions.assertNotNull((Object)remoteInterpreter1.getOrCreateInterpreterProcess());
        Assertions.assertTrue((boolean)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess().isRunning());
        Assertions.assertEquals((Object)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess(), (Object)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess());
        remoteInterpreter1.getInterpreterGroup().close(remoteInterpreter1.getSessionId());
        try {
            Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter1.interpret("hello", context1).message().get(0)).getData());
            Assertions.fail((String)"Should not be able to call interpret after interpreter is closed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assertions.assertTrue((boolean)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess().isRunning());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter2.interpret("hello", context1).message().get(0)).getData());
        remoteInterpreter2.getInterpreterGroup().close(remoteInterpreter2.getSessionId());
        InterpreterResult result = remoteInterpreter2.interpret("hello", context1);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        Assertions.assertEquals((Object)"Interpreter process is not running\n", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
        Assertions.assertNull((Object)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess());
    }

    @Test
    public void testIsolatedMode() throws InterpreterException, IOException {
        this.interpreterSetting.getOption().setPerUser("isolated");
        Interpreter interpreter1 = this.interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Interpreter interpreter2 = this.interpreterSetting.getDefaultInterpreter("user2", this.note1Id);
        Assertions.assertTrue((boolean)(interpreter1 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter1 = (RemoteInterpreter)interpreter1;
        Assertions.assertTrue((boolean)(interpreter2 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter2 = (RemoteInterpreter)interpreter2;
        Assertions.assertNotEquals((Object)interpreter1.getScheduler(), (Object)interpreter2.getScheduler());
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter1.interpret("hello", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter2.interpret("hello", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)Interpreter.FormType.NATIVE, (Object)interpreter1.getFormType());
        Assertions.assertEquals((int)0, (int)remoteInterpreter1.getProgress(context1));
        Assertions.assertNotNull((Object)remoteInterpreter1.getOrCreateInterpreterProcess());
        Assertions.assertTrue((boolean)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess().isRunning());
        Assertions.assertNotEquals((Object)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess(), (Object)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess());
        remoteInterpreter1.getInterpreterGroup().close(remoteInterpreter1.getSessionId());
        Assertions.assertNull((Object)remoteInterpreter1.getInterpreterGroup().getRemoteInterpreterProcess());
        Assertions.assertTrue((boolean)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess().isRunning());
        InterpreterResult result = remoteInterpreter1.interpret("hello", context1);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        Assertions.assertEquals((Object)"Interpreter process is not running\n", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
        Assertions.assertEquals((Object)"hello", (Object)((InterpreterResultMessage)remoteInterpreter2.interpret("hello", context1).message().get(0)).getData());
        remoteInterpreter2.getInterpreterGroup().close(remoteInterpreter2.getSessionId());
        result = remoteInterpreter2.interpret("hello", context1);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        Assertions.assertEquals((Object)"Interpreter process is not running\n", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
        Assertions.assertNull((Object)remoteInterpreter2.getInterpreterGroup().getRemoteInterpreterProcess());
    }

    @Test
    public void testExecuteIncorrectPrecode() throws TTransportException, IOException, InterpreterException {
        this.interpreterSetting.getOption().setPerUser("shared");
        this.interpreterSetting.setProperty("zeppelin.SleepInterpreter.precode", "fail test");
        Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)interpreter1.interpret("10", context1).code());
    }

    @Test
    public void testExecuteCorrectPrecode() throws TTransportException, IOException, InterpreterException {
        this.interpreterSetting.getOption().setPerUser("shared");
        this.interpreterSetting.setProperty("zeppelin.SleepInterpreter.precode", "1");
        Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)interpreter1.interpret("10", context1).code());
    }

    @Test
    public void testRemoteInterperterErrorStatus() throws TTransportException, IOException, InterpreterException {
        this.interpreterSetting.setProperty("zeppelin.interpreter.echo.fail", "true");
        this.interpreterSetting.getOption().setPerUser("shared");
        Interpreter interpreter1 = this.interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        Assertions.assertTrue((boolean)(interpreter1 instanceof RemoteInterpreter));
        RemoteInterpreter remoteInterpreter1 = (RemoteInterpreter)interpreter1;
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)remoteInterpreter1.interpret("hello", context1).code());
    }

    @Test
    public void testFIFOScheduler() throws InterruptedException, InterpreterException {
        this.interpreterSetting.getOption().setPerUser("shared");
        final Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
        final InterpreterContext context1 = this.createDummyInterpreterContext();
        interpreter1.interpret("1", context1);
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)interpreter1.interpret("100", context1).code());
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)interpreter1.interpret("100", context1).code());
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
            }
        };
        long start = System.currentTimeMillis();
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= 200L ? 1 : 0) != 0);
    }

    @Test
    public void testParallelScheduler() throws InterruptedException, InterpreterException {
        this.interpreterSetting.getOption().setPerUser("shared");
        this.interpreterSetting.setProperty("zeppelin.SleepInterpreter.parallel", "true");
        final Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
        final InterpreterContext context1 = this.createDummyInterpreterContext();
        interpreter1.interpret("1", context1);
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)interpreter1.interpret("100", context1).code());
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)interpreter1.interpret("100", context1).code());
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                    Assertions.fail();
                }
            }
        };
        long start = System.currentTimeMillis();
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start <= 200L ? 1 : 0) != 0);
    }

    @Test
    public void testRemoteInterpreterSharesTheSameSchedulerInstanceInTheSameGroup() {
        this.interpreterSetting.getOption().setPerUser("shared");
        Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
        Interpreter interpreter2 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "echo");
        Assertions.assertEquals((Object)interpreter1.getInterpreterGroup(), (Object)interpreter2.getInterpreterGroup());
        Assertions.assertEquals((Object)interpreter1.getScheduler(), (Object)interpreter2.getScheduler());
    }

    @Test
    public void testMultiInterpreterSession() {
        this.interpreterSetting.getOption().setPerUser("scoped");
        Interpreter interpreter1_user1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
        Interpreter interpreter2_user1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "echo");
        Assertions.assertEquals((Object)interpreter1_user1.getInterpreterGroup(), (Object)interpreter2_user1.getInterpreterGroup());
        Assertions.assertEquals((Object)interpreter1_user1.getScheduler(), (Object)interpreter2_user1.getScheduler());
        Interpreter interpreter1_user2 = this.interpreterSetting.getInterpreter("user2", this.note1Id, "sleep");
        Interpreter interpreter2_user2 = this.interpreterSetting.getInterpreter("user2", this.note1Id, "echo");
        Assertions.assertEquals((Object)interpreter1_user2.getInterpreterGroup(), (Object)interpreter2_user2.getInterpreterGroup());
        Assertions.assertEquals((Object)interpreter1_user2.getScheduler(), (Object)interpreter2_user2.getScheduler());
        Assertions.assertNotEquals((Object)interpreter1_user1.getScheduler(), (Object)interpreter1_user2.getScheduler());
    }

    @Test
    public void should_push_local_angular_repo_to_remote() throws Exception {
        AngularObjectRegistry registry = new AngularObjectRegistry("spark", null);
        registry.add("name_1", (Object)"value_1", "note_1", "paragraphId_1");
        registry.add("name_2", (Object)"value_2", "node_2", "paragraphId_2");
        Interpreter interpreter = this.interpreterSetting.getInterpreter("user1", this.note1Id, "angular_obj");
        interpreter.getInterpreterGroup().setAngularObjectRegistry(registry);
        InterpreterContext context = this.createDummyInterpreterContext();
        InterpreterResult result = interpreter.interpret("dummy", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertEquals((Object)"2", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
    }

    @Test
    public void testEnvStringPattern() {
        Assertions.assertFalse((boolean)RemoteInterpreterUtils.isEnvString(null));
        Assertions.assertFalse((boolean)RemoteInterpreterUtils.isEnvString((String)""));
        Assertions.assertFalse((boolean)RemoteInterpreterUtils.isEnvString((String)"abcDEF"));
        Assertions.assertFalse((boolean)RemoteInterpreterUtils.isEnvString((String)"ABC-DEF"));
        Assertions.assertTrue((boolean)RemoteInterpreterUtils.isEnvString((String)"ABCDEF"));
        Assertions.assertTrue((boolean)RemoteInterpreterUtils.isEnvString((String)"ABC_DEF"));
        Assertions.assertTrue((boolean)RemoteInterpreterUtils.isEnvString((String)"ABC_DEF123"));
    }

    @Test
    public void testEnvironmentAndProperty() throws InterpreterException {
        this.interpreterSetting.getOption().setPerUser("shared");
        this.interpreterSetting.setProperty("ENV_1", "VALUE_1");
        this.interpreterSetting.setProperty("property_1", "value_1");
        Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "get");
        InterpreterContext context1 = this.createDummyInterpreterContext();
        Assertions.assertEquals((Object)"VALUE_1", (Object)((InterpreterResultMessage)interpreter1.interpret("getEnv ENV_1", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)"null", (Object)((InterpreterResultMessage)interpreter1.interpret("getEnv ENV_2", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)"value_1", (Object)((InterpreterResultMessage)interpreter1.interpret("getProperty property_1", context1).message().get(0)).getData());
        Assertions.assertEquals((Object)"null", (Object)((InterpreterResultMessage)interpreter1.interpret("getProperty not_existed_property", context1).message().get(0)).getData());
    }

    @Test
    public void testConvertDynamicForms() throws InterpreterException {
        GUI gui = new GUI();
        OptionInput.ParamOption[] paramOptions = new OptionInput.ParamOption[]{new OptionInput.ParamOption((Object)"value1", "param1"), new OptionInput.ParamOption((Object)"value2", "param2")};
        ArrayList<String> defaultValues = new ArrayList<String>();
        defaultValues.add("default1");
        defaultValues.add("default2");
        gui.checkbox("checkbox_id", paramOptions, defaultValues);
        gui.select("select_id", paramOptions, (Object)"default");
        gui.textbox("textbox_id");
        LinkedHashMap expected = new LinkedHashMap(gui.getForms());
        Interpreter interpreter = this.interpreterSetting.getDefaultInterpreter("user1", this.note1Id);
        InterpreterContext context = this.createDummyInterpreterContext();
        interpreter.interpret("text", context);
        Assertions.assertArrayEquals((Object[])expected.values().toArray(), (Object[])gui.getForms().values().toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailToLaunchInterpreterProcess_InvalidRunner() {
        try {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_REMOTE_RUNNER.getVarName(), "invalid_runner");
            Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
            InterpreterContext context1 = this.createDummyInterpreterContext();
            try {
                interpreter1.interpret("1", context1);
                Assertions.fail((String)"Should not be able to launch interpreter process");
            }
            catch (InterpreterException e) {
                Assertions.assertTrue((boolean)ExceptionUtils.getStackTrace((Throwable)e).contains("java.io.IOException"));
            }
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_REMOTE_RUNNER.getVarName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailToLaunchInterpreterProcess_ErrorInRunner() {
        try {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_REMOTE_RUNNER.getVarName(), this.zeppelinHome.getAbsolutePath() + "/zeppelin-zengine/src/test/resources/bin/interpreter_invalid.sh");
            Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
            InterpreterContext context1 = this.createDummyInterpreterContext();
            try {
                interpreter1.interpret("1", context1);
                Assertions.fail((String)"Should not be able to launch interpreter process");
            }
            catch (InterpreterException e) {
                Assertions.assertTrue((boolean)ExceptionUtils.getStackTrace((Throwable)e).contains("invalid_command:"));
            }
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_REMOTE_RUNNER.getVarName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailToLaunchInterpreterProcess_Timeout() {
        try {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_REMOTE_RUNNER.getVarName(), this.zeppelinHome.getAbsolutePath() + "/zeppelin-zengine/src/test/resources/bin/interpreter_timeout.sh");
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT.getVarName(), "10s");
            Interpreter interpreter1 = this.interpreterSetting.getInterpreter("user1", this.note1Id, "sleep");
            InterpreterContext context1 = this.createDummyInterpreterContext();
            try {
                interpreter1.interpret("1", context1);
                Assertions.fail((String)"Should not be able to launch interpreter process");
            }
            catch (InterpreterException e) {
                Assertions.assertTrue((boolean)ExceptionUtils.getStackTrace((Throwable)e).contains("Interpreter Process creation is time out"));
            }
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_REMOTE_RUNNER.getVarName());
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT.getVarName());
        }
    }
}

