/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote.mock;

import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class MockInterpreterA
extends Interpreter {
    private String lastSt;

    public MockInterpreterA(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
    }

    public String getLastStatement() {
        return this.lastSt;
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        if (this.getProperties().containsKey("progress")) {
            context.setProgress(Integer.parseInt(this.getProperty("progress")));
        }
        try {
            Thread.sleep(Long.parseLong(st));
            this.lastSt = st;
        }
        catch (InterruptedException | NumberFormatException e) {
            throw new InterpreterException((Throwable)e);
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, st);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    public Scheduler getScheduler() {
        if (this.getProperty("parallel") != null && this.getProperty("parallel").equals("true")) {
            return SchedulerFactory.singleton().createOrGetParallelScheduler("interpreter_" + ((Object)((Object)this)).hashCode(), 10);
        }
        return SchedulerFactory.singleton().createOrGetFIFOScheduler("interpreter_" + ((Object)((Object)this)).hashCode());
    }
}

