/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote.mock;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectWatcher;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockInterpreterAngular
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockInterpreterAngular.class);
    AtomicInteger numWatch = new AtomicInteger(0);

    public MockInterpreterAngular(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        String[] stmt = st.split(" ");
        String cmd = stmt[0];
        String name = null;
        if (stmt.length >= 2) {
            name = stmt[1];
        }
        String value = null;
        if (stmt.length == 3) {
            value = stmt[2];
        }
        AngularObjectRegistry registry = context.getAngularObjectRegistry();
        if (cmd.equals("add")) {
            registry.add(name, (Object)value, context.getNoteId(), null);
            registry.get(name, context.getNoteId(), null).addWatcher(new AngularObjectWatcher(null){

                public void watch(Object oldObject, Object newObject, InterpreterContext context) {
                    MockInterpreterAngular.this.numWatch.incrementAndGet();
                }
            });
        } else if (cmd.equalsIgnoreCase("update")) {
            registry.get(name, context.getNoteId(), null).set((Object)value);
        } else if (cmd.equals("remove")) {
            registry.remove(name, context.getNoteId(), null);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in MockInterpreterAngular while interpret Thread.sleep", (Throwable)e);
        }
        String msg = registry.getAll(context.getNoteId(), null).size() + " " + Integer.toString(this.numWatch.get());
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, msg);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }
}

