/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote.mock;

import com.google.gson.Gson;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockInterpreterResourcePool
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockInterpreterResourcePool.class);
    AtomicInteger numWatch = new AtomicInteger(0);

    public MockInterpreterResourcePool(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        Resource resource;
        String[] stmt = st.split(" ");
        String cmd = stmt[0];
        String noteId = null;
        String paragraphId = null;
        String name = null;
        if (stmt.length >= 2) {
            String[] npn = stmt[1].split(":");
            if (npn.length >= 3) {
                noteId = npn[0];
                paragraphId = npn[1];
                name = npn[2];
            } else {
                name = stmt[1];
            }
        }
        String value = null;
        if (stmt.length >= 3) {
            value = stmt[2];
        }
        ResourcePool resourcePool = context.getResourcePool();
        Object ret = null;
        if (cmd.equals("put")) {
            resourcePool.put(noteId, paragraphId, name, (Object)value);
        } else if (cmd.equalsIgnoreCase("get")) {
            resource = resourcePool.get(noteId, paragraphId, name);
            ret = resource != null ? resourcePool.get(noteId, paragraphId, name).get() : "";
        } else if (cmd.equals("remove")) {
            ret = resourcePool.remove(noteId, paragraphId, name);
        } else if (cmd.equals("getAll")) {
            ret = resourcePool.getAll();
        } else if (cmd.equals("invoke")) {
            resource = resourcePool.get(noteId, paragraphId, name);
            LOGGER.info("Resource: " + resource);
            if (stmt.length >= 4) {
                Resource res = resource.invokeMethod(value, stmt[3]);
                LOGGER.info("After invokeMethod: " + resource);
                ret = res.get();
            } else {
                ret = resource.invokeMethod(value);
                LOGGER.info("After invokeMethod: " + ret);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException resource2) {
            // empty catch block
        }
        Gson gson = new Gson();
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, gson.toJson(ret));
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }
}

