/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.notebook.CredentialInjector;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CredentialInjectorTest {
    private static final String TEMPLATE = "val jdbcUrl = \"jdbc:mysql://localhost/emp?user={mysql.user}&password={mysql.password}\"";
    private static final String CORRECT_REPLACED = "val jdbcUrl = \"jdbc:mysql://localhost/emp?user=username&password=pwd\"";
    private static final String ANSWER = "jdbcUrl: String = jdbc:mysql://localhost/employees?user=username&password=pwd";
    private static final String HIDDEN = "jdbcUrl: String = jdbc:mysql://localhost/employees?user=username&password=###";

    @Test
    public void replaceCredentials() {
        UserCredentials userCredentials = (UserCredentials)Mockito.mock(UserCredentials.class);
        UsernamePassword usernamePassword = new UsernamePassword("username", "pwd");
        Mockito.when((Object)userCredentials.getUsernamePassword("mysql")).thenReturn((Object)usernamePassword);
        CredentialInjector testee = new CredentialInjector(userCredentials);
        String actual = testee.replaceCredentials(TEMPLATE);
        Assertions.assertEquals((Object)CORRECT_REPLACED, (Object)actual);
        InterpreterResult ret = new InterpreterResult(InterpreterResult.Code.SUCCESS, ANSWER);
        InterpreterResult hiddenResult = testee.hidePasswords(ret);
        Assertions.assertEquals((int)1, (int)hiddenResult.message().size());
        Assertions.assertEquals((Object)HIDDEN, (Object)((InterpreterResultMessage)hiddenResult.message().get(0)).getData());
    }

    @Test
    public void replaceCredentialNoTexts() {
        UserCredentials userCredentials = (UserCredentials)Mockito.mock(UserCredentials.class);
        CredentialInjector testee = new CredentialInjector(userCredentials);
        String actual = testee.replaceCredentials(null);
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void replaceCredentialsNotExisting() {
        UserCredentials userCredentials = (UserCredentials)Mockito.mock(UserCredentials.class);
        CredentialInjector testee = new CredentialInjector(userCredentials);
        String actual = testee.replaceCredentials(TEMPLATE);
        Assertions.assertEquals((Object)TEMPLATE, (Object)actual);
        InterpreterResult ret = new InterpreterResult(InterpreterResult.Code.SUCCESS, ANSWER);
        InterpreterResult hiddenResult = testee.hidePasswords(ret);
        Assertions.assertEquals((int)1, (int)hiddenResult.message().size());
        Assertions.assertEquals((Object)ANSWER, (Object)((InterpreterResultMessage)hiddenResult.message().get(0)).getData());
    }

    @Test
    public void hidePasswordsNoResult() {
        UserCredentials userCredentials = (UserCredentials)Mockito.mock(UserCredentials.class);
        CredentialInjector testee = new CredentialInjector(userCredentials);
        Assertions.assertNull((Object)testee.hidePasswords(null));
    }
}

