/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.NoteAuth;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class NoteAuthTest {
    private ZeppelinConfiguration conf = (ZeppelinConfiguration)Mockito.mock(ZeppelinConfiguration.class);

    @Test
    public void testAnonymous() {
        NoteAuth auth = new NoteAuth("note1", this.conf);
        Assertions.assertEquals((int)0, (int)auth.getOwners().size());
        Assertions.assertEquals((int)0, (int)auth.getReaders().size());
        Assertions.assertEquals((int)0, (int)auth.getRunners().size());
        Assertions.assertEquals((int)0, (int)auth.getWriters().size());
    }

    @Test
    public void testPublicNotes() {
        Mockito.when((Object)this.conf.isNotebookPublic()).thenReturn((Object)true);
        NoteAuth auth = new NoteAuth("note1", new AuthenticationInfo("TestUser"), this.conf);
        Assertions.assertEquals((Object)"note1", (Object)auth.getNoteId());
        Assertions.assertEquals((int)1, (int)auth.getOwners().size());
        Assertions.assertTrue((boolean)auth.getOwners().contains("TestUser"));
        Assertions.assertEquals((int)0, (int)auth.getReaders().size());
        Assertions.assertEquals((int)0, (int)auth.getRunners().size());
        Assertions.assertEquals((int)0, (int)auth.getWriters().size());
        Assertions.assertEquals((int)4, (int)auth.toMap().size());
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("owners")).contains("TestUser"));
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("readers")).isEmpty());
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("runners")).isEmpty());
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("writers")).isEmpty());
    }

    @Test
    public void testNoPublicNotes() {
        Mockito.when((Object)this.conf.isNotebookPublic()).thenReturn((Object)false);
        NoteAuth auth = new NoteAuth("note1", new AuthenticationInfo("TestUser"), this.conf);
        Assertions.assertEquals((int)1, (int)auth.getOwners().size());
        Assertions.assertTrue((boolean)auth.getOwners().contains("TestUser"));
        Assertions.assertEquals((int)1, (int)auth.getReaders().size());
        Assertions.assertTrue((boolean)auth.getReaders().contains("TestUser"));
        Assertions.assertEquals((int)1, (int)auth.getRunners().size());
        Assertions.assertTrue((boolean)auth.getRunners().contains("TestUser"));
        Assertions.assertEquals((int)1, (int)auth.getWriters().size());
        Assertions.assertTrue((boolean)auth.getWriters().contains("TestUser"));
        Assertions.assertEquals((int)4, (int)auth.toMap().size());
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("owners")).contains("TestUser"));
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("readers")).contains("TestUser"));
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("runners")).contains("TestUser"));
        Assertions.assertTrue((boolean)((Set)auth.toMap().get("writers")).contains("TestUser"));
    }

    @Test
    public void testFoceLowerCaseUsers() {
        Mockito.when((Object)this.conf.isNotebookPublic()).thenReturn((Object)false);
        Mockito.when((Object)this.conf.isUsernameForceLowerCase()).thenReturn((Object)true);
        NoteAuth auth = new NoteAuth("note1", new AuthenticationInfo("TestUser"), this.conf);
        Assertions.assertEquals((int)1, (int)auth.getOwners().size());
        Assertions.assertTrue((boolean)auth.getOwners().contains("testuser"));
        Assertions.assertEquals((int)1, (int)auth.getReaders().size());
        Assertions.assertTrue((boolean)auth.getReaders().contains("testuser"));
        Assertions.assertEquals((int)1, (int)auth.getRunners().size());
        Assertions.assertTrue((boolean)auth.getRunners().contains("testuser"));
        Assertions.assertEquals((int)1, (int)auth.getWriters().size());
        Assertions.assertTrue((boolean)auth.getWriters().contains("testuser"));
    }

    @Test
    public void testMapConstructor() {
        Mockito.when((Object)this.conf.isNotebookPublic()).thenReturn((Object)false);
        NoteAuth auth = new NoteAuth("note1", NoteAuthTest.getTestMap("TestUser", "TestGroup"), this.conf);
        Assertions.assertEquals((int)2, (int)auth.getOwners().size());
        Assertions.assertTrue((boolean)auth.getOwners().contains("TestUser"));
        Assertions.assertTrue((boolean)auth.getOwners().contains("TestGroup"));
        Assertions.assertEquals((int)2, (int)auth.getReaders().size());
        Assertions.assertTrue((boolean)auth.getReaders().contains("TestUser"));
        Assertions.assertTrue((boolean)auth.getRunners().contains("TestGroup"));
        Assertions.assertEquals((int)2, (int)auth.getRunners().size());
        Assertions.assertTrue((boolean)auth.getRunners().contains("TestUser"));
        Assertions.assertTrue((boolean)auth.getRunners().contains("TestGroup"));
        Assertions.assertEquals((int)2, (int)auth.getWriters().size());
        Assertions.assertTrue((boolean)auth.getWriters().contains("TestUser"));
        Assertions.assertTrue((boolean)auth.getWriters().contains("TestGroup"));
    }

    private static Map<String, Set<String>> getTestMap(String user, String group) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet<String> readers = new HashSet<String>();
        readers.add(user);
        readers.add(group);
        HashSet writers = new HashSet(readers);
        HashSet runners = new HashSet(readers);
        HashSet owners = new HashSet(readers);
        map.put("readers", readers);
        map.put("writers", writers);
        map.put("runners", runners);
        map.put("owners", owners);
        return map;
    }
}

