/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.ui.TextBox;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class NoteTest {
    NotebookRepo repo;
    ParagraphJobListener paragraphJobListener;
    Credentials credentials;
    Interpreter interpreter;
    ManagedInterpreterGroup interpreterGroup;
    InterpreterSetting interpreterSetting;
    Scheduler scheduler;
    List<NoteEventListener> noteEventListener = new ArrayList<NoteEventListener>();
    InterpreterFactory interpreterFactory;
    InterpreterSettingManager interpreterSettingManager;
    private AuthenticationInfo anonymous = new AuthenticationInfo("anonymous");

    NoteTest() {
    }

    @BeforeEach
    public void setUp() {
        this.repo = (NotebookRepo)Mockito.mock(NotebookRepo.class);
        this.paragraphJobListener = (ParagraphJobListener)Mockito.mock(ParagraphJobListener.class);
        this.credentials = (Credentials)Mockito.mock(Credentials.class);
        this.interpreter = (Interpreter)Mockito.mock(Interpreter.class);
        this.interpreterGroup = (ManagedInterpreterGroup)Mockito.mock(ManagedInterpreterGroup.class);
        this.interpreterSetting = (InterpreterSetting)Mockito.mock(InterpreterSetting.class);
        this.scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        this.interpreterFactory = (InterpreterFactory)Mockito.mock(InterpreterFactory.class);
        this.interpreterSettingManager = (InterpreterSettingManager)Mockito.mock(InterpreterSettingManager.class);
    }

    @Test
    void runNormalTest() throws InterpreterNotFoundException {
        Mockito.when((Object)this.interpreterFactory.getInterpreter((String)ArgumentMatchers.eq((Object)"spark"), (ExecutionContext)ArgumentMatchers.any())).thenReturn((Object)this.interpreter);
        Mockito.when((Object)this.interpreter.getScheduler()).thenReturn((Object)this.scheduler);
        Mockito.when((Object)this.interpreter.getInterpreterGroup()).thenReturn((Object)this.interpreterGroup);
        Mockito.when((Object)this.interpreterGroup.getInterpreterSetting()).thenReturn((Object)this.interpreterSetting);
        String pText = "%spark sc.version";
        Note note = new Note("test", "test", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p.setText(pText);
        p.setAuthenticationInfo(this.anonymous);
        note.run(p.getId());
        ArgumentCaptor pCaptor = ArgumentCaptor.forClass(Paragraph.class);
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.only())).submit((Job)pCaptor.capture());
        ((InterpreterFactory)Mockito.verify((Object)this.interpreterFactory, (VerificationMode)Mockito.times((int)1))).getInterpreter((String)ArgumentMatchers.eq((Object)"spark"), (ExecutionContext)ArgumentMatchers.any());
        Assertions.assertEquals((Object)pText, (Object)((Paragraph)pCaptor.getValue()).getText(), (String)"Paragraph text");
    }

    @Test
    void addParagraphWithEmptyReplNameTest() {
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Assertions.assertNull((Object)p.getText());
    }

    @Test
    void addParagraphWithLastReplNameTest() throws InterpreterNotFoundException {
        Mockito.when((Object)this.interpreterFactory.getInterpreter((String)ArgumentMatchers.eq((Object)"spark"), (ExecutionContext)ArgumentMatchers.any())).thenReturn((Object)this.interpreter);
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%spark ");
        Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((Object)"%spark\n", (Object)p2.getText());
    }

    @Test
    void insertParagraphWithLastReplNameTest() throws InterpreterNotFoundException {
        Mockito.when((Object)this.interpreterFactory.getInterpreter((String)ArgumentMatchers.eq((Object)"spark"), (ExecutionContext)ArgumentMatchers.any())).thenReturn((Object)this.interpreter);
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%spark ");
        Paragraph p2 = note.insertNewParagraph(note.getParagraphs().size(), AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((Object)"%spark\n", (Object)p2.getText());
    }

    @Test
    void insertParagraphWithInvalidReplNameTest() throws InterpreterNotFoundException {
        Mockito.when((Object)this.interpreterFactory.getInterpreter((String)ArgumentMatchers.eq((Object)"invalid"), (ExecutionContext)ArgumentMatchers.any())).thenReturn(null);
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p1.setText("%invalid ");
        Paragraph p2 = note.insertNewParagraph(note.getParagraphs().size(), AuthenticationInfo.ANONYMOUS);
        Assertions.assertNull((Object)p2.getText());
    }

    @Test
    void insertParagraphwithUser() {
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p = note.insertNewParagraph(note.getParagraphs().size(), AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((Object)"anonymous", (Object)p.getUser());
    }

    @Test
    void clearAllParagraphOutputTest() throws InterpreterNotFoundException {
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        InterpreterResult result = new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, "result");
        p1.setResult(result);
        Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p2.setReturn(result, new Throwable());
        note.clearAllParagraphOutput();
        Assertions.assertNull((Object)p1.getReturn());
        Assertions.assertNull((Object)p2.getReturn());
    }

    @Test
    void personalizedModeReturnDifferentParagraphInstancePerUser() {
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        String user1 = "user1";
        String user2 = "user2";
        note.setPersonalizedMode(Boolean.valueOf(true));
        note.addNewParagraph(new AuthenticationInfo(user1));
        Paragraph baseParagraph = (Paragraph)note.getParagraphs().get(0);
        Paragraph user1Paragraph = baseParagraph.getUserParagraph(user1);
        Paragraph user2Paragraph = baseParagraph.getUserParagraph(user2);
        Assertions.assertNotEquals((int)System.identityHashCode(baseParagraph), (int)System.identityHashCode(user1Paragraph));
        Assertions.assertNotEquals((int)System.identityHashCode(baseParagraph), (int)System.identityHashCode(user2Paragraph));
        Assertions.assertNotEquals((int)System.identityHashCode(user1Paragraph), (int)System.identityHashCode(user2Paragraph));
    }

    public void testNoteJson() throws IOException {
        Note note = new Note("test", "", this.interpreterFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListener);
        note.setName("/test_note");
        note.getConfig().put("config_1", "value_1");
        note.getInfo().put("info_1", "value_1");
        String pText = "%spark sc.version";
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p.setText(pText);
        p.setResult(new InterpreterResult(InterpreterResult.Code.SUCCESS, "1.6.2"));
        p.settings.getForms().put("textbox_1", new TextBox("name", "default_name"));
        p.settings.getParams().put("textbox_1", "my_name");
        note.getAngularObjects().put("ao_1", Arrays.asList(new AngularObject("name_1", (Object)"value_1", note.getId(), p.getId(), null)));
        Paragraph p2 = Paragraph.fromJson((String)p.toJson());
        Assertions.assertEquals((Object)p2.settings, (Object)p.settings);
        Assertions.assertEquals((Object)p2, (Object)p);
        Note note2 = Note.fromJson(null, (String)note.toJson());
        Assertions.assertEquals((Object)note2, (Object)note);
    }
}

