/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.repo.VFSNotebookRepo;
import org.apache.zeppelin.notebook.scheduler.QuartzSchedulerService;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.eclipse.aether.RepositoryException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookTest
extends AbstractInterpreterTest
implements ParagraphJobListener {
    private static final Logger logger = LoggerFactory.getLogger(NotebookTest.class);
    private Notebook notebook;
    private NoteManager noteManager;
    private NotebookRepo notebookRepo;
    private AuthorizationService authorizationService;
    private Credentials credentials;
    private AuthenticationInfo anonymous = AuthenticationInfo.ANONYMOUS;
    private StatusChangedListener afterStatusChangedListener;
    private QuartzSchedulerService schedulerService;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_PUBLIC.getVarName(), "true");
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_CRON_ENABLE.getVarName(), "true");
        super.setUp();
        this.notebookRepo = new VFSNotebookRepo();
        this.notebookRepo.init(this.conf);
        this.noteManager = new NoteManager(this.notebookRepo, this.conf);
        this.authorizationService = new AuthorizationService(this.noteManager, this.conf);
        this.credentials = new Credentials(this.conf);
        this.notebook = new Notebook(this.conf, this.authorizationService, this.notebookRepo, this.noteManager, this.interpreterFactory, this.interpreterSettingManager, this.credentials, null);
        this.notebook.setParagraphJobListener((ParagraphJobListener)this);
        this.schedulerService = new QuartzSchedulerService(this.conf, this.notebook);
        this.notebook.initNotebook();
        this.notebook.waitForFinishInit(1L, TimeUnit.MINUTES);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_PUBLIC.getVarName());
        System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_CRON_ENABLE.getVarName());
    }

    @Test
    public void testRevisionSupported() throws IOException {
        Object notebookRepo = new DummyNotebookRepo();
        Notebook notebook = new Notebook(this.conf, (AuthorizationService)Mockito.mock(AuthorizationService.class), (NotebookRepo)notebookRepo, new NoteManager((NotebookRepo)notebookRepo, this.conf), this.interpreterFactory, this.interpreterSettingManager, this.credentials, null);
        Assertions.assertFalse((boolean)notebook.isRevisionSupported(), (String)"Revision is not supported in DummyNotebookRepo");
        notebookRepo = new DummyNotebookRepoWithVersionControl();
        notebook = new Notebook(this.conf, (AuthorizationService)Mockito.mock(AuthorizationService.class), (NotebookRepo)notebookRepo, new NoteManager((NotebookRepo)notebookRepo, this.conf), this.interpreterFactory, this.interpreterSettingManager, this.credentials, null);
        Assertions.assertTrue((boolean)notebook.isRevisionSupported(), (String)"Revision is supported in DummyNotebookRepoWithVersionControl");
    }

    @Test
    public void testSelectingReplImplementation() throws IOException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map config = p1.getConfig();
            config.put("enabled", true);
            p1.setConfig(config);
            p1.setText("%mock1 hello world");
            p1.setAuthenticationInfo(this.anonymous);
            note.run(p1.getId());
            while (!p1.isTerminated() || p1.getReturn() == null) {
                Thread.yield();
            }
            Assertions.assertEquals((Object)"repl1: hello world", (Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData());
            Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p2.setConfig(config);
            p2.setText("%mock2 hello world");
            p2.setAuthenticationInfo(this.anonymous);
            note.run(p2.getId());
            while (!p2.isTerminated() || p2.getReturn() == null) {
                Thread.yield();
            }
            Assertions.assertEquals((Object)"repl2: hello world", (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testReloadAndSetInterpreter() throws IOException {
        String noteId = this.notebook.createNote("note1", AuthenticationInfo.ANONYMOUS);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.insertNewParagraph(0, AuthenticationInfo.ANONYMOUS);
            p1.setText("%md hello world");
            this.notebook.saveNote(note, AuthenticationInfo.ANONYMOUS);
            return null;
        });
        this.notebook.reloadAllNotes(this.anonymous);
        Assertions.assertEquals((int)1, (int)this.notebook.getNotesInfo().size());
        this.notebook.processNote(noteId, newNote -> {
            try {
                ((Paragraph)newNote.getParagraphs().get(0)).getBindedInterpreter();
                Assertions.fail((String)"Should throw InterpreterNotFoundException");
            }
            catch (InterpreterNotFoundException interpreterNotFoundException) {
                // empty catch block
            }
            return null;
        });
    }

    @Test
    public void testReloadAllNotes() throws IOException {
        String note1Id = this.notebook.createNote("note1", AuthenticationInfo.ANONYMOUS);
        this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.insertNewParagraph(0, AuthenticationInfo.ANONYMOUS);
            p1.setText("%md hello world");
            return null;
        });
        String note2Id = this.notebook.cloneNote(note1Id, "copied note", AuthenticationInfo.ANONYMOUS);
        Note copiedNote = this.notebookRepo.get(note2Id, "/copied note", this.anonymous);
        this.notebook.reloadAllNotes(this.anonymous);
        List notesInfo = this.notebook.getNotesInfo();
        Assertions.assertEquals((int)2, (int)notesInfo.size());
        NoteInfo found = null;
        for (NoteInfo noteInfo : notesInfo) {
            if (!noteInfo.getId().equals(copiedNote.getId())) continue;
            found = noteInfo;
            break;
        }
        Assertions.assertNotNull(found);
        Assertions.assertEquals((Object)found.getId(), (Object)copiedNote.getId());
        Assertions.assertEquals((Object)this.notebook.processNote(found.getId(), Note::getName), (Object)copiedNote.getName());
        this.notebook.processNote(found.getId(), note -> {
            Assertions.assertEquals((int)note.getParagraphs().size(), (int)copiedNote.getParagraphs().size());
            Assertions.assertEquals((Object)((Paragraph)note.getParagraphs().get(0)).getText(), (Object)((Paragraph)copiedNote.getParagraphs().get(0)).getText());
            Assertions.assertEquals((Object)((Paragraph)note.getParagraphs().get((int)0)).settings, (Object)((Paragraph)copiedNote.getParagraphs().get((int)0)).settings);
            Assertions.assertEquals((Object)((Paragraph)note.getParagraphs().get(0)).getTitle(), (Object)((Paragraph)copiedNote.getParagraphs().get(0)).getTitle());
            return null;
        });
        this.notebook.reloadAllNotes(this.anonymous);
        notesInfo = this.notebook.getNotesInfo();
        Assertions.assertEquals((int)2, (int)notesInfo.size());
    }

    @Test
    public void testLoadAllNotes() {
        try {
            Assertions.assertEquals((int)0, (int)this.notebook.getNotesInfo().size());
            String noteId = this.notebook.createNote("note1", this.anonymous);
            this.notebook.processNote(noteId, note -> {
                Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
                Map config = p1.getConfig();
                config.put("enabled", true);
                p1.setConfig(config);
                p1.setText("hello world");
                this.notebook.saveNote(note, this.anonymous);
                return null;
            });
        }
        catch (IOException fe) {
            logger.warn("Failed to create note and paragraph. Possible problem with persisting note, safe to ignore", (Throwable)fe);
        }
        Assertions.assertEquals((int)1, (int)this.notebook.getNotesInfo().size());
    }

    @Test
    public void testPersist() throws IOException, SchedulerException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map config = p1.getConfig();
            config.put("enabled", true);
            p1.setConfig(config);
            p1.setText("hello world");
            this.notebook.saveNote(note, this.anonymous);
            Assertions.assertEquals((int)1, (int)this.notebook.getNotesInfo().size());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testCreateNoteWithSubject() throws IOException, SchedulerException, RepositoryException {
        AuthenticationInfo subject = new AuthenticationInfo("user1");
        String noteId = this.notebook.createNote("note1", subject);
        Assertions.assertNotNull((Object)this.authorizationService.getOwners(noteId));
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(noteId).size());
        HashSet<String> owners = new HashSet<String>();
        owners.add("user1");
        Assertions.assertEquals(owners, (Object)this.authorizationService.getOwners(noteId));
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testClearParagraphOutput() throws IOException, SchedulerException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map config = p1.getConfig();
            config.put("enabled", true);
            p1.setConfig(config);
            p1.setText("%mock1 hello world");
            p1.setAuthenticationInfo(this.anonymous);
            note.run(p1.getId());
            while (!p1.isTerminated() || p1.getReturn() == null) {
                Thread.yield();
            }
            Assertions.assertEquals((Object)"repl1: hello world", (Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData());
            note.clearParagraphOutput(p1.getId());
            Assertions.assertNull((Object)p1.getReturn());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testRunBlankParagraph() throws IOException, SchedulerException, InterruptedException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p1.setText("");
            p1.setAuthenticationInfo(this.anonymous);
            note.run(p1.getId());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"Interrupted");
            }
            Assertions.assertEquals((Object)Job.Status.FINISHED, (Object)p1.getStatus());
            Assertions.assertNull((Object)p1.getDateStarted());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testRemoveNote() throws IOException, InterruptedException {
        try {
            LOGGER.info("--------------- Test testRemoveNote ---------------");
            String noteId = this.notebook.createNote("note1", this.anonymous);
            int mock1ProcessNum = this.interpreterSettingManager.getByName("mock1").getAllInterpreterGroups().size();
            Paragraph p = (Paragraph)this.notebook.processNote(noteId, note -> note.addNewParagraph(AuthenticationInfo.ANONYMOUS));
            HashMap config = new HashMap();
            p.setConfig(config);
            p.setText("%mock1 sleep 100000");
            p.execute(false);
            while (!p.isRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assertions.assertEquals((int)(mock1ProcessNum + 1), (int)this.interpreterSettingManager.getByName("mock1").getAllInterpreterGroups().size());
            LOGGER.info("--------------- Finish Test testRemoveNote ---------------");
            this.notebook.removeNote(noteId, this.anonymous);
            Thread.sleep(5000L);
            Assertions.assertEquals((int)mock1ProcessNum, (int)this.interpreterSettingManager.getByName("mock1").getAllInterpreterGroups().size());
            LOGGER.info("--------------- Finish Test testRemoveNote ---------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRemoveCorruptedNote() throws IOException {
        LOGGER.info("--------------- Test testRemoveCorruptedNote ---------------");
        String corruptedNoteId = this.notebook.createNote("note1", this.anonymous);
        String corruptedNotePath = (String)this.notebook.processNote(corruptedNoteId, corruptedNote -> this.notebookDir.getAbsolutePath() + corruptedNote.getPath() + "_" + corruptedNote.getId() + ".zpln");
        FileWriter myWriter = new FileWriter(corruptedNotePath);
        myWriter.write("{{{I'm corrupted;;;");
        myWriter.close();
        LOGGER.info("--------------- Finish Test testRemoveCorruptedNote ---------------");
        int numberOfNotes = this.notebook.getNotesInfo().size();
        this.notebook.removeNote(corruptedNoteId, this.anonymous);
        Assertions.assertEquals((int)(numberOfNotes - 1), (int)this.notebook.getNotesInfo().size());
        LOGGER.info("--------------- Finish Test testRemoveCorruptedNote ---------------");
    }

    @Test
    public void testInvalidInterpreter() throws IOException, InterruptedException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p1.setText("%invalid abc");
            p1.setAuthenticationInfo(this.anonymous);
            note.run(p1.getId());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"Interrupted");
            }
            Assertions.assertEquals((Object)Job.Status.ERROR, (Object)p1.getStatus());
            InterpreterResult result = p1.getReturn();
            Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
            Assertions.assertEquals((Object)"Interpreter invalid not found", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
            Assertions.assertNull((Object)p1.getDateStarted());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testRunAll() throws Exception {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map config1 = p1.getConfig();
            config1.put("enabled", true);
            p1.setConfig(config1);
            p1.setText("%mock1 p1");
            Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map config2 = p2.getConfig();
            config2.put("enabled", false);
            p2.setConfig(config2);
            p2.setText("%mock1 p2");
            Paragraph p3 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p3.setText("%mock1 p3");
            try {
                note.runAll(this.anonymous, true, false, new HashMap());
            }
            catch (Exception e) {
                Assertions.fail((String)"Exception in runAll");
            }
            Assertions.assertEquals((Object)"repl1: p1", (Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData());
            Assertions.assertNull((Object)p2.getReturn());
            Assertions.assertEquals((Object)"repl1: p3", (Object)((InterpreterResultMessage)p3.getReturn().message().get(0)).getData());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testSchedule() throws InterruptedException, IOException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        Paragraph paragraph = (Paragraph)this.notebook.processNote(noteId, note -> {
            Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map<String, String> config = new HashMap();
            p.setConfig(config);
            p.setText("p1");
            Date dateFinished = p.getDateFinished();
            Assertions.assertNull((Object)dateFinished);
            config = note.getConfig();
            config.put("enabled", (String)((Object)Boolean.valueOf(true)));
            config.put("cron", "* * * * * ?");
            note.setConfig(config);
            return p;
        });
        this.schedulerService.refreshCron(noteId);
        Thread.sleep(2000L);
        this.notebook.processNote(noteId, note -> {
            Map config = note.getConfig();
            config.put("cron", null);
            note.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        Thread.sleep(3000L);
        Date dateFinished = paragraph.getDateFinished();
        Assertions.assertNotNull((Object)dateFinished);
        Thread.sleep(2000L);
        Assertions.assertEquals((Object)dateFinished, (Object)paragraph.getDateFinished());
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testScheduleAgainstRunningAndPendingParagraph() throws InterruptedException, IOException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            for (Job.Status status : new Job.Status[]{Job.Status.RUNNING, Job.Status.PENDING}) {
                Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
                HashMap config = new HashMap();
                p.setConfig(config);
                p.setText("p");
                p.setStatus(status);
                Assertions.assertNull((Object)p.getDateFinished());
            }
            Map config = note.getConfig();
            config.put("enabled", true);
            config.put("cron", "* * * * * ?");
            note.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        Thread.sleep(2000L);
        this.notebook.processNote(noteId, note -> {
            Map config = note.getConfig();
            config.put("cron", null);
            note.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        Thread.sleep(2000L);
        this.notebook.processNote(noteId, note -> {
            for (Paragraph p : note.getParagraphs()) {
                Assertions.assertNull((Object)p.getDateFinished());
            }
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testSchedulePoolUsage() throws InterruptedException, IOException {
        int timeout = 30;
        String everySecondCron = "* * * * * ?";
        final CountDownLatch jobsToExecuteCount = new CountDownLatch(5);
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.executeNewParagraphByCron(noteId, "* * * * * ?");
        this.afterStatusChangedListener = new StatusChangedListener(){

            @Override
            public void onStatusChanged(Job<?> job, Job.Status before, Job.Status after) {
                if (after == Job.Status.FINISHED) {
                    jobsToExecuteCount.countDown();
                }
            }
        };
        Assertions.assertTrue((boolean)jobsToExecuteCount.await(30L, TimeUnit.SECONDS));
        this.terminateScheduledNote(noteId);
        this.afterStatusChangedListener = null;
    }

    private void executeNewParagraphByCron(String noteId, String cron) throws IOException {
        this.notebook.processNote(noteId, note -> {
            Paragraph paragraph = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            paragraph.setText("p");
            Map config = note.getConfig();
            config.put("enabled", true);
            config.put("cron", cron);
            note.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(noteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleDisabled() throws InterruptedException, IOException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_CRON_ENABLE.getVarName(), "false");
        try {
            int timeout = 10;
            String everySecondCron = "* * * * * ?";
            final CountDownLatch jobsToExecuteCount = new CountDownLatch(5);
            String noteId = this.notebook.createNote("note1", this.anonymous);
            this.executeNewParagraphByCron(noteId, "* * * * * ?");
            this.afterStatusChangedListener = new StatusChangedListener(){

                @Override
                public void onStatusChanged(Job<?> job, Job.Status before, Job.Status after) {
                    if (after == Job.Status.FINISHED) {
                        jobsToExecuteCount.countDown();
                    }
                }
            };
            Assertions.assertFalse((boolean)jobsToExecuteCount.await(10L, TimeUnit.SECONDS));
            this.terminateScheduledNote(noteId);
            this.afterStatusChangedListener = null;
        }
        finally {
            System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_CRON_ENABLE.getVarName(), "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleDisabledWithName() throws InterruptedException, IOException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_CRON_FOLDERS.getVarName(), "/System");
        try {
            int timeout = 30;
            String everySecondCron = "* * * * * ?";
            final CountDownLatch jobsToExecuteCount = new CountDownLatch(5);
            String noteId = this.notebook.createNote("note1", this.anonymous);
            this.executeNewParagraphByCron(noteId, "* * * * * ?");
            this.afterStatusChangedListener = new StatusChangedListener(){

                @Override
                public void onStatusChanged(Job<?> job, Job.Status before, Job.Status after) {
                    if (after == Job.Status.FINISHED) {
                        jobsToExecuteCount.countDown();
                    }
                }
            };
            Assertions.assertFalse((boolean)jobsToExecuteCount.await(30L, TimeUnit.SECONDS));
            this.terminateScheduledNote(noteId);
            this.afterStatusChangedListener = null;
            String noteNameSystemId = this.notebook.createNote("/System/test1", this.anonymous);
            final CountDownLatch jobsToExecuteCountNameSystem = new CountDownLatch(5);
            this.executeNewParagraphByCron(noteNameSystemId, "* * * * * ?");
            this.afterStatusChangedListener = new StatusChangedListener(){

                @Override
                public void onStatusChanged(Job<?> job, Job.Status before, Job.Status after) {
                    if (after == Job.Status.FINISHED) {
                        jobsToExecuteCountNameSystem.countDown();
                    }
                }
            };
            Assertions.assertTrue((boolean)jobsToExecuteCountNameSystem.await(30L, TimeUnit.SECONDS));
            this.terminateScheduledNote(noteNameSystemId);
            this.afterStatusChangedListener = null;
        }
        finally {
            System.clearProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_CRON_FOLDERS.getVarName());
        }
    }

    private void terminateScheduledNote(String noteId) throws IOException {
        this.notebook.processNote(noteId, note -> {
            note.getConfig().remove("cron");
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        this.notebook.removeNote(noteId, this.anonymous);
    }

    public void testAutoRestartInterpreterAfterSchedule() throws InterruptedException, IOException, InterpreterNotFoundException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map<String, String> config = new HashMap();
            p.setConfig(config);
            p.setText("%mock1 sleep 1000");
            Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p2.setConfig(config);
            p2.setText("%mock2 sleep 500");
            config = note.getConfig();
            config.put("enabled", (String)((Object)Boolean.valueOf(true)));
            config.put("cron", "1/3 * * * * ?");
            config.put("releaseresource", (String)((Object)Boolean.valueOf(true)));
            note.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        ExecutionContext executionContext = new ExecutionContext(this.anonymous.getUser(), noteId, "test");
        RemoteInterpreter mock1 = (RemoteInterpreter)this.interpreterFactory.getInterpreter("mock1", executionContext);
        RemoteInterpreter mock2 = (RemoteInterpreter)this.interpreterFactory.getInterpreter("mock2", executionContext);
        while (!mock1.isOpened() || !mock2.isOpened()) {
            Thread.yield();
        }
        while (mock1.isOpened() || mock2.isOpened()) {
            Thread.yield();
        }
        this.notebook.processNote(noteId, note -> {
            Map config = note.getConfig();
            config.put("cron", null);
            note.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        this.notebook.processNote(noteId, note -> {
            for (Paragraph p : note.getParagraphs()) {
                Assertions.assertNotNull((Object)p);
            }
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    public void testCronWithReleaseResourceClosesOnlySpecificInterpreters() throws IOException, InterruptedException, InterpreterNotFoundException {
        String cronNoteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(cronNoteId, cronNote -> {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("cron", "1/5 * * * * ?");
            config.put("cronExecutingUser", this.anonymous.getUser());
            config.put("releaseresource", true);
            cronNote.setConfig(config);
            return null;
        });
        RemoteInterpreter cronNoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("mock1", new ExecutionContext(this.anonymous.getUser(), cronNoteId, "test"));
        this.notebook.processNote(cronNoteId, cronNote -> {
            Paragraph cronNoteParagraph = cronNote.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("enabled", true);
            cronNoteParagraph.setConfig(config);
            cronNoteParagraph.setText("%mock1 sleep 1000");
            return null;
        });
        String anotherNoteId = this.notebook.createNote("note1", this.anonymous);
        RemoteInterpreter anotherNoteInterpreter = (RemoteInterpreter)this.interpreterFactory.getInterpreter("mock2", new ExecutionContext(this.anonymous.getUser(), anotherNoteId, "test"));
        this.notebook.processNote(anotherNoteId, anotherNote -> {
            Paragraph anotherNoteParagraph = anotherNote.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("enabled", true);
            anotherNoteParagraph.setConfig(config);
            anotherNoteParagraph.setText("%mock2 echo 1");
            anotherNote.run(anotherNoteParagraph.getId());
            return null;
        });
        while (!anotherNoteInterpreter.isOpened()) {
            Thread.yield();
        }
        this.schedulerService.refreshCron(cronNoteId);
        while (!cronNoteInterpreter.isOpened()) {
            Thread.yield();
        }
        while (cronNoteInterpreter.isOpened()) {
            Thread.yield();
        }
        Thread.sleep(5000L);
        Assertions.assertTrue((boolean)anotherNoteInterpreter.isOpened());
        this.notebook.processNote(cronNoteId, cronNote -> {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("cron", null);
            config.put("cronExecutingUser", null);
            config.put("releaseresource", null);
            cronNote.setConfig(config);
            return null;
        });
        this.schedulerService.refreshCron(cronNoteId);
        this.notebook.removeNote(cronNoteId, this.anonymous);
        this.notebook.removeNote(anotherNoteId, this.anonymous);
    }

    @Test
    public void testCronNoteInTrash() throws InterruptedException, IOException, SchedulerException {
        String noteId = this.notebook.createNote("~Trash/NotCron", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Map config = note.getConfig();
            config.put("enabled", true);
            config.put("cron", "* * * * * ?");
            note.setConfig(config);
            return null;
        });
        int jobsBeforeRefresh = this.schedulerService.getJobsSize();
        this.schedulerService.refreshCron(noteId);
        int jobsAfterRefresh = this.schedulerService.getJobsSize();
        Assertions.assertEquals((int)jobsBeforeRefresh, (int)jobsAfterRefresh);
        this.notebook.processNote(noteId, note -> {
            note.getConfig().remove("cron");
            return null;
        });
        this.schedulerService.refreshCron(noteId);
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testExportAndImportNote() throws Exception {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            String simpleText = "hello world";
            p.setText(simpleText);
            try {
                note.runAll(this.anonymous, true, false, new HashMap());
            }
            catch (Exception e) {
                Assertions.fail();
            }
            return null;
        });
        String exportedNoteJson = this.notebook.exportNote(noteId);
        String importedNoteId = this.notebook.importNote(exportedNoteJson, "Title", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p = note.getParagraph(0);
            this.notebook.processNote(importedNoteId, importedNote -> {
                Paragraph p2 = (Paragraph)importedNote.getParagraphs().get(0);
                Assertions.assertEquals((Object)p.getId(), (Object)p2.getId());
                Assertions.assertEquals((Object)p.getText(), (Object)p2.getText());
                Assertions.assertEquals((Object)((InterpreterResultMessage)p.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
                return null;
            });
            return null;
        });
        AuthenticationInfo subject = new AuthenticationInfo("user1");
        String importedNote2Id = this.notebook.importNote(exportedNoteJson, "Title2", subject);
        Assertions.assertNotNull((Object)this.authorizationService.getOwners(importedNote2Id));
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(importedNote2Id).size());
        HashSet<String> owners = new HashSet<String>();
        owners.add("user1");
        Assertions.assertEquals(owners, (Object)this.authorizationService.getOwners(importedNote2Id));
        this.notebook.removeNote(noteId, this.anonymous);
        this.notebook.removeNote(importedNoteId, this.anonymous);
        this.notebook.removeNote(importedNote2Id, this.anonymous);
    }

    @Test
    public void testCloneNote() throws Exception {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p.setText("hello world");
            try {
                note.runAll(this.anonymous, true, false, new HashMap());
            }
            catch (Exception e) {
                Assertions.fail();
            }
            p.setStatus(Job.Status.RUNNING);
            return null;
        });
        String cloneNoteId = this.notebook.cloneNote(noteId, "clone note", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p = note.getParagraph(0);
            this.notebook.processNote(cloneNoteId, cloneNote -> {
                Paragraph cp = cloneNote.getParagraph(0);
                Assertions.assertEquals((Object)Job.Status.READY, (Object)cp.getStatus());
                Assertions.assertEquals((Object)cp.getId(), (Object)p.getId());
                Assertions.assertEquals((Object)cp.getText(), (Object)p.getText());
                Assertions.assertEquals((Object)((InterpreterResultMessage)cp.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p.getReturn().message().get(0)).getData());
                return null;
            });
            return null;
        });
        AuthenticationInfo subject = new AuthenticationInfo("user1");
        String cloneNote2Id = this.notebook.cloneNote(noteId, "clone note2", subject);
        Assertions.assertNotNull((Object)this.authorizationService.getOwners(cloneNote2Id));
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(cloneNote2Id).size());
        HashSet<String> owners = new HashSet<String>();
        owners.add("user1");
        Assertions.assertEquals(owners, (Object)this.authorizationService.getOwners(cloneNote2Id));
        this.notebook.removeNote(noteId, this.anonymous);
        this.notebook.removeNote(cloneNoteId, this.anonymous);
        this.notebook.removeNote(cloneNote2Id, this.anonymous);
    }

    @Test
    public void testResourceRemovealOnParagraphNoteRemove() throws Exception {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p1.setText("%mock1 hello");
            Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p2.setText("%mock2 world");
            for (InterpreterGroup intpGroup : this.interpreterSettingManager.getAllInterpreterGroup()) {
                intpGroup.setResourcePool((ResourcePool)new LocalResourcePool(intpGroup.getId()));
            }
            try {
                note.runAll(this.anonymous, true, false, new HashMap());
            }
            catch (Exception e) {
                Assertions.fail();
            }
            Assertions.assertEquals((int)2, (int)this.interpreterSettingManager.getAllResources().size());
            note.removeParagraph(this.anonymous.getUser(), p1.getId());
            Assertions.assertEquals((int)1, (int)this.interpreterSettingManager.getAllResources().size());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
        Assertions.assertEquals((int)0, (int)this.interpreterSettingManager.getAllResources().size());
    }

    @Test
    public void testAngularObjectRemovalOnNotebookRemove() throws InterruptedException, IOException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        AngularObjectRegistry registry = (AngularObjectRegistry)this.notebook.processNote(noteId, note -> ((InterpreterSetting)note.getBindedInterpreterSettings(new ArrayList()).get(0)).getOrCreateInterpreterGroup(this.anonymous.getUser(), note.getId()).getAngularObjectRegistry());
        String paragraphId = (String)this.notebook.processNote(noteId, note -> note.addNewParagraph(AuthenticationInfo.ANONYMOUS).getId());
        registry.add("o1", (Object)"object1", noteId, paragraphId);
        registry.add("o2", (Object)"object2", noteId, null);
        registry.add("o3", (Object)"object3", null, null);
        this.notebook.removeNote(noteId, this.anonymous);
        Assertions.assertNull((Object)registry.get("o1", noteId, null));
        Assertions.assertNull((Object)registry.get("o2", noteId, paragraphId));
        Assertions.assertNotNull((Object)registry.get("o3", null, null));
    }

    @Test
    public void testAngularObjectRemovalOnParagraphRemove() throws InterruptedException, IOException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        AngularObjectRegistry registry = (AngularObjectRegistry)this.notebook.processNote(noteId, note -> ((InterpreterSetting)note.getBindedInterpreterSettings(new ArrayList()).get(0)).getOrCreateInterpreterGroup(this.anonymous.getUser(), note.getId()).getAngularObjectRegistry());
        String paragraphId = (String)this.notebook.processNote(noteId, note -> note.addNewParagraph(AuthenticationInfo.ANONYMOUS).getId());
        registry.add("o1", (Object)"object1", noteId, paragraphId);
        registry.add("o2", (Object)"object2", noteId, null);
        registry.add("o3", (Object)"object3", null, null);
        this.notebook.processNote(noteId, note -> {
            note.removeParagraph(this.anonymous.getUser(), paragraphId);
            return null;
        });
        Assertions.assertNull((Object)registry.get("o1", noteId, null));
        Assertions.assertNotNull((Object)registry.get("o2", noteId, null));
        Assertions.assertNotNull((Object)registry.get("o3", null, null));
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testAngularObjectRemovalOnInterpreterRestart() throws InterruptedException, IOException, InterpreterException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            AngularObjectRegistry registry = ((InterpreterSetting)note.getBindedInterpreterSettings(new ArrayList()).get(0)).getOrCreateInterpreterGroup(this.anonymous.getUser(), note.getId()).getAngularObjectRegistry();
            registry.add("o1", (Object)"object1", note.getId(), null);
            registry.add("o2", (Object)"object2", null, null);
            try {
                this.interpreterSettingManager.restart(((InterpreterSetting)note.getBindedInterpreterSettings(new ArrayList()).get(0)).getId());
            }
            catch (InterpreterException e) {
                Assertions.fail();
            }
            registry = ((InterpreterSetting)note.getBindedInterpreterSettings(new ArrayList()).get(0)).getOrCreateInterpreterGroup(this.anonymous.getUser(), note.getId()).getAngularObjectRegistry();
            Assertions.assertNull((Object)registry.get("o1", note.getId(), null));
            Assertions.assertNull((Object)registry.get("o2", null, null));
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testPermissions() throws IOException {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        Assertions.assertTrue((boolean)this.authorizationService.isOwner(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isRunner(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isWriter(noteId, new HashSet<String>(Arrays.asList("user2"))));
        this.authorizationService.setOwners(noteId, new HashSet<String>(Arrays.asList("user1")));
        this.authorizationService.setReaders(noteId, new HashSet<String>(Arrays.asList("user1", "user2")));
        this.authorizationService.setRunners(noteId, new HashSet<String>(Arrays.asList("user3")));
        this.authorizationService.setWriters(noteId, new HashSet<String>(Arrays.asList("user1")));
        Assertions.assertFalse((boolean)this.authorizationService.isOwner(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isOwner(noteId, new HashSet<String>(Arrays.asList("user1"))));
        Assertions.assertFalse((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user4"))));
        Assertions.assertTrue((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isRunner(noteId, new HashSet<String>(Arrays.asList("user3"))));
        Assertions.assertFalse((boolean)this.authorizationService.isRunner(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertFalse((boolean)this.authorizationService.isWriter(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isWriter(noteId, new HashSet<String>(Arrays.asList("user1"))));
        this.authorizationService.setReaders(noteId, new HashSet());
        Assertions.assertTrue((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertTrue((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user4"))));
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testAuthorizationRoles() throws IOException {
        String user1 = "user1";
        String user2 = "user2";
        HashSet<String> roles = new HashSet<String>(Arrays.asList("admin"));
        this.authorizationService.setRoles(user1, roles);
        this.authorizationService.setRoles(user2, roles);
        String noteId = this.notebook.createNote("note1", new AuthenticationInfo(user1));
        Assertions.assertTrue((boolean)this.authorizationService.isOwner(noteId, new HashSet<String>(Arrays.asList(user1))));
        Assertions.assertTrue((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList(user1))));
        Assertions.assertTrue((boolean)this.authorizationService.isRunner(noteId, new HashSet<String>(Arrays.asList(user2))));
        Assertions.assertTrue((boolean)this.authorizationService.isWriter(noteId, new HashSet<String>(Arrays.asList(user1))));
        Assertions.assertFalse((boolean)this.authorizationService.isOwner(noteId, new HashSet<String>(Arrays.asList(user2))));
        Assertions.assertTrue((boolean)this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList(user2))));
        Assertions.assertTrue((boolean)this.authorizationService.isRunner(noteId, new HashSet<String>(Arrays.asList(user2))));
        Assertions.assertTrue((boolean)this.authorizationService.isWriter(noteId, new HashSet<String>(Arrays.asList(user2))));
        Set user1AndRoles = this.authorizationService.getRoles(user1);
        user1AndRoles.add(user1);
        List user1Notes = this.notebook.getNotesInfo(noteIdTmp -> this.authorizationService.isReader(noteIdTmp, user1AndRoles));
        Assertions.assertEquals((int)1, (int)user1Notes.size());
        Assertions.assertEquals((Object)((NoteInfo)user1Notes.get(0)).getId(), (Object)noteId);
        Set user2AndRoles = this.authorizationService.getRoles(user2);
        user2AndRoles.add(user2);
        List user2Notes = this.notebook.getNotesInfo(noteIdTmp -> this.authorizationService.isReader(noteIdTmp, user2AndRoles));
        Assertions.assertEquals((int)1, (int)user2Notes.size());
        Assertions.assertEquals((Object)((NoteInfo)user2Notes.get(0)).getId(), (Object)noteId);
    }

    @Test
    public void testInterpreterSettingConfig() {
        LOGGER.info("testInterpreterSettingConfig >>> ");
        Note note = new Note("testInterpreterSettingConfig", "config_test", this.interpreterFactory, this.interpreterSettingManager, (ParagraphJobListener)this, this.credentials, new ArrayList());
        Paragraph p1 = note.addNewParagraph(this.anonymous);
        Map config = p1.getConfig();
        Assertions.assertTrue((boolean)config.containsKey(InterpreterSetting.PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE));
        Assertions.assertTrue((boolean)config.containsKey(InterpreterSetting.PARAGRAPH_CONFIG_TITLE));
        Assertions.assertTrue((boolean)config.containsKey(InterpreterSetting.PARAGRAPH_CONFIG_CHECK_EMTPY));
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE));
        Assertions.assertEquals((Object)true, config.get(InterpreterSetting.PARAGRAPH_CONFIG_TITLE));
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_CHECK_EMTPY));
        p1.setText("%config_test sleep 1000");
        p1.execute(true);
        LOGGER.info("p1.getConfig() =  " + p1.getConfig());
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE));
        Assertions.assertEquals((Object)true, config.get(InterpreterSetting.PARAGRAPH_CONFIG_TITLE));
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_CHECK_EMTPY));
        p1.setText("%mock1 sleep 1000");
        p1.execute(true);
        LOGGER.info("changed intp p1.getConfig() =  " + p1.getConfig());
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE));
        Assertions.assertEquals((Object)true, config.get(InterpreterSetting.PARAGRAPH_CONFIG_TITLE));
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_CHECK_EMTPY));
        p1.getConfig().put(InterpreterSetting.PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE, true);
        p1.getConfig().put(InterpreterSetting.PARAGRAPH_CONFIG_TITLE, false);
        p1.setText("%mock1 sleep 1000");
        p1.execute(true);
        LOGGER.info("changed intp p1.getConfig() =  " + p1.getConfig());
        Assertions.assertEquals((Object)true, config.get(InterpreterSetting.PARAGRAPH_CONFIG_RUNONSELECTIONCHANGE));
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_TITLE));
        Assertions.assertEquals((Object)false, config.get(InterpreterSetting.PARAGRAPH_CONFIG_CHECK_EMTPY));
    }

    @Test
    public void testAbortParagraphStatusOnInterpreterRestart() throws Exception {
        String noteId = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.addNewParagraph(this.anonymous);
            p1.setText("%mock1 sleep 1000");
            Paragraph p2 = note.addNewParagraph(this.anonymous);
            p2.setText("%mock1 sleep 1000");
            Paragraph p3 = note.addNewParagraph(this.anonymous);
            p3.setText("%mock1 sleep 1000");
            try {
                note.runAll(AuthenticationInfo.ANONYMOUS, false, false, new HashMap());
            }
            catch (Exception e1) {
                Assertions.fail();
            }
            while (p1.getStatus() != Job.Status.FINISHED || p2.getStatus() != Job.Status.RUNNING) {
                Thread.yield();
            }
            Assertions.assertEquals((Object)Job.Status.FINISHED, (Object)p1.getStatus());
            Assertions.assertEquals((Object)Job.Status.RUNNING, (Object)p2.getStatus());
            Assertions.assertEquals((Object)Job.Status.READY, (Object)p3.getStatus());
            try {
                this.interpreterSettingManager.restart(this.interpreterSettingManager.getInterpreterSettingByName("mock1").getId());
            }
            catch (InterpreterException e) {
                Assertions.fail();
            }
            Assertions.assertEquals((Object)Job.Status.FINISHED, (Object)p1.getStatus());
            Assertions.assertEquals((Object)Job.Status.ABORT, (Object)p2.getStatus());
            Assertions.assertEquals((Object)Job.Status.READY, (Object)p3.getStatus());
            return null;
        });
        this.notebook.removeNote(noteId, this.anonymous);
    }

    @Test
    public void testPerSessionInterpreterCloseOnNoteRemoval() throws IOException, InterpreterException {
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        InterpreterResult result = (InterpreterResult)this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p1.setText("%mock1 getId");
            p1.setAuthenticationInfo(this.anonymous);
            for (InterpreterSetting setting : note1.getBindedInterpreterSettings(new ArrayList())) {
                setting.getOption().setPerNote("scoped");
                try {
                    this.notebook.getInterpreterSettingManager().restart(setting.getId());
                }
                catch (InterpreterException e) {
                    Assertions.fail();
                }
            }
            note1.run(p1.getId());
            while (p1.getStatus() != Job.Status.FINISHED) {
                Thread.yield();
            }
            return p1.getReturn();
        });
        this.notebook.removeNote(note1Id, this.anonymous);
        note1Id = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p1.setText("%mock1 getId");
            p1.setAuthenticationInfo(this.anonymous);
            note1.run(p1.getId());
            while (p1.getStatus() != Job.Status.FINISHED) {
                Thread.yield();
            }
            Assertions.assertNotEquals((Object)p1.getReturn().message(), (Object)result.message());
            return null;
        });
        this.notebook.removeNote(note1Id, this.anonymous);
    }

    @Test
    public void testPerSessionInterpreter() throws IOException, InterpreterException {
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            String note2Id = this.notebook.createNote("note2", this.anonymous);
            this.notebook.processNote(note2Id, note2 -> {
                Paragraph p2 = note2.addNewParagraph(AuthenticationInfo.ANONYMOUS);
                p1.setText("%mock1 getId");
                p1.setAuthenticationInfo(this.anonymous);
                p2.setText("%mock1 getId");
                p2.setAuthenticationInfo(this.anonymous);
                note1.run(p1.getId());
                note2.run(p2.getId());
                while (p1.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                while (p2.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                Assertions.assertEquals((Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
                for (InterpreterSetting setting : note1.getBindedInterpreterSettings(new ArrayList())) {
                    setting.getOption().setPerNote("scoped");
                    try {
                        this.notebook.getInterpreterSettingManager().restart(setting.getId());
                    }
                    catch (InterpreterException e) {
                        Assertions.fail();
                    }
                }
                note1.run(p1.getId());
                note2.run(p2.getId());
                while (p1.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                while (p2.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                Assertions.assertNotEquals((Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
                return null;
            });
            this.notebook.removeNote(note2Id, this.anonymous);
            return null;
        });
        this.notebook.removeNote(note1Id, this.anonymous);
    }

    @Test
    public void testPerNoteSessionInterpreter() throws IOException, InterpreterException {
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            String note2Id = this.notebook.createNote("note2", this.anonymous);
            this.notebook.processNote(note2Id, note2 -> {
                Paragraph p2 = note2.addNewParagraph(AuthenticationInfo.ANONYMOUS);
                p1.setText("%mock1 getId");
                p1.setAuthenticationInfo(this.anonymous);
                p2.setText("%mock1 getId");
                p2.setAuthenticationInfo(this.anonymous);
                note1.run(p1.getId());
                note2.run(p2.getId());
                while (p1.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                while (p2.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                Assertions.assertEquals((Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
                for (InterpreterSetting setting : note1.getBindedInterpreterSettings(new ArrayList())) {
                    setting.getOption().setPerNote("scoped");
                    try {
                        this.notebook.getInterpreterSettingManager().restart(setting.getId());
                    }
                    catch (InterpreterException e) {
                        Assertions.fail();
                    }
                }
                note1.run(p1.getId());
                note2.run(p2.getId());
                while (p1.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                while (p2.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                Assertions.assertNotEquals((Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
                for (InterpreterSetting setting : note1.getBindedInterpreterSettings(new ArrayList())) {
                    setting.getOption().setPerNote("isolated");
                    try {
                        setting.getInterpreterSettingManager().restart(setting.getId());
                    }
                    catch (InterpreterException e) {
                        Assertions.fail();
                    }
                }
                note1.run(p1.getId());
                note2.run(p2.getId());
                while (p1.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                while (p2.getStatus() != Job.Status.FINISHED) {
                    Thread.yield();
                }
                Assertions.assertNotEquals((Object)((InterpreterResultMessage)p1.getReturn().message().get(0)).getData(), (Object)((InterpreterResultMessage)p2.getReturn().message().get(0)).getData());
                return null;
            });
            this.notebook.removeNote(note2Id, this.anonymous);
            return null;
        });
        this.notebook.removeNote(note1Id, this.anonymous);
    }

    public void testNotebookEventListener() throws IOException {
        final AtomicInteger onNoteRemove = new AtomicInteger(0);
        final AtomicInteger onNoteCreate = new AtomicInteger(0);
        final AtomicInteger onParagraphRemove = new AtomicInteger(0);
        final AtomicInteger onParagraphCreate = new AtomicInteger(0);
        this.notebook.addNotebookEventListener(new NoteEventListener(){

            public void onNoteRemove(Note note, AuthenticationInfo subject) {
                onNoteRemove.incrementAndGet();
            }

            public void onNoteCreate(Note note, AuthenticationInfo subject) {
                onNoteCreate.incrementAndGet();
            }

            public void onNoteUpdate(Note note, AuthenticationInfo subject) {
            }

            public void onParagraphRemove(Paragraph p) {
                onParagraphRemove.incrementAndGet();
            }

            public void onParagraphCreate(Paragraph p) {
                onParagraphCreate.incrementAndGet();
            }

            public void onParagraphUpdate(Paragraph p) {
            }

            public void onParagraphStatusChange(Paragraph p, Job.Status status) {
            }
        });
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        Assertions.assertEquals((int)1, (int)onNoteCreate.get());
        this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Assertions.assertEquals((int)1, (int)onParagraphCreate.get());
            note1.addCloneParagraph(p1, AuthenticationInfo.ANONYMOUS);
            Assertions.assertEquals((int)2, (int)onParagraphCreate.get());
            note1.removeParagraph(this.anonymous.getUser(), p1.getId());
            Assertions.assertEquals((int)1, (int)onParagraphRemove.get());
            return null;
        });
        this.notebook.removeNote(note1Id, this.anonymous);
        Assertions.assertEquals((int)1, (int)onNoteRemove.get());
        Assertions.assertEquals((int)1, (int)onParagraphRemove.get());
    }

    @Test
    public void testGetAllNotes() throws Exception {
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        String note2Id = this.notebook.createNote("note2", this.anonymous);
        Assertions.assertEquals((int)2, (int)this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("anonymous")))).size());
        this.authorizationService.setOwners(note1Id, new HashSet<String>(Arrays.asList("user1")));
        this.authorizationService.setWriters(note1Id, new HashSet<String>(Arrays.asList("user1")));
        this.authorizationService.setRunners(note1Id, new HashSet<String>(Arrays.asList("user1")));
        this.authorizationService.setReaders(note1Id, new HashSet<String>(Arrays.asList("user1")));
        Assertions.assertEquals((int)1, (int)this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("anonymous")))).size());
        Assertions.assertEquals((int)2, (int)this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1")))).size());
        this.authorizationService.setOwners(note2Id, new HashSet<String>(Arrays.asList("user2")));
        this.authorizationService.setWriters(note2Id, new HashSet<String>(Arrays.asList("user2")));
        this.authorizationService.setReaders(note2Id, new HashSet<String>(Arrays.asList("user2")));
        this.authorizationService.setRunners(note2Id, new HashSet<String>(Arrays.asList("user2")));
        Assertions.assertEquals((int)0, (int)this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("anonymous")))).size());
        Assertions.assertEquals((int)1, (int)this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1")))).size());
        Assertions.assertEquals((int)1, (int)this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2")))).size());
        this.notebook.removeNote(note1Id, AuthenticationInfo.ANONYMOUS);
        this.notebook.removeNote(note2Id, AuthenticationInfo.ANONYMOUS);
    }

    @Test
    public void testCreateDuplicateNote() throws Exception {
        String note1Id = this.notebook.createNote("note1", this.anonymous);
        try {
            this.notebook.createNote("note1", this.anonymous);
            Assertions.fail((String)"Should not be able to create same note 'note1'");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Note '/note1' existed"));
        }
        finally {
            this.notebook.removeNote(note1Id, this.anonymous);
        }
    }

    @Test
    public void testGetAllNotesWithDifferentPermissions() throws IOException {
        List notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        List notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)0, (int)notes1.size());
        Assertions.assertEquals((int)0, (int)notes2.size());
        String note1Id = this.notebook.createNote("note1", new AuthenticationInfo("user1"));
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)1, (int)notes1.size());
        Assertions.assertEquals((int)1, (int)notes2.size());
        this.authorizationService.setReaders(note1Id, new HashSet<String>(Arrays.asList("user1")));
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)1, (int)notes1.size());
        Assertions.assertEquals((int)1, (int)notes2.size());
        this.authorizationService.setRunners(note1Id, new HashSet<String>(Arrays.asList("user1")));
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)1, (int)notes1.size());
        Assertions.assertEquals((int)1, (int)notes2.size());
        this.authorizationService.setWriters(note1Id, new HashSet<String>(Arrays.asList("user1")));
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)1, (int)notes1.size());
        Assertions.assertEquals((int)0, (int)notes2.size());
    }

    @Test
    public void testPublicPrivateNewNote() throws IOException {
        Assertions.assertTrue((boolean)this.conf.isNotebookPublic());
        Assertions.assertTrue((boolean)this.authorizationService.isPublic());
        List notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        List notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)0, (int)notes1.size());
        Assertions.assertEquals((int)0, (int)notes2.size());
        String notePublicId = this.notebook.createNote("note1", new AuthenticationInfo("user1"));
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)1, (int)notes1.size());
        Assertions.assertEquals((int)1, (int)notes2.size());
        Assertions.assertEquals((Object)((NoteInfo)notes1.get(0)).getId(), (Object)notePublicId);
        Assertions.assertEquals((Object)((NoteInfo)notes2.get(0)).getId(), (Object)notePublicId);
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(notePublicId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getReaders(notePublicId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getRunners(notePublicId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getWriters(notePublicId).size());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_PUBLIC.getVarName(), "false");
        ZeppelinConfiguration conf2 = ZeppelinConfiguration.create();
        Assertions.assertFalse((boolean)conf2.isNotebookPublic());
        Assertions.assertFalse((boolean)this.authorizationService.isPublic());
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)1, (int)notes1.size());
        Assertions.assertEquals((int)1, (int)notes2.size());
        String notePrivateId = this.notebook.createNote("note2", new AuthenticationInfo("user1"));
        notes1 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user1"))));
        notes2 = this.notebook.getNotesInfo(noteId -> this.authorizationService.isReader(noteId, new HashSet<String>(Arrays.asList("user2"))));
        Assertions.assertEquals((int)2, (int)notes1.size());
        Assertions.assertEquals((int)1, (int)notes2.size());
        boolean found = false;
        for (NoteInfo info : notes1) {
            if (info.getId() != notePrivateId) continue;
            found = true;
            break;
        }
        Assertions.assertEquals((Object)true, (Object)found);
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(notePrivateId).size());
        Assertions.assertEquals((int)1, (int)this.authorizationService.getReaders(notePrivateId).size());
        Assertions.assertEquals((int)1, (int)this.authorizationService.getRunners(notePrivateId).size());
        Assertions.assertEquals((int)1, (int)this.authorizationService.getWriters(notePrivateId).size());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_PUBLIC.getVarName(), "true");
        ZeppelinConfiguration.create();
    }

    @Test
    public void testCloneImportCheck() throws IOException {
        String sourceNoteId = this.notebook.createNote("note1", new AuthenticationInfo("user"));
        this.notebook.processNote(sourceNoteId, sourceNote -> {
            sourceNote.setName("TestNote");
            Assertions.assertEquals((Object)"TestNote", (Object)sourceNote.getName());
            Paragraph sourceParagraph = sourceNote.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Assertions.assertEquals((Object)"anonymous", (Object)sourceParagraph.getUser());
            String destNoteId = this.notebook.createNote("note2", new AuthenticationInfo("user"));
            this.notebook.processNote(destNoteId, destNote -> {
                destNote.setName("ClonedNote");
                Assertions.assertEquals((Object)"ClonedNote", (Object)destNote.getName());
                CopyOnWriteArrayList paragraphs = sourceNote.getParagraphs();
                for (Paragraph p : paragraphs) {
                    destNote.addCloneParagraph(p, AuthenticationInfo.ANONYMOUS);
                    Assertions.assertEquals((Object)"anonymous", (Object)p.getUser());
                }
                return null;
            });
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"provideMoveTestParameters"})
    public void testMoveNote(String oldName, String newPath) throws InterruptedException, IOException {
        String noteId = null;
        String newName = FilenameUtils.getBaseName((String)newPath);
        try {
            noteId = this.notebook.createNote(oldName, this.anonymous);
            this.notebook.processNote(noteId, note -> {
                Assertions.assertEquals((Object)oldName, (Object)note.getName());
                Assertions.assertEquals((Object)("/" + oldName), (Object)note.getPath());
                return null;
            });
            this.notebook.moveNote(noteId, newPath, this.anonymous);
            File noteFile = (File)this.notebook.processNote(noteId, note -> new File(this.conf.getNotebookDir() + "/" + this.notebookRepo.buildNoteFileName(note)));
            String noteJson = IOUtils.toString((InputStream)new FileInputStream(noteFile), (Charset)StandardCharsets.UTF_8);
            Assertions.assertTrue((boolean)noteJson.contains(newName), (String)noteJson);
        }
        finally {
            if (noteId != null) {
                this.notebook.removeNote(noteId, this.anonymous);
            }
        }
    }

    private static Stream<Arguments> provideMoveTestParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"note1", "/temp/note2"}), Arguments.of((Object[])new Object[]{"note1", "/Note1"}), Arguments.of((Object[])new Object[]{"note1", "/temp/Note1"}));
    }

    public void noteRunningStatusChange(String noteId, boolean newStatus) {
    }

    public void onProgressUpdate(Job<?> paragraph, int progress) {
    }

    public void onStatusChange(Job<?> paragraph, Job.Status before, Job.Status after) {
        if (this.afterStatusChangedListener != null) {
            this.afterStatusChangedListener.onStatusChanged(paragraph, before, after);
        }
    }

    private static interface StatusChangedListener {
        public void onStatusChanged(Job<?> var1, Job.Status var2, Job.Status var3);
    }

    public static class DummyNotebookRepoWithVersionControl
    implements NotebookRepoWithVersionControl {
        public NotebookRepoWithVersionControl.Revision checkpoint(String noteId, String notePath, String checkpointMsg, AuthenticationInfo subject) throws IOException {
            return null;
        }

        public Note get(String noteId, String notePath, String revId, AuthenticationInfo subject) throws IOException {
            return null;
        }

        public List<NotebookRepoWithVersionControl.Revision> revisionHistory(String noteId, String notePath, AuthenticationInfo subject) {
            return null;
        }

        public Note setNoteRevision(String noteId, String notePath, String revId, AuthenticationInfo subject) throws IOException {
            return null;
        }

        public void init(ZeppelinConfiguration zConf) throws IOException {
        }

        public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
            return new HashMap<String, NoteInfo>();
        }

        public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
            return null;
        }

        public void save(Note note, AuthenticationInfo subject) throws IOException {
        }

        public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) {
        }

        public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) {
        }

        public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        }

        public void remove(String folderPath, AuthenticationInfo subject) {
        }

        public void close() {
        }

        public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
            return Collections.emptyList();
        }

        public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        }
    }

    public static class DummyNotebookRepo
    implements NotebookRepo {
        public void init(ZeppelinConfiguration zConf) throws IOException {
        }

        public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
            return new HashMap<String, NoteInfo>();
        }

        public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
            return null;
        }

        public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) {
        }

        public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) {
        }

        public void save(Note note, AuthenticationInfo subject) throws IOException {
        }

        public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        }

        public void remove(String folderPath, AuthenticationInfo subject) {
        }

        public void close() {
        }

        public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
            return Collections.emptyList();
        }

        public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        }
    }
}

