/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectBuilder;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ParagraphTest
extends AbstractInterpreterTest {
    @Test
    public void scriptBodyWithReplName() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("%test (1234567");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"(1234567", (Object)paragraph.getScriptText());
        paragraph.setText("%test 1234567");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"1234567", (Object)paragraph.getScriptText());
    }

    @Test
    public void scriptBodyWithoutReplName() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("1234567");
        Assertions.assertEquals((Object)"", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"1234567", (Object)paragraph.getScriptText());
    }

    @Test
    public void replNameAndNoBody() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("%test");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"", (Object)paragraph.getScriptText());
    }

    @Test
    public void replSingleCharName() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("%r a");
        Assertions.assertEquals((Object)"r", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"a", (Object)paragraph.getScriptText());
    }

    @Test
    public void testParagraphProperties() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("%test(p1=v1,p2=v2) a");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"a", (Object)paragraph.getScriptText());
        Assertions.assertEquals((int)2, (int)paragraph.getLocalProperties().size());
        Assertions.assertEquals((Object)"v1", paragraph.getLocalProperties().get("p1"));
        Assertions.assertEquals((Object)"v2", paragraph.getLocalProperties().get("p2"));
        paragraph.setText("%test(p1=v1,  p2=v2) a");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"a", (Object)paragraph.getScriptText());
        Assertions.assertEquals((int)2, (int)paragraph.getLocalProperties().size());
        Assertions.assertEquals((Object)"v1", paragraph.getLocalProperties().get("p1"));
        Assertions.assertEquals((Object)"v2", paragraph.getLocalProperties().get("p2"));
        paragraph.setText("%test() a");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"a", (Object)paragraph.getScriptText());
        Assertions.assertEquals((int)0, (int)paragraph.getLocalProperties().size());
    }

    @Test
    public void testInvalidProperties() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Note note = this.createNote();
            Paragraph paragraph = new Paragraph(note, null);
            paragraph.setText("%test(p1=v1=v2) a");
        }, (String)"Invalid paragraph properties format");
    }

    @Test
    public void replInvalid() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("foo %r");
        Assertions.assertEquals((Object)"", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"foo %r", (Object)paragraph.getScriptText());
        paragraph.setText("foo%r");
        Assertions.assertEquals((Object)"", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"foo%r", (Object)paragraph.getScriptText());
        paragraph.setText("% foo");
        Assertions.assertEquals((Object)"", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"% foo", (Object)paragraph.getScriptText());
    }

    @Test
    public void replNameEndsWithWhitespace() {
        Note note = this.createNote();
        Paragraph paragraph = new Paragraph(note, null);
        paragraph.setText("%test\r\n###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"\r\n###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("%test\t###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"\t###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("%test\u000b###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"\u000b###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("%test\f###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"\f###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("%test\n###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"\n###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("%test ###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"###Hello", (Object)paragraph.getScriptText());
        paragraph.setText(" %test ###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("\n\r%test ###Hello");
        Assertions.assertEquals((Object)"test", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"###Hello", (Object)paragraph.getScriptText());
        paragraph.setText("%\r\n###Hello");
        Assertions.assertEquals((Object)"", (Object)paragraph.getIntpText());
        Assertions.assertEquals((Object)"%\r\n###Hello", (Object)paragraph.getScriptText());
    }

    @Test
    public void should_extract_variable_from_angular_object_registry() throws Exception {
        String noteId = "noteId";
        AngularObjectRegistry registry = (AngularObjectRegistry)Mockito.mock(AngularObjectRegistry.class);
        Note note = (Note)Mockito.mock(Note.class);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("name", null);
        inputs.put("age", null);
        inputs.put("job", null);
        String scriptBody = "My name is ${name} and I am ${age=20} years old. My occupation is ${ job = engineer | developer | artists}";
        Paragraph paragraph = new Paragraph(note, null);
        String paragraphId = paragraph.getId();
        AngularObject<String> nameAO = AngularObjectBuilder.build("name", "DuyHai DOAN", "noteId", paragraphId);
        AngularObject<Integer> ageAO = AngularObjectBuilder.build("age", 34, "noteId", null);
        Mockito.when((Object)note.getId()).thenReturn((Object)"noteId");
        Mockito.when((Object)registry.get("name", "noteId", paragraphId)).thenReturn(nameAO);
        Mockito.when((Object)registry.get("age", "noteId", null)).thenReturn(ageAO);
        String expected = "My name is DuyHai DOAN and I am 34 years old. My occupation is ${ job = engineer | developer | artists}";
        String actual = paragraph.extractVariablesFromAngularRegistry("My name is ${name} and I am ${age=20} years old. My occupation is ${ job = engineer | developer | artists}", inputs, registry);
        ((AngularObjectRegistry)Mockito.verify((Object)registry)).get("name", "noteId", paragraphId);
        ((AngularObjectRegistry)Mockito.verify((Object)registry)).get("age", "noteId", null);
        Assertions.assertEquals((Object)actual, (Object)"My name is DuyHai DOAN and I am 34 years old. My occupation is ${ job = engineer | developer | artists}");
    }

    @Test
    public void returnDefaultParagraphWithNewUser() {
        Paragraph p = new Paragraph("para_1", null, null);
        String defaultValue = "Default Value";
        p.setResult(new InterpreterResult(InterpreterResult.Code.SUCCESS, defaultValue));
        Paragraph newUserParagraph = p.getUserParagraph("new_user");
        Assertions.assertNotNull((Object)newUserParagraph);
        Assertions.assertEquals((Object)defaultValue, (Object)((InterpreterResultMessage)newUserParagraph.getReturn().message().get(0)).getData());
    }

    @Disabled
    public void returnUnchangedResultsWithDifferentUser() throws Throwable {
        Note mockNote = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)mockNote.getCredentials()).thenReturn((Object)((Credentials)Mockito.mock(Credentials.class)));
        Paragraph spyParagraph = (Paragraph)Mockito.spy((Object)new Paragraph("para_1", mockNote, null));
        Interpreter mockInterpreter = (Interpreter)Mockito.mock(Interpreter.class);
        spyParagraph.setInterpreter(mockInterpreter);
        ((Paragraph)Mockito.doReturn((Object)mockInterpreter).when((Object)spyParagraph)).getBindedInterpreter();
        ManagedInterpreterGroup mockInterpreterGroup = (ManagedInterpreterGroup)Mockito.mock(ManagedInterpreterGroup.class);
        Mockito.when((Object)mockInterpreter.getInterpreterGroup()).thenReturn((Object)mockInterpreterGroup);
        Mockito.when((Object)mockInterpreterGroup.getId()).thenReturn((Object)"mock_id_1");
        Mockito.when((Object)mockInterpreterGroup.getAngularObjectRegistry()).thenReturn((Object)((AngularObjectRegistry)Mockito.mock(AngularObjectRegistry.class)));
        Mockito.when((Object)mockInterpreterGroup.getResourcePool()).thenReturn((Object)((ResourcePool)Mockito.mock(ResourcePool.class)));
        List spyInterpreterSettingList = (List)Mockito.spy(new ArrayList());
        InterpreterSetting mockInterpreterSetting = (InterpreterSetting)Mockito.mock(InterpreterSetting.class);
        Mockito.when((Object)mockInterpreterGroup.getInterpreterSetting()).thenReturn((Object)mockInterpreterSetting);
        InterpreterOption mockInterpreterOption = (InterpreterOption)Mockito.mock(InterpreterOption.class);
        Mockito.when((Object)mockInterpreterSetting.getOption()).thenReturn((Object)mockInterpreterOption);
        Mockito.when((Object)mockInterpreterOption.permissionIsSet()).thenReturn((Object)false);
        Mockito.when((Object)mockInterpreterSetting.getStatus()).thenReturn((Object)InterpreterSetting.Status.READY);
        Mockito.when((Object)mockInterpreterSetting.getId()).thenReturn((Object)"mock_id_1");
        Mockito.when((Object)mockInterpreterSetting.getOrCreateInterpreterGroup(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)mockInterpreterGroup);
        Mockito.when((Object)mockInterpreterSetting.isUserAuthorized((List)ArgumentMatchers.any(List.class))).thenReturn((Object)true);
        spyInterpreterSettingList.add(mockInterpreterSetting);
        Mockito.when((Object)mockNote.getId()).thenReturn((Object)"any_id");
        Mockito.when((Object)mockInterpreter.getFormType()).thenReturn((Object)Interpreter.FormType.NONE);
        ParagraphJobListener mockJobListener = (ParagraphJobListener)Mockito.mock(ParagraphJobListener.class);
        ((Paragraph)Mockito.doReturn((Object)mockJobListener).when((Object)spyParagraph)).getListener();
        InterpreterResult mockInterpreterResult = (InterpreterResult)Mockito.mock(InterpreterResult.class);
        Mockito.when((Object)mockInterpreter.interpret(ArgumentMatchers.anyString(), (InterpreterContext)Mockito.any())).thenReturn((Object)mockInterpreterResult);
        Mockito.when((Object)mockInterpreterResult.code()).thenReturn((Object)InterpreterResult.Code.SUCCESS);
        ArrayList<InterpreterResultMessage> result1 = new ArrayList<InterpreterResultMessage>();
        result1.add(new InterpreterResultMessage(InterpreterResult.Type.TEXT, "result1"));
        Mockito.when((Object)mockInterpreterResult.message()).thenReturn(result1);
        AuthenticationInfo user1 = new AuthenticationInfo("user1");
        spyParagraph.setAuthenticationInfo(user1);
        spyParagraph.jobRun();
        Paragraph p1 = spyParagraph.getUserParagraph(user1.getUser());
        mockInterpreterResult = (InterpreterResult)Mockito.mock(InterpreterResult.class);
        Mockito.when((Object)mockInterpreter.interpret(ArgumentMatchers.anyString(), (InterpreterContext)Mockito.any())).thenReturn((Object)mockInterpreterResult);
        Mockito.when((Object)mockInterpreterResult.code()).thenReturn((Object)InterpreterResult.Code.SUCCESS);
        ArrayList<InterpreterResultMessage> result2 = new ArrayList<InterpreterResultMessage>();
        result2.add(new InterpreterResultMessage(InterpreterResult.Type.TEXT, "result2"));
        Mockito.when((Object)mockInterpreterResult.message()).thenReturn(result2);
        AuthenticationInfo user2 = new AuthenticationInfo("user2");
        spyParagraph.setAuthenticationInfo(user2);
        spyParagraph.jobRun();
        Paragraph p2 = spyParagraph.getUserParagraph(user2.getUser());
        Assertions.assertNotEquals((Object)p1.getReturn().toString(), (Object)p2.getReturn().toString());
        Assertions.assertEquals((Object)p1, (Object)spyParagraph.getUserParagraph(user1.getUser()));
    }

    @Test
    public void testCursorPosition() {
        Paragraph paragraph = (Paragraph)Mockito.spy((Object)new Paragraph());
        List<Triple> dataSet = Arrays.asList(Triple.of((Object)"%jdbc schema.", (Object)13, (Object)7), Triple.of((Object)"   %jdbc schema.", (Object)16, (Object)7), Triple.of((Object)" \n%jdbc schema.", (Object)15, (Object)7), Triple.of((Object)"%jdbc schema.table.  ", (Object)19, (Object)13), Triple.of((Object)"%jdbc schema.\n\n", (Object)13, (Object)7), Triple.of((Object)"  %jdbc schema.tab\n\n", (Object)18, (Object)10), Triple.of((Object)"  \n%jdbc schema.\n \n", (Object)16, (Object)7), Triple.of((Object)"  \n%jdbc schema.\n \n", (Object)16, (Object)7), Triple.of((Object)"  \n%jdbc\n\n schema\n \n", (Object)17, (Object)9), Triple.of((Object)"%another\n\n schema.", (Object)18, (Object)10), Triple.of((Object)"\n\n schema.", (Object)10, (Object)10), Triple.of((Object)"schema.", (Object)7, (Object)7), Triple.of((Object)"schema. \n", (Object)7, (Object)7), Triple.of((Object)"  \n   %jdbc", (Object)11, (Object)0), Triple.of((Object)"\n   %jdbc", (Object)9, (Object)0), Triple.of((Object)"%jdbc  \n  schema", (Object)16, (Object)9), Triple.of((Object)"%jdbc  \n  \n   schema", (Object)20, (Object)13));
        for (Triple data : dataSet) {
            paragraph.setText((String)data.getLeft());
            Integer actual = paragraph.calculateCursorPosition((String)data.getLeft(), ((Integer)data.getMiddle()).intValue());
            Assertions.assertEquals((Integer)((Integer)data.getRight()), (Integer)actual);
        }
    }

    @Test
    public void credentialReplacement() throws Throwable {
        Note mockNote = (Note)Mockito.mock(Note.class);
        Credentials creds = (Credentials)Mockito.mock(Credentials.class);
        Mockito.when((Object)mockNote.getCredentials()).thenReturn((Object)creds);
        Paragraph spyParagraph = (Paragraph)Mockito.spy((Object)new Paragraph("para_1", mockNote, null));
        UserCredentials uc = (UserCredentials)Mockito.mock(UserCredentials.class);
        Mockito.when((Object)creds.getUserCredentials(ArgumentMatchers.anyString())).thenReturn((Object)uc);
        UsernamePassword up = new UsernamePassword("user", "pwd");
        Mockito.when((Object)uc.getUsernamePassword("ent")).thenReturn((Object)up);
        Interpreter mockInterpreter = (Interpreter)Mockito.mock(Interpreter.class);
        spyParagraph.setInterpreter(mockInterpreter);
        ((Paragraph)Mockito.doReturn((Object)mockInterpreter).when((Object)spyParagraph)).getBindedInterpreter();
        InterpreterSetting mockInterpreterSetting = (InterpreterSetting)Mockito.mock(InterpreterSetting.class);
        Mockito.when((Object)mockInterpreterSetting.getStatus()).thenReturn((Object)InterpreterSetting.Status.READY);
        Mockito.when((Object)mockInterpreterSetting.isUserAuthorized(ArgumentMatchers.anyList())).thenReturn((Object)true);
        ManagedInterpreterGroup mockInterpreterGroup = (ManagedInterpreterGroup)Mockito.mock(ManagedInterpreterGroup.class);
        Mockito.when((Object)mockInterpreter.getInterpreterGroup()).thenReturn((Object)mockInterpreterGroup);
        Mockito.when((Object)mockInterpreterGroup.getId()).thenReturn((Object)"mock_id_1");
        Mockito.when((Object)mockInterpreterGroup.getAngularObjectRegistry()).thenReturn((Object)((AngularObjectRegistry)Mockito.mock(AngularObjectRegistry.class)));
        Mockito.when((Object)mockInterpreterGroup.getResourcePool()).thenReturn((Object)((ResourcePool)Mockito.mock(ResourcePool.class)));
        Mockito.when((Object)mockInterpreterGroup.getInterpreterSetting()).thenReturn((Object)mockInterpreterSetting);
        Mockito.when((Object)mockInterpreter.getFormType()).thenReturn((Object)Interpreter.FormType.NONE);
        ParagraphJobListener mockJobListener = (ParagraphJobListener)Mockito.mock(ParagraphJobListener.class);
        ((Paragraph)Mockito.doReturn((Object)mockJobListener).when((Object)spyParagraph)).getListener();
        InterpreterResult mockInterpreterResult = (InterpreterResult)Mockito.mock(InterpreterResult.class);
        Mockito.when((Object)mockInterpreter.interpret(ArgumentMatchers.anyString(), (InterpreterContext)Mockito.any())).thenReturn((Object)mockInterpreterResult);
        Mockito.when((Object)mockInterpreterResult.code()).thenReturn((Object)InterpreterResult.Code.SUCCESS);
        AuthenticationInfo user1 = new AuthenticationInfo("user1");
        spyParagraph.setAuthenticationInfo(user1);
        spyParagraph.setText("val x = \"usr={ent.user}&pass={ent.password}\"");
        Mockito.when((Object)mockInterpreter.getProperty("injectCredentials", "false")).thenReturn((Object)"false");
        spyParagraph.jobRun();
        ((Interpreter)Mockito.verify((Object)mockInterpreter)).interpret((String)ArgumentMatchers.eq((Object)"val x = \"usr={ent.user}&pass={ent.password}\""), (InterpreterContext)ArgumentMatchers.any(InterpreterContext.class));
        Mockito.when((Object)mockInterpreter.getProperty("injectCredentials", "false")).thenReturn((Object)"true");
        mockInterpreter.setProperty("injectCredentials", "false");
        spyParagraph.jobRun();
        ((Interpreter)Mockito.verify((Object)mockInterpreter)).interpret((String)ArgumentMatchers.eq((Object)"val x = \"usr=user&pass=pwd\""), (InterpreterContext)ArgumentMatchers.any(InterpreterContext.class));
        Mockito.when((Object)mockInterpreter.getProperty("injectCredentials", "false")).thenReturn((Object)"false");
        spyParagraph.getLocalProperties().put("injectCredentials", "true");
        spyParagraph.jobRun();
        ((Interpreter)Mockito.verify((Object)mockInterpreter, (VerificationMode)Mockito.times((int)2))).interpret((String)ArgumentMatchers.eq((Object)"val x = \"usr=user&pass=pwd\""), (InterpreterContext)ArgumentMatchers.any(InterpreterContext.class));
    }
}

