/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import org.apache.zeppelin.notebook.ParagraphTextParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParagraphTextParserTest {
    @Test
    public void testJupyter() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%jupyter(kernel=ir)");
        Assertions.assertEquals((Object)"jupyter", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)1, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"ir", parseResult.getLocalProperties().get("kernel"));
        Assertions.assertEquals((Object)"", (Object)parseResult.getScriptText());
    }

    @Test
    public void testCassandra() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%cassandra(locale=ru_RU, timeFormat=\"E, d MMM yy\", floatPrecision = 5, output=cql)\nselect * from system_auth.roles;");
        Assertions.assertEquals((Object)"cassandra", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)4, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"E, d MMM yy", parseResult.getLocalProperties().get("timeFormat"));
        Assertions.assertEquals((Object)"\nselect * from system_auth.roles;", (Object)parseResult.getScriptText());
    }

    @Test
    public void testSparkSubmit() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark-submit --class A a.jar");
        Assertions.assertEquals((Object)"spark-submit", (Object)parseResult.getIntpText());
        Assertions.assertEquals((Object)"--class A a.jar", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextLocalPropertiesAndText() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark(pool=pool_1) sc.version");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)1, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"pool_1", parseResult.getLocalProperties().get("pool"));
        Assertions.assertEquals((Object)"sc.version", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextLocalPropertiesNoText() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark(pool=pool_1)");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)1, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"pool_1", parseResult.getLocalProperties().get("pool"));
        Assertions.assertEquals((Object)"", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextLocalPropertyNoValueNoText() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark(pool)");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)1, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"pool", parseResult.getLocalProperties().get("pool"));
        Assertions.assertEquals((Object)"", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextNoLocalProperties() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark\nsc.version");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)0, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"\nsc.version", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphNoInterpreter() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"sc.version");
        Assertions.assertEquals((Object)"", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)0, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"sc.version", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphInterpreterWithoutProperties() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark() sc.version");
        Assertions.assertEquals((Object)"spark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)0, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"sc.version", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextQuotedPropertyValue1() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark(pool=\"value with = inside\")");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)1, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"value with = inside", parseResult.getLocalProperties().get("pool"));
        Assertions.assertEquals((Object)"", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextQuotedPropertyValue2() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark(pool=\"value with \\\" inside\", p=\"eol\\ninside\" )");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)2, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"value with \" inside", parseResult.getLocalProperties().get("pool"));
        Assertions.assertEquals((Object)"eol\ninside", parseResult.getLocalProperties().get("p"));
        Assertions.assertEquals((Object)"", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextQuotedPropertyKeyAndValue() {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse((String)"%spark.pyspark(\"po ol\"=\"value with \\\" inside\")");
        Assertions.assertEquals((Object)"spark.pyspark", (Object)parseResult.getIntpText());
        Assertions.assertEquals((int)1, (int)parseResult.getLocalProperties().size());
        Assertions.assertEquals((Object)"value with \" inside", parseResult.getLocalProperties().get("po ol"));
        Assertions.assertEquals((Object)"", (Object)parseResult.getScriptText());
    }

    @Test
    public void testParagraphTextUnfinishedConfig() {
        Assertions.assertThrows(RuntimeException.class, () -> ParagraphTextParser.parse((String)"%spark.pyspark(pool="), (String)"Problems by parsing paragraph. Not finished interpreter configuration");
    }

    @Test
    public void testParagraphTextUnfinishedQuote() {
        Assertions.assertThrows(RuntimeException.class, () -> ParagraphTextParser.parse((String)"%spark.pyspark(pool=\"2314234) sc.version"), (String)"Problems by parsing paragraph. Not finished interpreter configuration");
    }

    @Test
    public void testParagraphTextUnclosedBackslash() {
        Assertions.assertThrows(RuntimeException.class, () -> ParagraphTextParser.parse((String)"%spark.pyspark(pool=\\"), (String)"Problems by parsing paragraph. Unfinished escape sequence");
    }

    @Test
    public void testParagraphTextEmptyKey() {
        Assertions.assertThrows(RuntimeException.class, () -> ParagraphTextParser.parse((String)"%spark.pyspark(pool=123, ,)"), (String)"Problems by parsing paragraph. Local property key is empty");
    }
}

