/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.GitNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitNotebookRepoTest {
    private static final Logger LOG = LoggerFactory.getLogger(GitNotebookRepoTest.class);
    private static final String TEST_NOTE_ID = "2A94M5J1Z";
    private static final String TEST_NOTE_ID2 = "2A94M5J2Z";
    private static final String TEST_NOTE_PATH = "/my_project/my_note1";
    private static final String TEST_NOTE_PATH2 = "/my_project/my_note2";
    private File zeppelinDir;
    private String notebooksDir;
    private ZeppelinConfiguration conf;
    private GitNotebookRepo notebookRepo;

    @BeforeEach
    public void setUp() throws Exception {
        String zpath = System.getProperty("java.io.tmpdir") + "/ZeppelinTest_" + System.currentTimeMillis();
        this.zeppelinDir = new File(zpath);
        this.zeppelinDir.mkdirs();
        new File(this.zeppelinDir, "conf").mkdirs();
        this.notebooksDir = String.join((CharSequence)File.separator, zpath, "notebook");
        File notebookDir = new File(this.notebooksDir);
        notebookDir.mkdirs();
        FileUtils.copyDirectory((File)new File(GitNotebookRepoTest.class.getResource("/notebook").getFile()), (File)new File(this.notebooksDir));
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), this.zeppelinDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), notebookDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), "org.apache.zeppelin.notebook.repo.GitNotebookRepo");
        this.conf = ZeppelinConfiguration.create();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (!FileUtils.deleteQuietly((File)this.zeppelinDir)) {
            LOG.error("Failed to delete {} ", (Object)this.zeppelinDir.getName());
        }
    }

    @Test
    public void initNonemptyNotebookDir() throws IOException, GitAPIException {
        File dotGit = new File(String.join((CharSequence)File.separator, this.notebooksDir, ".git"));
        Assertions.assertFalse((boolean)dotGit.exists());
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Git git = this.notebookRepo.getGit();
        Assertions.assertNotNull((Object)git);
        Assertions.assertTrue((boolean)dotGit.exists());
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        List diff = git.diff().call();
        Assertions.assertFalse((boolean)diff.isEmpty());
    }

    @Test
    public void showNotebookHistoryEmptyTest() throws GitAPIException, IOException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        List testNotebookHistory = this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        Assertions.assertTrue((boolean)testNotebookHistory.isEmpty());
    }

    @Test
    public void showNotebookHistoryMultipleNotesTest() throws IOException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        Assertions.assertTrue((boolean)this.containsNote(this.notebookRepo.list(null), TEST_NOTE_ID));
        Assertions.assertTrue((boolean)this.containsNote(this.notebookRepo.list(null), TEST_NOTE_ID2));
        Assertions.assertTrue((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).isEmpty());
        Assertions.assertTrue((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID2, TEST_NOTE_PATH2, null).isEmpty());
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit, note1", null);
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        this.notebookRepo.checkpoint(TEST_NOTE_ID2, TEST_NOTE_PATH2, "first commit, note2", null);
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID2, TEST_NOTE_PATH2, null).size());
        Note note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config = p.getConfig();
        config.put("enabled", true);
        p.setConfig(config);
        p.setText("%md note1 test text");
        this.notebookRepo.save(note, null);
        Assertions.assertNotNull((Object)this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "second commit, note1", null));
        Assertions.assertEquals((int)2, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID2, TEST_NOTE_PATH2, null).size());
        Assertions.assertEquals((Object)NotebookRepoWithVersionControl.Revision.EMPTY, (Object)this.notebookRepo.checkpoint(TEST_NOTE_ID2, TEST_NOTE_PATH2, "first commit, note2", null));
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID2, TEST_NOTE_PATH2, null).size());
        note = this.notebookRepo.get(TEST_NOTE_ID2, TEST_NOTE_PATH2, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        config = p.getConfig();
        config.put("enabled", false);
        p.setConfig(config);
        p.setText("%md note2 test text");
        this.notebookRepo.save(note, null);
        Assertions.assertNotNull((Object)this.notebookRepo.checkpoint(TEST_NOTE_ID2, TEST_NOTE_PATH2, "second commit, note2", null));
        Assertions.assertEquals((int)2, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        Assertions.assertEquals((int)2, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID2, TEST_NOTE_PATH2, null).size());
    }

    @Test
    public void addCheckpointTest() throws IOException, GitAPIException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        Assertions.assertTrue((boolean)this.containsNote(this.notebookRepo.list(null), TEST_NOTE_ID));
        Assertions.assertTrue((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).isEmpty());
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit", null);
        List notebookHistoryBefore = this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        Assertions.assertFalse((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).isEmpty());
        int initialCount = notebookHistoryBefore.size();
        Note note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config = p.getConfig();
        config.put("enabled", true);
        p.setConfig(config);
        p.setText("%md checkpoint test text");
        this.notebookRepo.save(note, null);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "second commit", null);
        List notebookHistoryAfter = this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        Assertions.assertEquals((int)(initialCount + 1), (int)notebookHistoryAfter.size());
        int revCountBefore = 0;
        Iterable revCommits = this.notebookRepo.getGit().log().call();
        for (RevCommit revCommit : revCommits) {
            ++revCountBefore;
        }
        Note note2 = this.notebookRepo.get(TEST_NOTE_ID2, TEST_NOTE_PATH2, null);
        note2.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Paragraph p2 = note2.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config2 = p2.getConfig();
        config2.put("enabled", true);
        p2.setConfig(config);
        p2.setText("%md checkpoint test text");
        this.notebookRepo.save(note2, null);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "third commit", null);
        int revCountAfter = 0;
        revCommits = this.notebookRepo.getGit().log().call();
        for (RevCommit revCommit : revCommits) {
            ++revCountAfter;
        }
        Assertions.assertEquals((int)revCountBefore, (int)revCountAfter);
    }

    private boolean containsNote(Map<String, NoteInfo> notes, String noteId) {
        for (NoteInfo note : notes.values()) {
            if (!note.getId().equals(noteId)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void getRevisionTest() throws IOException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        Assertions.assertTrue((boolean)this.containsNote(this.notebookRepo.list(null), TEST_NOTE_ID));
        Assertions.assertTrue((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).isEmpty());
        NotebookRepoWithVersionControl.Revision revision_1 = this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit", null);
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        int paragraphCount_1 = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null).getParagraphs().size();
        Note note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config = p1.getConfig();
        config.put("enabled", true);
        p1.setConfig(config);
        p1.setText("checkpoint test text");
        this.notebookRepo.save(note, null);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "second commit", null);
        Assertions.assertEquals((int)2, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        int paragraphCount_2 = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null).getParagraphs().size();
        Assertions.assertEquals((int)(paragraphCount_1 + 1), (int)paragraphCount_2);
        Note noteRevision_1 = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, revision_1.id, null);
        Assertions.assertEquals((int)paragraphCount_1, (int)noteRevision_1.getParagraphs().size());
        note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Assertions.assertEquals((int)paragraphCount_2, (int)note.getParagraphs().size());
        Paragraph p2 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        config.put("enabled", false);
        p2.setConfig(config);
        p2.setText("get revision when modified note test text");
        this.notebookRepo.save(note, null);
        note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        int paragraphCount_3 = note.getParagraphs().size();
        Assertions.assertEquals((int)(paragraphCount_2 + 1), (int)paragraphCount_3);
        noteRevision_1 = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, revision_1.id, null);
        Assertions.assertEquals((int)paragraphCount_1, (int)noteRevision_1.getParagraphs().size());
        note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        Assertions.assertEquals((int)paragraphCount_3, (int)note.getParagraphs().size());
    }

    @Test
    public void getRevisionFailTest() throws IOException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        Assertions.assertTrue((boolean)this.containsNote(this.notebookRepo.list(null), TEST_NOTE_ID));
        Assertions.assertTrue((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).isEmpty());
        NotebookRepoWithVersionControl.Revision revision_1 = this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit", null);
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        int paragraphCount_1 = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null).getParagraphs().size();
        Note note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Assertions.assertEquals((int)paragraphCount_1, (int)note.getParagraphs().size());
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config = p1.getConfig();
        config.put("enabled", true);
        p1.setConfig(config);
        p1.setText("get revision when modified note test text");
        this.notebookRepo.save(note, null);
        int paragraphCount_2 = note.getParagraphs().size();
        Note noteRevision_1 = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, revision_1.id, null);
        Assertions.assertEquals((int)paragraphCount_1, (int)noteRevision_1.getParagraphs().size());
        note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Assertions.assertEquals((int)paragraphCount_2, (int)note.getParagraphs().size());
        NotebookRepoWithVersionControl.Revision absentRevision = new NotebookRepoWithVersionControl.Revision("absentId", "", 0);
        note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, absentRevision.id, null);
        Assertions.assertNull((Object)note);
    }

    @Test
    public void setRevisionTest() throws IOException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        Assertions.assertFalse((boolean)this.notebookRepo.list(null).isEmpty());
        Assertions.assertTrue((boolean)this.containsNote(this.notebookRepo.list(null), TEST_NOTE_ID));
        Assertions.assertTrue((boolean)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).isEmpty());
        Note note = this.notebookRepo.get(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        int paragraphCount_1 = note.getParagraphs().size();
        LOG.info("initial paragraph count: {}", (Object)paragraphCount_1);
        NotebookRepoWithVersionControl.Revision revision1 = this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "set revision: first commit", null);
        Assertions.assertNotNull((Object)revision1);
        Assertions.assertEquals((int)1, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config = p1.getConfig();
        config.put("enabled", true);
        p1.setConfig(config);
        p1.setText("set revision sample text");
        this.notebookRepo.save(note, null);
        int paragraphCount_2 = note.getParagraphs().size();
        Assertions.assertEquals((int)(paragraphCount_1 + 1), (int)paragraphCount_2);
        LOG.info("paragraph count after modification: {}", (Object)paragraphCount_2);
        NotebookRepoWithVersionControl.Revision revision2 = this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "set revision: second commit", null);
        Assertions.assertNotNull((Object)revision2);
        Assertions.assertEquals((int)2, (int)this.notebookRepo.revisionHistory(TEST_NOTE_ID, TEST_NOTE_PATH, null).size());
        Note returnedNote = this.notebookRepo.setNoteRevision(note.getId(), note.getPath(), revision1.id, null);
        Assertions.assertNotNull((Object)returnedNote);
        Assertions.assertEquals((int)paragraphCount_1, (int)returnedNote.getParagraphs().size());
        Note updatedNote = this.notebookRepo.get(note.getId(), note.getPath(), null);
        Assertions.assertNotNull((Object)updatedNote);
        Assertions.assertEquals((int)paragraphCount_1, (int)updatedNote.getParagraphs().size());
        returnedNote = this.notebookRepo.setNoteRevision(note.getId(), note.getPath(), revision2.id, null);
        Assertions.assertNotNull((Object)returnedNote);
        Assertions.assertEquals((int)paragraphCount_2, (int)returnedNote.getParagraphs().size());
        updatedNote = this.notebookRepo.get(note.getId(), note.getPath(), null);
        Assertions.assertNotNull((Object)updatedNote);
        Assertions.assertEquals((int)paragraphCount_2, (int)updatedNote.getParagraphs().size());
        returnedNote = this.notebookRepo.setNoteRevision(note.getId(), note.getPath(), "nonexistent_id", null);
        Assertions.assertNull((Object)returnedNote);
    }

    @Test
    public void moveNoteTest() throws IOException, GitAPIException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit, note1", null);
        String NOTE_FILENAME = TEST_NOTE_PATH.substring(TEST_NOTE_PATH.lastIndexOf("/") + 1);
        String MOVE_DIR = "/move";
        String TEST_MOVE_PATH = "/move/" + NOTE_FILENAME;
        new File(this.notebooksDir + "/move").mkdirs();
        this.notebookRepo.move(TEST_NOTE_ID, TEST_NOTE_PATH, TEST_MOVE_PATH, null);
        this.assertFileIsMoved();
    }

    @Test
    public void moveFolderTest() throws IOException, GitAPIException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit, note1", null);
        this.notebookRepo.checkpoint(TEST_NOTE_ID2, TEST_NOTE_PATH2, "second commit, note2", null);
        String NOTE_DIR = TEST_NOTE_PATH.substring(0, TEST_NOTE_PATH.lastIndexOf("/"));
        String MOVE_DIR = "/move";
        new File(this.notebooksDir + "/move").mkdirs();
        this.notebookRepo.move(NOTE_DIR, "/move", null);
        this.assertFileIsMoved();
    }

    @Test
    public void removeNoteTest() throws IOException, GitAPIException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit, note1", null);
        this.notebookRepo.remove(TEST_NOTE_ID, TEST_NOTE_PATH, null);
        this.assertFileIsDeleted();
    }

    @Test
    public void removeFolderTest() throws IOException, GitAPIException {
        this.notebookRepo = new GitNotebookRepo(this.conf);
        this.notebookRepo.checkpoint(TEST_NOTE_ID, TEST_NOTE_PATH, "first commit, note1", null);
        String NOTE_DIR = TEST_NOTE_PATH.substring(0, TEST_NOTE_PATH.lastIndexOf("/"));
        this.notebookRepo.remove(NOTE_DIR, null);
        this.assertFileIsDeleted();
    }

    private void assertFileIsMoved() throws IOException, GitAPIException {
        Git git = this.notebookRepo.getGit();
        RevCommit latestCommit = (RevCommit)git.log().call().iterator().next();
        ObjectId treeId = latestCommit.getTree().getId();
        Repository repository = git.getRepository();
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            treeWalk.reset((AnyObjectId)treeId);
            treeWalk.next();
            RevCommit previousCommit = latestCommit.getParent(0);
            try (TreeWalk previousTreeWalk = new TreeWalk(repository);){
                previousTreeWalk.reset((AnyObjectId)previousCommit.getTree());
                previousTreeWalk.next();
                Assertions.assertNotEquals((Object)treeWalk.getPathString(), (Object)previousTreeWalk.getPathString());
                Assertions.assertEquals((Object)treeWalk.getObjectId(0), (Object)previousTreeWalk.getObjectId(0));
            }
        }
    }

    private void assertFileIsDeleted() throws IOException, GitAPIException {
        Git git = this.notebookRepo.getGit();
        RevCommit latestCommit = (RevCommit)git.log().call().iterator().next();
        ObjectId treeId = latestCommit.getTree().getId();
        Repository repository = git.getRepository();
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            treeWalk.reset((AnyObjectId)treeId);
            Assertions.assertFalse((boolean)treeWalk.next());
        }
    }
}

