/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.File;
import java.io.IOException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.repo.VFSNotebookRepo;
import org.apache.zeppelin.notebook.repo.mock.VFSNotebookRepoMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookRepoSyncInitializationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotebookRepoSyncInitializationTest.class);
    private String validFirstStorageClass = "org.apache.zeppelin.notebook.repo.VFSNotebookRepo";
    private String validSecondStorageClass = "org.apache.zeppelin.notebook.repo.mock.VFSNotebookRepoMock";
    private String invalidStorageClass = "org.apache.zeppelin.notebook.repo.DummyNotebookRepo";
    private String validOneStorageConf = this.validFirstStorageClass;
    private String validTwoStorageConf = this.validFirstStorageClass + "," + this.validSecondStorageClass;
    private String invalidTwoStorageConf = this.validFirstStorageClass + "," + this.invalidStorageClass;
    private String unsupportedStorageConf = this.validFirstStorageClass + "," + this.validSecondStorageClass + "," + this.validSecondStorageClass;
    private String emptyStorageConf = "";

    @BeforeEach
    public void setUp() {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_PLUGINS_DIR.getVarName(), new File("../../../plugins").getAbsolutePath());
        System.setProperty("zeppelin.isTest", "true");
    }

    @AfterEach
    public void tearDown() {
        System.clearProperty("zeppelin.isTest");
    }

    @Test
    public void validInitOneStorageTest() throws IOException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), this.validOneStorageConf);
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        NotebookRepoSync notebookRepoSync = new NotebookRepoSync(conf);
        Assertions.assertEquals((int)notebookRepoSync.getRepoCount(), (int)1);
        Assertions.assertTrue((boolean)(notebookRepoSync.getRepo(0) instanceof VFSNotebookRepo));
    }

    @Test
    public void validInitTwoStorageTest() throws IOException {
        String zpath = System.getProperty("java.io.tmpdir") + "/ZeppelinLTest_" + System.currentTimeMillis();
        File mainZepDir = new File(zpath);
        mainZepDir.mkdirs();
        new File(mainZepDir, "conf").mkdirs();
        String mainNotePath = zpath + "/notebook";
        String secNotePath = mainNotePath + "_secondary";
        File mainNotebookDir = new File(mainNotePath);
        File secNotebookDir = new File(secNotePath);
        mainNotebookDir.mkdirs();
        secNotebookDir.mkdirs();
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), mainZepDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), mainNotebookDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), this.validTwoStorageConf);
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        NotebookRepoSync notebookRepoSync = new NotebookRepoSync(conf);
        Assertions.assertEquals((int)notebookRepoSync.getRepoCount(), (int)2);
        Assertions.assertTrue((boolean)(notebookRepoSync.getRepo(0) instanceof VFSNotebookRepo));
        Assertions.assertTrue((boolean)(notebookRepoSync.getRepo(1) instanceof VFSNotebookRepoMock));
    }

    @Test
    public void invalidInitTwoStorageTest() throws IOException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), this.invalidTwoStorageConf);
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        try {
            NotebookRepoSync notebookRepoSync = new NotebookRepoSync(conf);
            Assertions.fail((String)"Should throw exception due to invalid NotebookRepo");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            Assertions.assertTrue((boolean)e.getMessage().contains("Fail to instantiate notebookrepo from classpath directly"));
        }
    }

    @Test
    public void initUnsupportedNumberStoragesTest() throws IOException {
        String zpath = System.getProperty("java.io.tmpdir") + "/ZeppelinLTest_" + System.currentTimeMillis();
        File mainZepDir = new File(zpath);
        mainZepDir.mkdirs();
        new File(mainZepDir, "conf").mkdirs();
        String mainNotePath = zpath + "/notebook";
        String secNotePath = mainNotePath + "_secondary";
        File mainNotebookDir = new File(mainNotePath);
        File secNotebookDir = new File(secNotePath);
        mainNotebookDir.mkdirs();
        secNotebookDir.mkdirs();
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), mainZepDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), mainNotebookDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), this.unsupportedStorageConf);
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        NotebookRepoSync notebookRepoSync = new NotebookRepoSync(conf);
        Assertions.assertEquals((int)notebookRepoSync.getRepoCount(), (int)2);
        Assertions.assertTrue((boolean)(notebookRepoSync.getRepo(0) instanceof VFSNotebookRepo));
        Assertions.assertTrue((boolean)(notebookRepoSync.getRepo(1) instanceof VFSNotebookRepoMock));
    }

    @Test
    public void initEmptyStorageTest() throws IOException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), this.emptyStorageConf);
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        NotebookRepoSync notebookRepoSync = new NotebookRepoSync(conf);
        Assertions.assertEquals((int)notebookRepoSync.getRepoCount(), (int)1);
        Assertions.assertTrue((boolean)(notebookRepoSync.getRepo(0) instanceof NotebookRepoWithVersionControl));
    }

    @Test
    public void initOneDummyStorageTest() {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), this.invalidStorageClass);
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        try {
            NotebookRepoSync notebookRepoSync = new NotebookRepoSync(conf);
            Assertions.fail((String)"Should throw exception due to invalid NotebookRepo");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            Assertions.assertTrue((boolean)e.getMessage().contains("Fail to instantiate notebookrepo from classpath directly"));
        }
    }
}

