/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.GitNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookRepoSyncTest {
    private File ZEPPELIN_HOME;
    private ZeppelinConfiguration conf;
    private File mainNotebookDir;
    private File secNotebookDir;
    private Notebook notebook;
    private NotebookRepoSync notebookRepoSync;
    private InterpreterFactory factory;
    private InterpreterSettingManager interpreterSettingManager;
    private Credentials credentials;
    private AuthenticationInfo anonymous;
    private NoteManager noteManager;
    private AuthorizationService authorizationService;
    private static final Logger LOG = LoggerFactory.getLogger(NotebookRepoSyncTest.class);

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zeppelin.isTest", "true");
        this.ZEPPELIN_HOME = Files.createTempDir();
        new File(this.ZEPPELIN_HOME, "conf").mkdirs();
        String mainNotePath = this.ZEPPELIN_HOME.getAbsolutePath() + "/notebook";
        String secNotePath = this.ZEPPELIN_HOME.getAbsolutePath() + "/notebook_secondary";
        this.mainNotebookDir = new File(mainNotePath);
        this.secNotebookDir = new File(secNotePath);
        this.mainNotebookDir.mkdirs();
        this.secNotebookDir.mkdirs();
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME.getVarName(), this.ZEPPELIN_HOME.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), this.mainNotebookDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), "org.apache.zeppelin.notebook.repo.VFSNotebookRepo,org.apache.zeppelin.notebook.repo.mock.VFSNotebookRepoMock");
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_ONE_WAY_SYNC.getVarName(), "false");
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_CONFIG_FS_DIR.getVarName(), this.ZEPPELIN_HOME.getAbsolutePath() + "/conf");
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_PLUGINS_DIR.getVarName(), new File("../../../plugins").getAbsolutePath());
        LOG.info("main Note dir : " + mainNotePath);
        LOG.info("secondary note dir : " + secNotePath);
        this.conf = ZeppelinConfiguration.create();
        ConfigStorage.reset();
        this.interpreterSettingManager = new InterpreterSettingManager(this.conf, (AngularObjectRegistryListener)Mockito.mock(AngularObjectRegistryListener.class), (RemoteInterpreterProcessListener)Mockito.mock(RemoteInterpreterProcessListener.class), (ApplicationEventListener)Mockito.mock(ApplicationEventListener.class));
        this.factory = new InterpreterFactory(this.interpreterSettingManager);
        this.notebookRepoSync = new NotebookRepoSync(this.conf);
        this.noteManager = new NoteManager((NotebookRepo)this.notebookRepoSync, this.conf);
        this.authorizationService = new AuthorizationService(this.noteManager, this.conf);
        this.credentials = new Credentials(this.conf);
        this.notebook = new Notebook(this.conf, this.authorizationService, (NotebookRepo)this.notebookRepoSync, this.noteManager, this.factory, this.interpreterSettingManager, this.credentials, null);
        this.anonymous = new AuthenticationInfo("anonymous");
    }

    @AfterEach
    public void tearDown() throws Exception {
        NotebookRepoSyncTest.delete(this.ZEPPELIN_HOME);
        System.clearProperty("zeppelin.isTest");
    }

    @Test
    public void testRepoCount() throws IOException {
        Assertions.assertTrue((this.notebookRepoSync.getMaxRepoNum() >= this.notebookRepoSync.getRepoCount() ? 1 : 0) != 0);
    }

    @Test
    public void testSyncOnCreate() throws IOException {
        Assertions.assertTrue((this.notebookRepoSync.getRepoCount() > 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, this.anonymous).size());
        String noteId = this.notebook.createNote("test", "", this.anonymous);
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(1, this.anonymous).size());
        Assertions.assertEquals((Object)((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getId(), (Object)((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getId());
        NoteInfo noteInfo = (NoteInfo)this.notebookRepoSync.list(0, null).get(0);
        this.notebook.removeNote(noteInfo.getId(), this.anonymous);
    }

    @Test
    public void testSyncOnDelete() throws IOException {
        Assertions.assertTrue((this.notebookRepoSync.getRepoCount() > 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, this.anonymous).size());
        String noteId = this.notebook.createNote("test", "", this.anonymous);
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(1, this.anonymous).size());
        Assertions.assertEquals((Object)((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getId(), (Object)((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getId());
        NoteInfo noteInfo = (NoteInfo)this.notebookRepoSync.list(0, null).get(0);
        this.notebook.removeNote(noteInfo.getId(), this.anonymous);
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, this.anonymous).size());
    }

    @Test
    public void testSyncUpdateMain() throws IOException {
        String noteId = this.notebook.createNote("/test", "test", this.anonymous);
        this.notebook.processNote(noteId, note -> {
            note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            Map config = p1.getConfig();
            config.put("enabled", true);
            p1.setConfig(config);
            p1.setText("hello world");
            Assertions.assertEquals((int)1, (int)note.getParagraphs().size());
            return null;
        });
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.get(0, ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getPath(), this.anonymous).getParagraphs().size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.get(1, ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getPath(), this.anonymous).getParagraphs().size());
        this.notebook.processNote(noteId, note -> {
            this.notebookRepoSync.save(0, note, this.anonymous);
            return null;
        });
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.get(0, ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getPath(), this.anonymous).getParagraphs().size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.get(1, ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getPath(), this.anonymous).getParagraphs().size());
        this.notebookRepoSync.sync(null);
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.get(1, ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getPath(), this.anonymous).getParagraphs().size());
        this.notebook.processNote(noteId, note -> {
            Paragraph p1 = note.getParagraph(0);
            Assertions.assertEquals((Object)p1.getId(), (Object)this.notebookRepoSync.get(0, ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(0, this.anonymous).get(0)).getPath(), this.anonymous).getLastParagraph().getId());
            Assertions.assertEquals((Object)p1.getId(), (Object)this.notebookRepoSync.get(1, ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(1, this.anonymous).get(0)).getPath(), this.anonymous).getLastParagraph().getId());
            this.notebookRepoSync.remove(note.getId(), note.getPath(), this.anonymous);
            return null;
        });
    }

    @Test
    public void testSyncOnReloadedList() throws Exception {
        Assertions.assertTrue((this.notebookRepoSync.getRepoCount() > 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, this.anonymous).size());
        File srcDir = new File("src/test/resources/notebook");
        File destDir = this.secNotebookDir;
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(1, this.anonymous).size());
        this.notebook.reloadAllNotes(this.anonymous);
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(0, this.anonymous).size());
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(1, this.anonymous).size());
    }

    @Test
    public void testOneWaySyncOnReloadedList() throws IOException, SchedulerException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), this.mainNotebookDir.getAbsolutePath());
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_ONE_WAY_SYNC.getVarName(), "true");
        this.conf = ZeppelinConfiguration.create();
        this.notebookRepoSync = new NotebookRepoSync(this.conf);
        this.notebook = new Notebook(this.conf, (AuthorizationService)Mockito.mock(AuthorizationService.class), (NotebookRepo)this.notebookRepoSync, new NoteManager((NotebookRepo)this.notebookRepoSync, this.conf), this.factory, this.interpreterSettingManager, this.credentials, null);
        Assertions.assertTrue((this.notebookRepoSync.getRepoCount() > 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, null).size());
        File srcDir = new File("src/test/resources/notebook");
        File destDir = this.secNotebookDir;
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(1, null).size());
        this.notebook.reloadAllNotes(null);
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, null).size());
        destDir = this.mainNotebookDir;
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(1, null).size());
        this.notebook.reloadAllNotes(null);
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)2, (int)this.notebookRepoSync.list(1, null).size());
    }

    @Test
    public void testCheckpointOneStorage() throws IOException, SchedulerException {
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_STORAGE.getVarName(), "org.apache.zeppelin.notebook.repo.GitNotebookRepo");
        ZeppelinConfiguration vConf = ZeppelinConfiguration.create();
        NotebookRepoSync vRepoSync = new NotebookRepoSync(vConf);
        Notebook vNotebookSync = new Notebook(vConf, (AuthorizationService)Mockito.mock(AuthorizationService.class), (NotebookRepo)vRepoSync, new NoteManager((NotebookRepo)vRepoSync, this.conf), this.factory, this.interpreterSettingManager, this.credentials, null);
        Assertions.assertEquals((int)1, (int)vRepoSync.getRepoCount());
        Assertions.assertTrue((boolean)(vRepoSync.getRepo(0) instanceof GitNotebookRepo));
        GitNotebookRepo gitRepo = (GitNotebookRepo)vRepoSync.getRepo(0);
        Assertions.assertEquals((int)0, (int)vRepoSync.list(this.anonymous).size());
        String noteIdTmp = vNotebookSync.createNote("/test", "test", this.anonymous);
        System.out.println(noteIdTmp);
        Note note = (Note)vNotebookSync.processNote(noteIdTmp, noteTmp -> noteTmp);
        Assertions.assertEquals((int)1, (int)vRepoSync.list(this.anonymous).size());
        System.out.println(note);
        NoteInfo noteInfo = (NoteInfo)vRepoSync.list(this.anonymous).values().iterator().next();
        String noteId = noteInfo.getId();
        String notePath = noteInfo.getPath();
        vRepoSync.checkpoint(noteId, notePath, "checkpoint message", this.anonymous);
        int vCount = gitRepo.revisionHistory(noteId, notePath, this.anonymous).size();
        Assertions.assertEquals((int)1, (int)vCount);
        note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        Map config = p.getConfig();
        config.put("enabled", true);
        p.setConfig(config);
        p.setText("%md checkpoint test");
        vRepoSync.save(note, this.anonymous);
        vRepoSync.checkpoint(noteId, notePath, "checkpoint message 2", this.anonymous);
        Assertions.assertEquals((int)(vCount + 1), (int)gitRepo.revisionHistory(noteId, notePath, this.anonymous).size());
        this.notebookRepoSync.remove(note.getId(), note.getPath(), this.anonymous);
    }

    @Test
    public void testSyncWithAcl() throws IOException {
        AuthenticationInfo user1 = new AuthenticationInfo("user1");
        String noteId = this.notebook.createNote("/test", "test", user1);
        this.notebook.processNote(noteId, note -> {
            Assertions.assertEquals((int)0, (int)note.getParagraphs().size());
            return null;
        });
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(1, null).size());
        HashSet<String> entity = new HashSet<String>();
        entity.add(user1.getUser());
        Assertions.assertEquals((Object)true, (Object)this.authorizationService.isOwner(noteId, entity));
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getReaders(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getRunners(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getWriters(noteId).size());
        this.notebook.processNote(noteId, note -> {
            note.setInterpreterFactory((InterpreterFactory)Mockito.mock(InterpreterFactory.class));
            Paragraph p1 = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
            p1.setText("hello world");
            Assertions.assertEquals((int)1, (int)note.getParagraphs().size());
            this.notebookRepoSync.save(1, note, null);
            return null;
        });
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.get(0, ((NoteInfo)this.notebookRepoSync.list(0, null).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(0, null).get(0)).getPath(), null).getParagraphs().size());
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.get(1, ((NoteInfo)this.notebookRepoSync.list(1, null).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(1, null).get(0)).getPath(), null).getParagraphs().size());
        this.notebookRepoSync.sync(user1);
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.get(0, ((NoteInfo)this.notebookRepoSync.list(0, null).get(0)).getId(), ((NoteInfo)this.notebookRepoSync.list(0, null).get(0)).getPath(), null).getParagraphs().size());
        Assertions.assertEquals((Object)true, (Object)this.authorizationService.isOwner(noteId, entity));
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getReaders(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getRunners(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getWriters(noteId).size());
        this.notebook.processNote(noteId, note -> {
            this.notebookRepoSync.remove(0, noteId, note.getPath(), user1);
            return null;
        });
        Assertions.assertEquals((int)0, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(1, null).size());
        this.notebookRepoSync.sync(user1);
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(0, null).size());
        Assertions.assertEquals((int)1, (int)this.notebookRepoSync.list(1, null).size());
        Assertions.assertEquals((int)1, (int)this.authorizationService.getOwners(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getReaders(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getRunners(noteId).size());
        Assertions.assertEquals((int)0, (int)this.authorizationService.getWriters(noteId).size());
    }

    static void delete(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    NotebookRepoSyncTest.delete(f);
                }
            }
            file.delete();
        }
    }
}

