/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.VFSNotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class VFSNotebookRepoTest {
    private ZeppelinConfiguration zConf;
    private VFSNotebookRepo notebookRepo;
    private File notebookDir;

    @BeforeEach
    public void setUp() throws IOException {
        this.notebookDir = Files.createTempDirectory("notebookDir", new FileAttribute[0]).toFile();
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR.getVarName(), this.notebookDir.getAbsolutePath());
        this.notebookRepo = new VFSNotebookRepo();
        this.zConf = ZeppelinConfiguration.create();
        this.notebookRepo.init(this.zConf);
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.notebookDir);
    }

    @Test
    public void testBasics() throws IOException {
        Assertions.assertEquals((int)0, (int)this.notebookRepo.list(AuthenticationInfo.ANONYMOUS).size());
        Note note1 = new Note();
        note1.setPath("/my_project/my_note1");
        Paragraph p1 = note1.insertNewParagraph(0, AuthenticationInfo.ANONYMOUS);
        p1.setText("%md hello world");
        p1.setTitle("my title");
        this.notebookRepo.save(note1, AuthenticationInfo.ANONYMOUS);
        Map noteInfos = this.notebookRepo.list(AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)1, (int)noteInfos.size());
        Assertions.assertEquals((Object)note1.getId(), (Object)((NoteInfo)noteInfos.get(note1.getId())).getId());
        Assertions.assertEquals((Object)note1.getName(), (Object)((NoteInfo)noteInfos.get(note1.getId())).getNoteName());
        Note note2 = new Note();
        note2.setPath("/my_note2");
        Paragraph p2 = note2.insertNewParagraph(0, AuthenticationInfo.ANONYMOUS);
        p2.setText("%md hello world2");
        p2.setTitle("my title2");
        this.notebookRepo.save(note2, AuthenticationInfo.ANONYMOUS);
        noteInfos = this.notebookRepo.list(AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)2, (int)noteInfos.size());
        String newPath = "/my_project2/my_note2";
        this.notebookRepo.move(note2.getId(), note2.getPath(), "/my_project2/my_note2", AuthenticationInfo.ANONYMOUS);
        Note note3 = this.notebookRepo.get(note2.getId(), newPath, AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((Object)note2, (Object)note3);
        this.notebookRepo.move("/my_project2", "/my_project3/my_project2", AuthenticationInfo.ANONYMOUS);
        noteInfos = this.notebookRepo.list(AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)2, (int)noteInfos.size());
        Note note4 = this.notebookRepo.get(note3.getId(), "/my_project3/my_project2/my_note2", AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((Object)note3, (Object)note4);
        this.notebookRepo.remove(note1.getId(), note1.getPath(), AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)1, (int)this.notebookRepo.list(AuthenticationInfo.ANONYMOUS).size());
    }

    @Test
    public void testNoteNameWithColon() throws IOException {
        Assertions.assertEquals((int)0, (int)this.notebookRepo.list(AuthenticationInfo.ANONYMOUS).size());
        Note note1 = new Note();
        note1.setPath("/my_project/my:note1");
        Paragraph p1 = note1.insertNewParagraph(0, AuthenticationInfo.ANONYMOUS);
        p1.setText("%md hello world");
        p1.setTitle("my title");
        this.notebookRepo.save(note1, AuthenticationInfo.ANONYMOUS);
        Map noteInfos = this.notebookRepo.list(AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)1, (int)noteInfos.size());
    }

    @Test
    public void testUpdateSettings() throws IOException {
        List repoSettings = this.notebookRepo.getSettings(AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)1, (int)repoSettings.size());
        NotebookRepoSettingsInfo settingInfo = (NotebookRepoSettingsInfo)repoSettings.get(0);
        Assertions.assertEquals((Object)"Notebook Path", (Object)settingInfo.name);
        Assertions.assertEquals((Object)this.notebookDir.getAbsolutePath(), (Object)settingInfo.selected);
        this.createNewNote("{}", "id2", "my_project/name2");
        Assertions.assertEquals((int)1, (int)this.notebookRepo.list(AuthenticationInfo.ANONYMOUS).size());
        String newNotebookDir = "/tmp/zeppelin/vfs_notebookrepo2";
        FileUtils.forceMkdir((File)new File(newNotebookDir));
        ImmutableMap newSettings = ImmutableMap.of((Object)"Notebook Path", (Object)newNotebookDir);
        this.notebookRepo.updateSettings((Map)newSettings, AuthenticationInfo.ANONYMOUS);
        Assertions.assertEquals((int)0, (int)this.notebookRepo.list(AuthenticationInfo.ANONYMOUS).size());
    }

    private void createNewNote(String content, String noteId, String noteName) throws IOException {
        FileUtils.writeStringToFile((File)new File(this.notebookDir + "/" + noteName + "_" + noteId + ".zpln"), (String)content, (Charset)StandardCharsets.UTF_8);
    }
}

