/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import com.google.gson.Gson;
import java.util.Collection;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.resource.DistributedResourcePool;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.RemoteResource;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePoolConnector;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DistributedResourcePoolTest
extends AbstractInterpreterTest {
    private RemoteInterpreter intp1;
    private RemoteInterpreter intp2;
    private InterpreterContext context;
    private String note1Id;
    private String note2Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
        this.note2Id = this.notebook.createNote("/note_2", AuthenticationInfo.ANONYMOUS);
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getByName("mock_resource_pool");
        interpreterSetting.getOption().setPerNote("isolated");
        this.intp1 = (RemoteInterpreter)interpreterSetting.getInterpreter("user1", this.note1Id, "mock_resource_pool");
        this.intp2 = (RemoteInterpreter)interpreterSetting.getInterpreter("user2", this.note2Id, "mock_resource_pool");
        this.context = InterpreterContext.builder().setNoteId("note").setParagraphId("id").build();
        this.intp1.open();
        this.intp2.open();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.interpreterSettingManager.close();
    }

    @Test
    public void testRemoteDistributedResourcePool() throws InterpreterException {
        Gson gson = new Gson();
        this.intp1.interpret("put key1 value1", this.context);
        this.intp2.interpret("put key2 value2", this.context);
        InterpreterResult ret = this.intp1.interpret("getAll", this.context);
        Assertions.assertEquals((int)2, (int)ResourceSet.fromJson((String)((InterpreterResultMessage)ret.message().get(0)).getData()).size());
        ret = this.intp2.interpret("getAll", this.context);
        Assertions.assertEquals((int)2, (int)ResourceSet.fromJson((String)((InterpreterResultMessage)ret.message().get(0)).getData()).size());
        ret = this.intp1.interpret("get key1", this.context);
        Assertions.assertEquals((Object)"value1", (Object)gson.fromJson(((InterpreterResultMessage)ret.message().get(0)).getData(), String.class));
        ret = this.intp1.interpret("get key2", this.context);
        Assertions.assertEquals((Object)"value2", (Object)gson.fromJson(((InterpreterResultMessage)ret.message().get(0)).getData(), String.class));
    }

    @Test
    public void testDistributedResourcePool() {
        final LocalResourcePool pool2 = new LocalResourcePool("pool2");
        final LocalResourcePool pool3 = new LocalResourcePool("pool3");
        DistributedResourcePool pool1 = new DistributedResourcePool("pool1", new ResourcePoolConnector(){

            public ResourceSet getAllResources() {
                ResourceSet set = pool2.getAll();
                set.addAll((Collection)pool3.getAll());
                ResourceSet remoteSet = new ResourceSet();
                for (Resource s : set) {
                    RemoteResource remoteResource = RemoteResource.fromJson((String)s.toJson());
                    remoteResource.setResourcePoolConnector((ResourcePoolConnector)this);
                    remoteSet.add((Object)remoteResource);
                }
                return remoteSet;
            }

            public Object readResource(ResourceId id) {
                if (id.getResourcePoolId().equals(pool2.id())) {
                    return pool2.get(id.getName()).get();
                }
                if (id.getResourcePoolId().equals(pool3.id())) {
                    return pool3.get(id.getName()).get();
                }
                return null;
            }

            public Object invokeMethod(ResourceId id, String methodName, Class[] paramTypes, Object[] params) {
                return null;
            }

            public Resource invokeMethod(ResourceId id, String methodName, Class[] paramTypes, Object[] params, String returnResourceName) {
                return null;
            }
        });
        Assertions.assertEquals((int)0, (int)pool1.getAll().size());
        pool2.put("object1", (Object)"value2");
        Assertions.assertEquals((int)1, (int)pool1.getAll().size());
        Assertions.assertTrue((boolean)pool1.get("object1").isRemote());
        Assertions.assertEquals((Object)"value2", (Object)pool1.get("object1").get());
        pool1.put("object1", (Object)"value1");
        Assertions.assertEquals((int)1, (int)pool2.getAll().size());
        Assertions.assertEquals((Object)"value1", (Object)pool1.get("object1").get());
        Assertions.assertEquals((Object)"value1", (Object)((Resource)pool1.getAll().get(0)).get());
        Assertions.assertEquals((Object)"value2", (Object)((Resource)pool1.getAll().get(1)).get());
    }

    @Test
    public void testResourcePoolUtils() throws InterpreterException {
        Gson gson = new Gson();
        this.intp1.interpret("put " + this.note1Id + ":paragraph1:key1 value1", this.context);
        this.intp1.interpret("put " + this.note1Id + ":paragraph2:key1 value2", this.context);
        this.intp2.interpret("put " + this.note2Id + ":paragraph1:key1 value1", this.context);
        this.intp2.interpret("put " + this.note2Id + ":paragraph2:key2 value2", this.context);
        Assertions.assertEquals((int)4, (int)this.interpreterSettingManager.getAllResources().size());
        this.interpreterSettingManager.removeResourcesBelongsToNote(this.note1Id);
        Assertions.assertEquals((int)2, (int)this.interpreterSettingManager.getAllResources().size());
        Assertions.assertEquals((Object)"", (Object)gson.fromJson(((InterpreterResultMessage)this.intp1.interpret("get note1:paragraph1:key1", this.context).message().get(0)).getData(), String.class));
        Assertions.assertEquals((Object)"", (Object)gson.fromJson(((InterpreterResultMessage)this.intp1.interpret("get note1:paragraph2:key1", this.context).message().get(0)).getData(), String.class));
        this.interpreterSettingManager.removeResourcesBelongsToParagraph(this.note2Id, "paragraph1");
        Assertions.assertEquals((int)1, (int)this.interpreterSettingManager.getAllResources().size());
        Assertions.assertEquals((Object)"value2", (Object)gson.fromJson(((InterpreterResultMessage)this.intp1.interpret("get " + this.note2Id + ":paragraph2:key2", this.context).message().get(0)).getData(), String.class));
    }

    @Test
    public void testResourceInvokeMethod() throws InterpreterException {
        Gson gson = new Gson();
        this.intp1.interpret("put key1 hey", this.context);
        this.intp2.interpret("put key2 world", this.context);
        InterpreterResult ret = this.intp1.interpret("invoke key1 length", this.context);
        Assertions.assertEquals((Object)"3", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = this.intp1.interpret("invoke key2 length", this.context);
        Assertions.assertEquals((Object)"5", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = this.intp1.interpret("getAll", this.context);
        Assertions.assertEquals((int)2, (int)ResourceSet.fromJson((String)((InterpreterResultMessage)ret.message().get(0)).getData()).size());
        ret = this.intp1.interpret("invoke key1 length ret1", this.context);
        Assertions.assertEquals((Object)"3", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = this.intp1.interpret("getAll", this.context);
        Assertions.assertEquals((int)3, (int)ResourceSet.fromJson((String)((InterpreterResultMessage)ret.message().get(0)).getData()).size());
        ret = this.intp1.interpret("get ret1", this.context);
        Assertions.assertEquals((Object)"3", (Object)gson.fromJson(((InterpreterResultMessage)ret.message().get(0)).getData(), String.class));
        ret = this.intp1.interpret("invoke key2 length ret2", this.context);
        Assertions.assertEquals((Object)"5", (Object)((InterpreterResultMessage)ret.message().get(0)).getData());
        ret = this.intp1.interpret("getAll", this.context);
        Assertions.assertEquals((int)4, (int)ResourceSet.fromJson((String)((InterpreterResultMessage)ret.message().get(0)).getData()).size());
        ret = this.intp1.interpret("get ret2", this.context);
        Assertions.assertEquals((Object)"5", (Object)gson.fromJson(((InterpreterResultMessage)ret.message().get(0)).getData(), String.class));
    }
}

