/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.interpreter.AbstractInterpreterTest;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.ParagraphInfo;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoteSchedulerTest
extends AbstractInterpreterTest
implements RemoteInterpreterProcessListener {
    private InterpreterSetting interpreterSetting;
    private SchedulerFactory schedulerSvc;
    private static final int TICK_WAIT = 100;
    private static final int MAX_WAIT_CYCLES = 100;
    private String note1Id;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.note1Id = this.notebook.createNote("/note_1", AuthenticationInfo.ANONYMOUS);
        this.schedulerSvc = SchedulerFactory.singleton();
        this.interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName("test");
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.interpreterSetting.close();
    }

    @Test
    public void test() throws Exception {
        int cycles;
        final RemoteInterpreter intpA = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", this.note1Id, "mock");
        intpA.open();
        Scheduler scheduler = intpA.getScheduler();
        Job<Object> job = new Job<Object>("jobId", "jobName", null){
            Object results;

            public Object getReturn() {
                return this.results;
            }

            public int progress() {
                return 0;
            }

            public Map<String, Object> info() {
                return null;
            }

            protected Object jobRun() throws Throwable {
                intpA.interpret("1000", InterpreterContext.builder().setNoteId("noteId").setParagraphId("jobId").setResourcePool((ResourcePool)new LocalResourcePool("pool1")).build());
                return "1000";
            }

            protected boolean jobAbort() {
                return false;
            }

            public void setResult(Object results) {
                this.results = results;
            }
        };
        scheduler.submit((Job)job);
        for (cycles = 0; !job.isRunning() && cycles < 100; ++cycles) {
            LOGGER.info("Status:" + job.getStatus());
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)job.isRunning());
        Thread.sleep(500L);
        for (cycles = 0; !job.isTerminated() && cycles < 100; ++cycles) {
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)job.isTerminated());
        intpA.close();
        this.schedulerSvc.removeScheduler("test");
    }

    @Test
    public void testAbortOnPending() throws Exception {
        int cycles;
        final RemoteInterpreter intpA = (RemoteInterpreter)this.interpreterSetting.getInterpreter("user1", this.note1Id, "mock");
        intpA.open();
        Scheduler scheduler = intpA.getScheduler();
        Job<Object> job1 = new Job<Object>("jobId1", "jobName1", null){
            Object results;
            InterpreterContext context;
            {
                super(jobId, jobName, listener);
                this.context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("jobId1").setResourcePool((ResourcePool)new LocalResourcePool("pool1")).build();
            }

            public Object getReturn() {
                return this.results;
            }

            public int progress() {
                return 0;
            }

            public Map<String, Object> info() {
                return null;
            }

            protected Object jobRun() throws Throwable {
                intpA.interpret("1000", this.context);
                return "1000";
            }

            protected boolean jobAbort() {
                if (this.isRunning()) {
                    try {
                        intpA.cancel(this.context);
                    }
                    catch (InterpreterException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }

            public void setResult(Object results) {
                this.results = results;
            }
        };
        Job<Object> job2 = new Job<Object>("jobId2", "jobName2", null){
            public Object results;
            InterpreterContext context;
            {
                super(jobId, jobName, listener);
                this.context = InterpreterContext.builder().setNoteId("noteId").setParagraphId("jobId2").setResourcePool((ResourcePool)new LocalResourcePool("pool1")).build();
            }

            public Object getReturn() {
                return this.results;
            }

            public int progress() {
                return 0;
            }

            public Map<String, Object> info() {
                return null;
            }

            protected Object jobRun() throws Throwable {
                intpA.interpret("1000", this.context);
                return "1000";
            }

            protected boolean jobAbort() {
                if (this.isRunning()) {
                    try {
                        intpA.cancel(this.context);
                    }
                    catch (InterpreterException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }

            public void setResult(Object results) {
                this.results = results;
            }
        };
        job2.setResult((Object)"result2");
        scheduler.submit((Job)job1);
        scheduler.submit((Job)job2);
        for (cycles = 0; !job1.isRunning() && cycles < 100; ++cycles) {
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)job1.isRunning());
        Assertions.assertEquals((Object)Job.Status.PENDING, (Object)job2.getStatus());
        job2.abort();
        for (cycles = 0; !job1.isTerminated() && cycles < 100; ++cycles) {
            Thread.sleep(100L);
        }
        Assertions.assertNotNull((Object)job1.getDateFinished());
        Assertions.assertTrue((boolean)job1.isTerminated());
        Assertions.assertEquals((Object)"1000", (Object)job1.getReturn());
        Assertions.assertNull((Object)job2.getDateFinished());
        Assertions.assertTrue((boolean)job2.isTerminated());
        Assertions.assertEquals((Object)"result2", (Object)job2.getReturn());
        intpA.close();
        this.schedulerSvc.removeScheduler("test");
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String output) {
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, InterpreterResult.Type type, String output) {
    }

    public void onOutputClear(String noteId, String paragraphId) {
    }

    public void runParagraphs(String noteId, List<Integer> paragraphIndices, List<String> paragraphIds, String curParagraphId) throws IOException {
    }

    public void onParaInfosReceived(String noteId, String paragraphId, String interpreterSettingId, Map<String, String> metaInfos) {
    }

    public List<ParagraphInfo> getParagraphList(String user, String noteId) {
        return null;
    }

    public void checkpointOutput(String noteId, String paragraphId) {
    }
}

