/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.search;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.InMemoryNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.search.LuceneSearch;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class LuceneSearchTest {
    private Notebook notebook;
    private InterpreterSettingManager interpreterSettingManager;
    private NoteManager noteManager;
    private LuceneSearch noteSearchService;
    private File indexDir;

    @BeforeEach
    public void startUp() throws IOException {
        this.indexDir = Files.createTempDirectory("lucene", new FileAttribute[0]).toFile();
        System.setProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_SEARCH_INDEX_PATH.getVarName(), this.indexDir.getAbsolutePath());
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        this.noteManager = new NoteManager((NotebookRepo)new InMemoryNotebookRepo(), conf);
        this.interpreterSettingManager = (InterpreterSettingManager)Mockito.mock(InterpreterSettingManager.class);
        InterpreterSetting defaultInterpreterSetting = (InterpreterSetting)Mockito.mock(InterpreterSetting.class);
        Mockito.when((Object)defaultInterpreterSetting.getName()).thenReturn((Object)"test");
        Mockito.when((Object)this.interpreterSettingManager.getDefaultInterpreterSetting()).thenReturn((Object)defaultInterpreterSetting);
        this.notebook = new Notebook(conf, (AuthorizationService)Mockito.mock(AuthorizationService.class), (NotebookRepo)Mockito.mock(NotebookRepo.class), this.noteManager, (InterpreterFactory)Mockito.mock(InterpreterFactory.class), this.interpreterSettingManager, (Credentials)Mockito.mock(Credentials.class), null);
        this.noteSearchService = new LuceneSearch(ZeppelinConfiguration.create(), this.notebook);
    }

    @AfterEach
    public void shutDown() throws IOException {
        this.noteSearchService.close();
        FileUtils.deleteDirectory((File)this.indexDir);
    }

    private void drainSearchEvents() throws InterruptedException {
        while (!this.noteSearchService.isEventQueueEmpty()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
    }

    @Test
    public void canIndexAndQuery() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        String note2Id = this.newNoteWithParagraphs("Notebook2", "not test", "not test at all");
        this.drainSearchEvents();
        List results = this.noteSearchService.query("all");
        Assertions.assertFalse((boolean)results.isEmpty());
        Assertions.assertEquals((int)1, (int)results.size());
        this.notebook.processNote(note2Id, note2 -> {
            Assertions.assertEquals((Object)LuceneSearch.formatId((String)note2.getId(), (Paragraph)note2.getLastParagraph()), ((Map)results.get(0)).get("id"));
            return null;
        });
    }

    @Test
    public void canIndexAndQueryByNotebookName() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        String note2Id = this.newNoteWithParagraphs("Notebook2", "not test", "not test at all");
        this.drainSearchEvents();
        List results = this.noteSearchService.query("Notebook1");
        Assertions.assertFalse((boolean)results.isEmpty());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)note1Id, ((Map)results.get(0)).get("id"));
    }

    @Test
    public void canIndexAndQueryByParagraphTitle() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test", "testingTitleSearch");
        String note2Id = this.newNoteWithParagraph("Notebook2", "not test", "notTestingTitleSearch");
        this.drainSearchEvents();
        List results = this.noteSearchService.query("testingTitleSearch");
        Assertions.assertFalse((boolean)results.isEmpty());
        Assertions.assertTrue((results.size() >= 1 ? 1 : 0) != 0);
        int TitleHits = 0;
        for (Map res : results) {
            if (!((String)res.get("header")).contains("testingTitleSearch")) continue;
            ++TitleHits;
        }
        Assertions.assertTrue((TitleHits >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void indexKeyContract() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        this.drainSearchEvents();
        String id = this.resultForQuery("test").get(0).get("id");
        this.notebook.processNote(note1Id, note1 -> {
            Assertions.assertArrayEquals((Object[])id.split("/"), (Object[])new String[]{note1.getId(), "paragraph", note1.getLastParagraph().getId()});
            return null;
        });
    }

    @Test
    public void canNotSearchBeforeIndexing() {
        List result = this.noteSearchService.query("anything");
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void canIndexAndReIndex() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        String note2Id = this.newNoteWithParagraphs("Notebook2", "not test", "not test at all");
        this.drainSearchEvents();
        this.notebook.processNote(note2Id, note2 -> {
            Paragraph p2 = note2.getLastParagraph();
            p2.setText("test indeed");
            this.noteSearchService.updateNoteIndex(note2Id);
            this.noteSearchService.updateParagraphIndex(note2Id, p2.getId());
            return null;
        });
        List results = this.noteSearchService.query("all");
        Assertions.assertTrue((boolean)results.isEmpty());
        results = this.noteSearchService.query("indeed");
        Assertions.assertFalse((boolean)results.isEmpty());
    }

    @Test
    public void canDeleteNull() throws IOException {
        this.noteSearchService.deleteNoteIndex(null);
    }

    @Test
    public void canDeleteFromIndex() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        String note2Id = this.newNoteWithParagraphs("Notebook2", "not test", "not test at all");
        this.drainSearchEvents();
        Assertions.assertFalse((boolean)this.resultForQuery("Notebook2").isEmpty());
        this.noteSearchService.deleteNoteIndex(note2Id);
        Assertions.assertTrue((boolean)this.noteSearchService.query("all").isEmpty());
        Assertions.assertTrue((boolean)this.resultForQuery("Notebook2").isEmpty());
        List<Map<String, String>> results = this.resultForQuery("test");
        Assertions.assertFalse((boolean)results.isEmpty());
        Assertions.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void indexParagraphUpdatedOnNoteSave() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        String note2Id = this.newNoteWithParagraphs("Notebook2", "not test", "not test at all");
        this.drainSearchEvents();
        Assertions.assertEquals((int)3, (int)this.resultForQuery("test").size());
        this.notebook.processNote(note1Id, note1 -> {
            Paragraph p1 = note1.getLastParagraph();
            p1.setText("no no no");
            this.notebook.saveNote(note1, AuthenticationInfo.ANONYMOUS);
            p1.getNote().fireParagraphUpdateEvent(p1);
            return null;
        });
        this.drainSearchEvents();
        Assertions.assertEquals((int)1, (int)this.resultForQuery("Notebook1").size());
        List<Map<String, String>> results = this.resultForQuery("test");
        Assertions.assertFalse((boolean)results.isEmpty());
        Assertions.assertEquals((int)2, (int)results.size());
        for (Map<String, String> result : results) {
            Assertions.assertFalse((boolean)result.get("id").startsWith(note1Id));
        }
    }

    @Test
    public void indexNoteNameUpdatedOnNoteSave() throws IOException, InterruptedException {
        String note1Id = this.newNoteWithParagraph("Notebook1", "test");
        String note2Id = this.newNoteWithParagraphs("Notebook2", "not test", "not test at all");
        this.drainSearchEvents();
        Assertions.assertEquals((int)3, (int)this.resultForQuery("test").size());
        this.notebook.processNote(note1Id, note1 -> {
            note1.setName("NotebookN");
            this.notebook.updateNote(note1, AuthenticationInfo.ANONYMOUS);
            return null;
        });
        this.drainSearchEvents();
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)this.resultForQuery("Notebook1").isEmpty());
        Assertions.assertFalse((boolean)this.resultForQuery("NotebookN").isEmpty());
        Assertions.assertEquals((int)1, (int)this.resultForQuery("NotebookN").size());
    }

    private List<Map<String, String>> resultForQuery(String q) {
        return this.noteSearchService.query(q);
    }

    private String newNoteWithParagraph(String noteName, String parText) throws IOException {
        String note1Id = this.newNote(noteName);
        this.notebook.processNote(note1Id, note1 -> {
            this.addParagraphWithText(note1, parText);
            return null;
        });
        return note1Id;
    }

    private String newNoteWithParagraph(String noteName, String parText, String title) throws IOException {
        String noteId = this.newNote(noteName);
        this.notebook.processNote(noteId, note -> {
            this.addParagraphWithTextAndTitle(note, parText, title);
            return null;
        });
        return noteId;
    }

    private String newNoteWithParagraphs(String noteName, String ... parTexts) throws IOException {
        String note1Id = this.newNote(noteName);
        this.notebook.processNote(note1Id, note1 -> {
            for (String parText : parTexts) {
                this.addParagraphWithText(note1, parText);
            }
            return null;
        });
        return note1Id;
    }

    private Paragraph addParagraphWithText(Note note, String text) {
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p.setText(text);
        return p;
    }

    private Paragraph addParagraphWithTextAndTitle(Note note, String text, String title) {
        Paragraph p = note.addNewParagraph(AuthenticationInfo.ANONYMOUS);
        p.setText(text);
        p.setTitle(title);
        return p;
    }

    private String newNote(String name) throws IOException {
        return this.notebook.createNote(name, AuthenticationInfo.ANONYMOUS);
    }
}

