/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.storage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.util.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalConfigStorageTest {
    public static final String TEST_STRING = "this is a test!";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingAtomically() throws IOException {
        Path destination = Files.createTempFile("test-", "file", new FileAttribute[0]);
        File destinationFile = destination.toFile();
        try {
            FileUtils.atomicWriteToFile((String)TEST_STRING, (File)destinationFile);
            try (InputStream is = Files.newInputStream(destination, new OpenOption[0]);){
                String read = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                Assertions.assertEquals((Object)TEST_STRING, (Object)read);
            }
        }
        finally {
            Files.deleteIfExists(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingAtomicallyNonExistingDir() throws IOException {
        Random rnd = new Random();
        Path destDir = Paths.get(System.getProperty("java.io.tmpdir"), "non-existing-" + rnd.nextLong());
        Path destination = Paths.get(destDir.toString(), "test-" + rnd.nextLong() + "-file");
        File destinationFile = destination.toFile();
        try {
            FileUtils.atomicWriteToFile((String)TEST_STRING, (File)destinationFile);
            try (InputStream is = Files.newInputStream(destination, new OpenOption[0]);){
                String read = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                Assertions.assertEquals((Object)TEST_STRING, (Object)read);
            }
        }
        finally {
            Files.deleteIfExists(destination);
            Files.deleteIfExists(destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReading() throws IOException {
        Path destination = Files.createTempFile("test-", "file", new FileAttribute[0]);
        File destinationFile = destination.toFile();
        try {
            try (BufferedWriter writer = Files.newBufferedWriter(destination, new OpenOption[0]);){
                writer.write(TEST_STRING);
            }
            String read = FileUtils.readFromFile((File)destinationFile);
            Assertions.assertEquals((Object)TEST_STRING, (Object)read);
        }
        finally {
            Files.deleteIfExists(destination);
        }
    }
}

