/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterFactoryInterface;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;

public class InterpreterFactory
implements InterpreterFactoryInterface {
    private final InterpreterSettingManager interpreterSettingManager;

    @Inject
    public InterpreterFactory(InterpreterSettingManager interpreterSettingManager) {
        this.interpreterSettingManager = interpreterSettingManager;
    }

    public Interpreter getInterpreter(String replName, ExecutionContext executionContext) throws InterpreterNotFoundException {
        if (StringUtils.isBlank((CharSequence)replName)) {
            InterpreterSetting defaultSetting = this.interpreterSettingManager.getByName(executionContext.getDefaultInterpreterGroup());
            return defaultSetting.getDefaultInterpreter(executionContext);
        }
        String[] replNameSplits = replName.split("\\.");
        if (replNameSplits.length == 2) {
            String group = replNameSplits[0];
            String name = replNameSplits[1];
            InterpreterSetting setting = this.interpreterSettingManager.getByName(group);
            if (null != setting) {
                Interpreter interpreter = setting.getInterpreter(executionContext, name);
                if (null != interpreter) {
                    return interpreter;
                }
                throw new InterpreterNotFoundException("No such interpreter: " + replName);
            }
            throw new InterpreterNotFoundException("No interpreter setting named: " + group);
        }
        if (replNameSplits.length == 1) {
            Interpreter interpreter;
            InterpreterSetting setting = this.interpreterSettingManager.getByName(executionContext.getDefaultInterpreterGroup());
            if (setting != null && null != (interpreter = setting.getInterpreter(executionContext, replName))) {
                return interpreter;
            }
            setting = this.interpreterSettingManager.getByName(replName);
            if (null != setting) {
                return setting.getDefaultInterpreter(executionContext);
            }
        }
        throw new InterpreterNotFoundException("No such interpreter: " + replName);
    }
}

