/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.recovery;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.recovery.RecoveryUtils;
import org.apache.zeppelin.notebook.FileSystemStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRecoveryStorage
extends RecoveryStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemRecoveryStorage.class);
    private FileSystemStorage fs;
    private Path recoveryDir;
    private InterpreterSettingManager interpreterSettingManager;

    public FileSystemRecoveryStorage(ZeppelinConfiguration zConf, InterpreterSettingManager interpreterSettingManager) throws IOException {
        super(zConf);
        this.interpreterSettingManager = interpreterSettingManager;
        String recoveryDirProperty = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_RECOVERY_DIR);
        this.fs = new FileSystemStorage(zConf, recoveryDirProperty);
        LOGGER.info("Creating FileSystem: " + this.fs.getFs().getClass().getName() + " for Zeppelin Recovery.");
        this.recoveryDir = this.fs.makeQualified(new Path(recoveryDirProperty));
        LOGGER.info("Using folder {} to store recovery data", (Object)this.recoveryDir);
        this.fs.tryMkDir(this.recoveryDir);
    }

    public void onInterpreterClientStart(InterpreterClient client) throws IOException {
        this.save(client.getInterpreterSettingName());
    }

    public void onInterpreterClientStop(InterpreterClient client) throws IOException {
        this.save(client.getInterpreterSettingName());
    }

    private void save(String interpreterSettingName) throws IOException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName(interpreterSettingName);
        String recoveryData = RecoveryUtils.getRecoveryData(interpreterSetting);
        LOGGER.debug("Updating recovery data of {}: {}", (Object)interpreterSettingName, (Object)recoveryData);
        Path recoveryFile = new Path(this.recoveryDir, interpreterSettingName + ".recovery");
        this.fs.writeFile(recoveryData, recoveryFile, true);
    }

    public Map<String, InterpreterClient> restore() throws IOException {
        HashMap<String, InterpreterClient> clients = new HashMap<String, InterpreterClient>();
        List<Path> paths = this.fs.list(new Path(this.recoveryDir + "/*.recovery"));
        for (Path path : paths) {
            String fileName = path.getName();
            String interpreterSettingName = fileName.substring(0, fileName.length() - ".recovery".length());
            String recoveryContent = this.fs.readFile(path);
            clients.putAll(RecoveryUtils.restoreFromRecoveryData(recoveryContent, interpreterSettingName, this.interpreterSettingManager, this.zConf));
        }
        return clients;
    }
}

