/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterRunningProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterRunningProcess.class);
    private final String host;
    private final int port;
    private final String interpreterSettingName;
    private final String interpreterGroupId;
    private final boolean isRecovery;

    public RemoteInterpreterRunningProcess(String interpreterSettingName, String interpreterGroupId, int connectTimeout, int connectionPoolSize, String intpEventServerHost, int intpEventServerPort, String host, int port, boolean isRecovery) {
        super(connectTimeout, connectionPoolSize, intpEventServerHost, intpEventServerPort);
        this.interpreterSettingName = interpreterSettingName;
        this.interpreterGroupId = interpreterGroupId;
        this.host = host;
        this.port = port;
        this.isRecovery = isRecovery;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    public String getInterpreterGroupId() {
        return this.interpreterGroupId;
    }

    public void start(String userName) {
    }

    public void stop() {
        if ((System.getenv("ZEPPELIN_FORCE_STOP") != null || this.isRecovery) && this.isRunning()) {
            LOGGER.info("Kill interpreter process of interpreter group: {}", (Object)this.interpreterGroupId);
            try {
                this.callRemoteFunction(client -> {
                    client.shutdown();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("ignore the exception when shutting down interpreter process.", (Throwable)e);
            }
            super.close();
            LOGGER.info("Remote process of interpreter group: {} is terminated.", (Object)this.getInterpreterGroupId());
        }
    }

    public boolean isAlive() {
        return this.isRunning();
    }

    public boolean isRunning() {
        return RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort());
    }

    @Override
    public void processStarted(int port, String host) {
    }

    @Override
    public String getErrorMessage() {
        return null;
    }
}

