/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.repo.VFSNotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitNotebookRepo
extends VFSNotebookRepo
implements NotebookRepoWithVersionControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitNotebookRepo.class);
    private Git git;

    public GitNotebookRepo() {
    }

    @VisibleForTesting
    public GitNotebookRepo(ZeppelinConfiguration conf) throws IOException {
        this();
        this.init(conf);
    }

    @Override
    public void init(ZeppelinConfiguration conf) throws IOException {
        this.conf = conf;
        this.setNotebookDirectory(conf.getNotebookDir());
        LOGGER.info("Opening a git repo at '{}'", (Object)this.rootNotebookFolder);
        FileRepository localRepo = new FileRepository(String.join((CharSequence)File.separator, this.rootNotebookFolder, ".git"));
        if (!localRepo.getDirectory().exists()) {
            LOGGER.info("Git repo {} does not exist, creating a new one", (Object)localRepo.getDirectory());
            localRepo.create();
        }
        this.git = new Git((Repository)localRepo);
    }

    @Override
    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) throws IOException {
        super.move(noteId, notePath, newNotePath, subject);
        String noteFileName = this.buildNoteFileName(noteId, notePath);
        String newNoteFileName = this.buildNoteFileName(noteId, newNotePath);
        try {
            this.git.rm().addFilepattern(noteFileName).call();
            this.git.add().addFilepattern(newNoteFileName).call();
            this.git.commit().setMessage("Move note " + noteId + " from " + noteFileName + " to " + newNoteFileName).call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) throws IOException {
        super.move(folderPath, newFolderPath, subject);
        try {
            this.git.rm().addFilepattern(folderPath.substring(1)).call();
            this.git.add().addFilepattern(newFolderPath.substring(1)).call();
            this.git.commit().setMessage("Move folder " + folderPath + " to " + newFolderPath).call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        super.remove(noteId, notePath, subject);
        String noteFileName = this.buildNoteFileName(noteId, notePath);
        try {
            this.git.rm().addFilepattern(noteFileName).call();
            this.git.commit().setMessage("Remove note: " + noteId + ", notePath: " + notePath).call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void remove(String folderPath, AuthenticationInfo subject) throws IOException {
        super.remove(folderPath, subject);
        try {
            this.git.rm().addFilepattern(folderPath.substring(1)).call();
            this.git.commit().setMessage("Remove folder: " + folderPath).call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NotebookRepoWithVersionControl.Revision checkpoint(String noteId, String notePath, String commitMessage, AuthenticationInfo subject) throws IOException {
        String noteFileName = this.buildNoteFileName(noteId, notePath);
        NotebookRepoWithVersionControl.Revision revision = NotebookRepoWithVersionControl.Revision.EMPTY;
        try {
            List gitDiff = this.git.diff().call();
            boolean modified = gitDiff.parallelStream().anyMatch(diffEntry -> diffEntry.getNewPath().equals(noteFileName));
            if (modified) {
                LOGGER.debug("Changes found for pattern '{}': {}", (Object)noteFileName, (Object)gitDiff);
                DirCache added = this.git.add().addFilepattern(noteFileName).call();
                LOGGER.debug("{} changes are about to be commited", (Object)added.getEntryCount());
                RevCommit commit = this.git.commit().setMessage(commitMessage).call();
                revision = new NotebookRepoWithVersionControl.Revision(commit.getName(), commit.getShortMessage(), commit.getCommitTime());
            } else {
                LOGGER.debug("No changes found {}", (Object)noteFileName);
            }
        }
        catch (GitAPIException e) {
            LOGGER.error("Failed to add+commit {} to Git", (Object)noteFileName, (Object)e);
        }
        return revision;
    }

    @Override
    public synchronized Note get(String noteId, String notePath, String revId, AuthenticationInfo subject) throws IOException {
        Note note = null;
        RevCommit stash = null;
        String noteFileName = this.buildNoteFileName(noteId, notePath);
        try {
            boolean modified;
            List gitDiff = this.git.diff().setPathFilter((TreeFilter)PathFilter.create((String)noteFileName)).call();
            boolean bl = modified = !gitDiff.isEmpty();
            if (modified) {
                stash = this.git.stashCreate().call();
                Collection stashes = this.git.stashList().call();
                LOGGER.debug("Created stash : {}, stash size : {}", (Object)stash, (Object)stashes.size());
            }
            ObjectId head = this.git.getRepository().resolve("HEAD");
            this.git.checkout().setStartPoint(revId).addPath(noteFileName).call();
            note = super.get(noteId, notePath, subject);
            this.git.checkout().setStartPoint(head.getName()).addPath(noteFileName).call();
            if (modified && stash != null) {
                ObjectId applied = this.git.stashApply().setStashRef(stash.getName()).call();
                ObjectId dropped = this.git.stashDrop().setStashRef(0).call();
                Collection stashes = this.git.stashList().call();
                LOGGER.debug("Stash applied as : {}, and dropped : {}, stash size: {}", new Object[]{applied, dropped, stashes.size()});
            }
        }
        catch (GitAPIException e) {
            LOGGER.error("Failed to return note from revision \"{}\"", (Object)revId, (Object)e);
        }
        return note;
    }

    @Override
    public List<NotebookRepoWithVersionControl.Revision> revisionHistory(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        ArrayList<NotebookRepoWithVersionControl.Revision> history = new ArrayList<NotebookRepoWithVersionControl.Revision>();
        String noteFileName = this.buildNoteFileName(noteId, notePath);
        LOGGER.debug("Listing history for {}:", (Object)noteFileName);
        try {
            Iterable logs = this.git.log().addPath(noteFileName).call();
            for (RevCommit log : logs) {
                history.add(new NotebookRepoWithVersionControl.Revision(log.getName(), log.getShortMessage(), log.getCommitTime()));
                LOGGER.debug(" - ({},{},{})", new Object[]{log.getName(), log.getCommitTime(), log.getFullMessage()});
            }
        }
        catch (NoHeadException e) {
            LOGGER.warn("No Head found for {}, {}", (Object)noteFileName, (Object)e.getMessage());
        }
        catch (GitAPIException e) {
            LOGGER.error("Failed to get logs for {}", (Object)noteFileName, (Object)e);
        }
        return history;
    }

    @Override
    public Note setNoteRevision(String noteId, String notePath, String revId, AuthenticationInfo subject) throws IOException {
        Note revisionNote = this.get(noteId, notePath, revId, subject);
        if (revisionNote != null) {
            this.save(revisionNote, subject);
        }
        return revisionNote;
    }

    @Override
    public void close() {
        this.git.getRepository().close();
    }

    protected Git getGit() {
        return this.git;
    }

    void setGit(Git git) {
        this.git = git;
    }
}

