/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartOfSpeech {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartOfSpeech.class);
    private String pos;
    private String des;
    public static final PartOfSpeech I = new PartOfSpeech("i", "\u672a\u77e5");

    public PartOfSpeech(String string, String string2) {
        this.pos = string;
        this.des = string2;
    }

    public static PartOfSpeech valueOf(String string) {
        if (Objects.isNull(string) || "".equals(string.trim())) {
            return I;
        }
        PartOfSpeech partOfSpeech = (PartOfSpeech)PartOfSpeechMap.getPos().get(string.toLowerCase());
        if (partOfSpeech == null) {
            return new PartOfSpeech(string, "");
        }
        return partOfSpeech;
    }

    public static boolean isPos(String string) {
        return PartOfSpeechMap.getPos().get(string.toLowerCase()) != null;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String string) {
        this.pos = string;
    }

    public String getDes() {
        return this.des;
    }

    public void setDes(String string) {
        this.des = string;
    }

    public static void main(String[] stringArray) {
        System.out.println(PartOfSpeech.isPos("n"));
        System.out.println(PartOfSpeech.isPos("ns"));
        System.out.println(PartOfSpeech.isPos("nn"));
        System.out.println(I.getPos() + " " + I.getDes());
        PartOfSpeech partOfSpeech = new PartOfSpeech("n_animal", "\u52a8\u7269");
        System.out.println(partOfSpeech.getPos() + " " + partOfSpeech.getDes());
    }

    private static class PartOfSpeechMap {
        private static final Map<String, PartOfSpeech> POS = new HashMap<String, PartOfSpeech>();

        private PartOfSpeechMap() {
        }

        private static void init() {
            AutoDetector.loadAndWatch(new ResourceLoader(){

                @Override
                public void clear() {
                    POS.clear();
                }

                @Override
                public void load(List<String> list) {
                    LOGGER.info("\u521d\u59cb\u5316\u81ea\u5b9a\u4e49\u8bcd\u6027\u8bf4\u660e");
                    int n = 0;
                    for (String string : list) {
                        try {
                            String[] stringArray = string.split("=");
                            POS.put(stringArray[0], new PartOfSpeech(stringArray[0], stringArray[1]));
                            ++n;
                        }
                        catch (Exception exception) {
                            LOGGER.error("\u9519\u8bef\u7684\u81ea\u5b9a\u4e49\u8bcd\u6027\u8bf4\u660e\u6570\u636e\uff1a" + string);
                        }
                    }
                    LOGGER.info("\u81ea\u5b9a\u4e49\u8bcd\u6027\u8bf4\u660e\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u6570\u636e\u6761\u6570\uff1a" + n);
                }

                @Override
                public void add(String string) {
                    try {
                        String[] stringArray = string.split("=");
                        POS.put(stringArray[0], new PartOfSpeech(stringArray[0], stringArray[1]));
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684\u81ea\u5b9a\u4e49\u8bcd\u6027\u8bf4\u660e\u6570\u636e\uff1a" + string);
                    }
                }

                @Override
                public void remove(String string) {
                    try {
                        String[] stringArray = string.split("=");
                        POS.remove(stringArray[0]);
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684\u81ea\u5b9a\u4e49\u8bcd\u6027\u8bf4\u660e\u6570\u636e\uff1a" + string);
                    }
                }
            }, WordConfTools.get("part.of.speech.des.path", "classpath:part_of_speech_des.txt"));
        }

        private static Map<String, PartOfSpeech> getPos() {
            return POS;
        }

        static {
            PartOfSpeechMap.init();
        }
    }
}

