/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class FullSegmentation
extends AbstractSegmentation {
    private static final AbstractSegmentation RMM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.ReverseMaximumMatching);
    private static final int PROCESS_TEXT_LENGTH_LESS_THAN = 50;
    private static final int CHAR_IS_WORD_LENGTH_LESS_THAN = 18;

    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.FullSegmentation;
    }

    @Override
    public List<Word> segImpl(String string) {
        if (string.length() > 50) {
            return RMM.segImpl(string);
        }
        List<Word>[] listArray = this.fullSeg(string);
        Map<List<Word>, Float> map = this.ngram(listArray);
        List<Word> list = this.disambiguity(map);
        return list;
    }

    private List<Word> disambiguity(Map<List<Word>, Float> map) {
        List list = map.entrySet().parallelStream().sorted((entry, entry2) -> ((Float)entry2.getValue()).compareTo((Float)entry.getValue())).collect(Collectors.toList());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("ngram\u5206\u503c\uff1a");
            int n = 1;
            for (Map.Entry entry3 : list) {
                this.LOGGER.debug("\t" + n++ + "\u3001" + "\u8bcd\u4e2a\u6570=" + ((List)entry3.getKey()).size() + "\tngram\u5206\u503c=" + entry3.getValue() + "\t" + entry3.getKey());
            }
        }
        float f = ((Float)((Map.Entry)list.get(0)).getValue()).floatValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry3;
            entry3 = (Map.Entry)iterator.next();
            if (!(((Float)entry3.getValue()).floatValue() < f)) continue;
            ((List)entry3.getKey()).clear();
            iterator.remove();
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u53ea\u4fdd\u7559\u6700\u5927\u5206\u503c\uff1a");
            int n = 1;
            for (Map.Entry entry4 : list) {
                this.LOGGER.debug("\t" + n++ + "\u3001" + "\u8bcd\u4e2a\u6570=" + ((List)entry4.getKey()).size() + "\tngram\u5206\u503c=" + entry4.getValue() + "\t" + entry4.getKey());
            }
        }
        int n = Integer.MAX_VALUE;
        Object object = null;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry4;
            entry4 = (Map.Entry)iterator.next();
            if (((List)entry4.getKey()).size() < n) {
                n = ((List)entry4.getKey()).size();
                if (object != null) {
                    object.clear();
                }
                object = (List)entry4.getKey();
                continue;
            }
            ((List)entry4.getKey()).clear();
            iterator.remove();
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6700\u5927\u5206\u503c\uff1a" + f + ", \u6d88\u6b67\u7ed3\u679c\uff1a" + object + "\uff0c\u8bcd\u4e2a\u6570\uff1a" + n);
        }
        return object;
    }

    private List<Word>[] fullSeg(String string) {
        ArrayList<Node> arrayList;
        int n2 = string.length();
        List[] listArray = new LinkedList[n2];
        if (this.isParallelSeg()) {
            arrayList = new ArrayList<Integer>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add((Node)((Object)Integer.valueOf(i)));
            }
            arrayList.parallelStream().forEach(n -> {
                listArray[n.intValue()] = this.fullSeg(string, (int)n);
            });
        } else {
            for (int i = 0; i < n2; ++i) {
                listArray[i] = this.fullSeg(string, i);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u5168\u5207\u5206\u4e2d\u95f4\u7ed3\u679c\uff1a");
            int n3 = 1;
            for (List list : listArray) {
                this.LOGGER.debug("\t" + n3++ + "\u3001" + list);
            }
        }
        arrayList = new LinkedList();
        for (String string2 : listArray[0]) {
            Node node = new Node(string2);
            this.buildNode(node, listArray, string2.length(), arrayList);
        }
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i].clear();
            listArray[i] = null;
        }
        List<Word>[] listArray2 = this.toWords(arrayList);
        arrayList.clear();
        return listArray2;
    }

    private List<String> fullSeg(String string, int n) {
        int n2;
        LinkedList<String> linkedList = new LinkedList<String>();
        int n3 = string.length();
        int n4 = n3 - n;
        if (n4 > (n2 = this.getInterceptLength())) {
            n4 = n2;
        }
        while (n4 > 1) {
            if (this.getDictionary().contains(string, n, n4) || RecognitionTool.recog(string, n, n4)) {
                linkedList.add(string.substring(n, n + n4));
            }
            --n4;
        }
        if (n3 <= 18 || linkedList.isEmpty()) {
            linkedList.add(string.substring(n, n + 1));
        }
        return linkedList;
    }

    private void buildNode(Node node, List<String>[] listArray, int n, List<Node> list) {
        if (n >= listArray.length) {
            list.add(node);
            return;
        }
        for (String string : listArray[n]) {
            Node node2 = new Node(string, node);
            this.buildNode(node2, listArray, n + string.length(), list);
        }
    }

    private List<Word>[] toWords(List<Node> list) {
        ArrayList[] arrayListArray = new ArrayList[list.size()];
        int n = 0;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u5168\u5207\u5206\u7ed3\u679c\uff1a");
        }
        for (Node node : list) {
            arrayListArray[n++] = this.toWords(node);
            if (!this.LOGGER.isDebugEnabled()) continue;
            this.LOGGER.debug("\t" + n + "\uff1a" + arrayListArray[n - 1]);
        }
        return arrayListArray;
    }

    private List<Word> toWords(Node node) {
        Stack<String> stack = new Stack<String>();
        while (node != null) {
            stack.push(node.getText());
            node = node.getParent();
        }
        int n = stack.size();
        ArrayList<Word> arrayList = new ArrayList<Word>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Word((String)stack.pop()));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        FullSegmentation fullSegmentation = new FullSegmentation();
        if (stringArray != null && stringArray.length > 0) {
            System.out.println(fullSegmentation.seg(Arrays.asList(stringArray).toString()));
            return;
        }
        String string = "\u8776\u821e\u6253\u626e\u5f97\u6f02\u6f02\u4eae\u4eae\u51fa\u73b0\u5728\u5f20\u516c\u516c\u9762\u524d";
        System.out.println(fullSegmentation.seg(string));
    }

    private static class Node {
        private String text;
        private Node parent;

        public Node(String string) {
            this.text = string;
        }

        public Node(String string, Node node) {
            this.text = string;
            this.parent = node;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node node) {
            this.parent = node;
        }

        public String toString() {
            return this.text;
        }
    }
}

