/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Pattern;
import org.apdplat.word.recognition.StopWord;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Pattern PATTERN_ONE = Pattern.compile("^[\\u4e00-\\u9fa5]+$");
    private static final Pattern PATTERN_TWO = Pattern.compile("^[\\u4e00-\\u9fa5]{2,}$");

    public static boolean isChineseCharAndLengthAtLeastOne(String string) {
        return PATTERN_ONE.matcher(string).find();
    }

    public static boolean isChineseCharAndLengthAtLeastTwo(String string) {
        return PATTERN_TWO.matcher(string).find();
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                boolean bl = Utils.deleteDir(file2);
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void seg(File file, File file2, boolean bl, SegmentationAlgorithm segmentationAlgorithm) throws Exception {
        Utils.seg(file, file2, bl, segmentationAlgorithm, null);
    }

    public static void seg(File file, File file2, boolean bl, SegmentationAlgorithm segmentationAlgorithm, FileSegmentationCallback fileSegmentationCallback) throws Exception {
        LOGGER.info("\u5f00\u59cb\u5bf9\u6587\u4ef6\u8fdb\u884c\u5206\u8bcd\uff1a" + file.toString());
        Segmentation segmentation = SegmentationFactory.getSegmentation(segmentationAlgorithm);
        float f = (float)Runtime.getRuntime().maxMemory() / 1000000.0f;
        float f2 = (float)Runtime.getRuntime().totalMemory() / 1000000.0f;
        float f3 = (float)Runtime.getRuntime().freeMemory() / 1000000.0f;
        String string = "\u6267\u884c\u4e4b\u524d\u5269\u4f59\u5185\u5b58:" + f + "-" + f2 + "+" + f3 + "=" + (f - f2 + f3);
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        try (Object object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
             BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));){
            long l = Files.size(file.toPath());
            LOGGER.info("size:" + l);
            LOGGER.info("\u6587\u4ef6\u5927\u5c0f\uff1a" + (float)l / 1024.0f / 1024.0f + " MB");
            int n = 0;
            int n2 = 0;
            long l2 = System.currentTimeMillis();
            String string2 = null;
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if ("".equals(string2.trim())) {
                    bufferedWriter.write("\n");
                    continue;
                }
                n += string2.length();
                List<Word> list = segmentation.seg(string2);
                if (bl) {
                    StopWord.filterStopWords(list);
                }
                if (list == null) continue;
                for (Word word : list) {
                    if (fileSegmentationCallback != null) {
                        fileSegmentationCallback.callback(word);
                    }
                    bufferedWriter.write(word.getText() + " ");
                }
                bufferedWriter.write("\n");
                if ((n2 += string2.length()) <= 500000) continue;
                n2 = 0;
                LOGGER.info("\u5206\u8bcd\u8fdb\u5ea6\uff1a" + (int)((float)n * 2.0f / (float)l * 100.0f) + "%");
            }
            long l3 = System.currentTimeMillis() - l2;
            float f4 = (long)n / l3;
            LOGGER.info("\u5b57\u7b26\u6570\u76ee\uff1a" + n);
            LOGGER.info("\u5206\u8bcd\u8017\u65f6\uff1a" + Utils.getTimeDes(l3) + " \u6beb\u79d2");
            LOGGER.info("\u5206\u8bcd\u901f\u5ea6\uff1a" + f4 + " \u5b57\u7b26/\u6beb\u79d2");
        }
        f = (float)Runtime.getRuntime().maxMemory() / 1000000.0f;
        f2 = (float)Runtime.getRuntime().totalMemory() / 1000000.0f;
        f3 = (float)Runtime.getRuntime().freeMemory() / 1000000.0f;
        object = "\u6267\u884c\u4e4b\u540e\u5269\u4f59\u5185\u5b58:" + f + "-" + f2 + "+" + f3 + "=" + (f - f2 + f3);
        LOGGER.info(string);
        LOGGER.info((String)object);
        LOGGER.info("\u5c06\u6587\u4ef6 " + file.toString() + " \u7684\u5206\u8bcd\u7ed3\u679c\u4fdd\u5b58\u5230\u6587\u4ef6 " + file2);
    }

    public static String getTimeDes(Long l) {
        if (l == null) {
            return "";
        }
        int n = 1000;
        int n2 = n * 60;
        int n3 = n2 * 60;
        int n4 = n3 * 24;
        long l2 = l / (long)n4;
        long l3 = (l - l2 * (long)n4) / (long)n3;
        long l4 = (l - l2 * (long)n4 - l3 * (long)n3) / (long)n2;
        long l5 = (l - l2 * (long)n4 - l3 * (long)n3 - l4 * (long)n2) / (long)n;
        long l6 = l - l2 * (long)n4 - l3 * (long)n3 - l4 * (long)n2 - l5 * (long)n;
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 > 0L) {
            stringBuilder.append(l2).append("\u5929,");
        }
        if (l3 > 0L) {
            stringBuilder.append(l3).append("\u5c0f\u65f6,");
        }
        if (l4 > 0L) {
            stringBuilder.append(l4).append("\u5206\u949f,");
        }
        if (l5 > 0L) {
            stringBuilder.append(l5).append("\u79d2,");
        }
        if (l6 > 0L) {
            stringBuilder.append(l6).append("\u6beb\u79d2,");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static interface FileSegmentationCallback {
        public void callback(Word var1);
    }
}

