/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.Closeables;
import com.upokecenter.cbor.CBORObject;
import com.yubico.core.DefaultSessionManager;
import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.data.AssertionRequestWrapper;
import com.yubico.data.AssertionResponse;
import com.yubico.data.CredentialRegistration;
import com.yubico.data.RegistrationRequest;
import com.yubico.data.RegistrationResponse;
import com.yubico.data.U2fRegistrationResponse;
import com.yubico.data.U2fRegistrationResult;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.util.Either;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.U2fVerifier;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.AttestationResolver;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.MetadataService;
import com.yubico.webauthn.attestation.StandardMetadataService;
import com.yubico.webauthn.attestation.TrustResolver;
import com.yubico.webauthn.attestation.resolver.CompositeAttestationResolver;
import com.yubico.webauthn.attestation.resolver.CompositeTrustResolver;
import com.yubico.webauthn.attestation.resolver.SimpleAttestationResolver;
import com.yubico.webauthn.attestation.resolver.SimpleTrustResolverWithEquality;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorData;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import com.yubico.webauthn.extension.appid.AppId;
import com.yubico.webauthn.extension.appid.InvalidAppIdException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnServer {
    private static final Logger logger = LoggerFactory.getLogger(WebAuthnServer.class);
    private static final SecureRandom random = new SecureRandom();
    private static final String PREVIEW_METADATA_PATH = "/preview-metadata.json";
    private Cache<ByteArray, AssertionRequestWrapper> assertRequestStorage;
    private Cache<ByteArray, RegistrationRequest> registerRequestStorage;
    private RegistrationStorage userStorage;
    private SessionManager sessions = new DefaultSessionManager();
    private TrustResolver trustResolver = new CompositeTrustResolver(Arrays.asList(StandardMetadataService.createDefaultTrustResolver(), WebAuthnServer.createExtraTrustResolver()));
    private MetadataService metadataService = new StandardMetadataService((AttestationResolver)new CompositeAttestationResolver(Arrays.asList(StandardMetadataService.createDefaultAttestationResolver((TrustResolver)this.trustResolver), WebAuthnServer.createExtraMetadataResolver(this.trustResolver))));
    private final Clock clock = Clock.systemDefaultZone();
    private final ObjectMapper jsonMapper = JacksonCodecs.json();
    private final RelyingParty rp;

    public WebAuthnServer(RegistrationStorage userStorage, Cache<ByteArray, RegistrationRequest> registerRequestStorage, Cache<ByteArray, AssertionRequestWrapper> assertRequestStorage, RelyingPartyIdentity rpIdentity, Set<String> origins, Optional<AppId> appId) throws InvalidAppIdException, CertificateException {
        this.userStorage = userStorage;
        this.registerRequestStorage = registerRequestStorage;
        this.assertRequestStorage = assertRequestStorage;
        this.rp = RelyingParty.builder().identity(rpIdentity).credentialRepository((CredentialRepository)this.userStorage).origins(origins).attestationConveyancePreference(Optional.of(AttestationConveyancePreference.DIRECT)).metadataService(Optional.of(this.metadataService)).allowOriginPort(false).allowOriginSubdomain(false).allowUnrequestedExtensions(true).allowUntrustedAttestation(true).validateSignatureCounter(true).appId(appId).build();
    }

    public WebAuthnServer(RelyingParty rpId) throws CertificateException {
        this.rp = rpId;
    }

    public WebAuthnServer(RegistrationStorage userStorage, Cache<ByteArray, RegistrationRequest> registerRequestStorage, Cache<ByteArray, AssertionRequestWrapper> assertRequestStorage, RelyingParty rpId, SessionManager sessionManager) throws CertificateException {
        this.userStorage = userStorage;
        this.registerRequestStorage = registerRequestStorage;
        this.assertRequestStorage = assertRequestStorage;
        this.rp = rpId;
        this.sessions = sessionManager;
    }

    private static ByteArray generateRandom(int length) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return new ByteArray(bytes);
    }

    private static MetadataObject readPreviewMetadata() {
        InputStream is = WebAuthnServer.class.getResourceAsStream(PREVIEW_METADATA_PATH);
        try {
            MetadataObject metadataObject = (MetadataObject)JacksonCodecs.json().readValue(is, MetadataObject.class);
            return metadataObject;
        }
        catch (IOException e) {
            throw ExceptionUtil.wrapAndLog((Logger)logger, (String)"Failed to read metadata from /preview-metadata.json", (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    private static TrustResolver createExtraTrustResolver() {
        try {
            MetadataObject metadata = WebAuthnServer.readPreviewMetadata();
            return new SimpleTrustResolverWithEquality(metadata.getParsedTrustedCertificates());
        }
        catch (CertificateException e) {
            throw ExceptionUtil.wrapAndLog((Logger)logger, (String)"Failed to read trusted certificate(s)", (Throwable)e);
        }
    }

    private static AttestationResolver createExtraMetadataResolver(TrustResolver trustResolver) {
        try {
            MetadataObject metadata = WebAuthnServer.readPreviewMetadata();
            return new SimpleAttestationResolver(Collections.singleton(metadata), trustResolver);
        }
        catch (CertificateException e) {
            throw ExceptionUtil.wrapAndLog((Logger)logger, (String)"Failed to read trusted certificate(s)", (Throwable)e);
        }
    }

    private static <K, V> Cache<K, V> newCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    }

    public Either<String, RegistrationRequest> startRegistration(@NonNull String username, Optional<String> displayName, Optional<String> credentialNickname, boolean requireResidentKey, Optional<ByteArray> sessionToken) throws ExecutionException {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        logger.trace("startRegistration username: {}, credentialNickname: {}", (Object)username, credentialNickname);
        Collection<CredentialRegistration> registrations = this.userStorage.getRegistrationsByUsername(username);
        Optional<UserIdentity> existingUser = registrations.stream().findAny().map(CredentialRegistration::getUserIdentity);
        boolean permissionGranted = existingUser.map(userIdentity -> this.sessions.isSessionForUser(userIdentity.getId(), sessionToken)).orElse(true);
        if (permissionGranted) {
            UserIdentity registrationUserId = existingUser.orElseGet(() -> UserIdentity.builder().name(username).displayName((String)displayName.get()).id(WebAuthnServer.generateRandom(32)).build());
            RegistrationRequest request = new RegistrationRequest(username, credentialNickname, WebAuthnServer.generateRandom(32), this.rp.startRegistration(StartRegistrationOptions.builder().user(registrationUserId).authenticatorSelection(AuthenticatorSelectionCriteria.builder().requireResidentKey(requireResidentKey).build()).build()), Optional.of(this.sessions.createSession(registrationUserId.getId())));
            this.registerRequestStorage.put((Object)request.getRequestId(), (Object)request);
            return Either.right(request);
        }
        return Either.left("The username \"" + username + "\" is already registered.");
    }

    public Either<List<String>, SuccessfulRegistrationResult> finishRegistration(String responseJson) {
        logger.trace("finishRegistration responseJson: {}", (Object)responseJson);
        RegistrationResponse response = null;
        try {
            response = (RegistrationResponse)this.jsonMapper.readValue(responseJson, RegistrationResponse.class);
        }
        catch (IOException e) {
            logger.error("JSON error in finishRegistration; responseJson: {}", (Object)responseJson, (Object)e);
            return Either.left(Arrays.asList("Registration failed!", "Failed to decode response object.", e.getMessage()));
        }
        RegistrationRequest request = (RegistrationRequest)this.registerRequestStorage.getIfPresent((Object)response.getRequestId());
        this.registerRequestStorage.invalidate((Object)response.getRequestId());
        if (request == null) {
            logger.debug("fail finishRegistration responseJson: {}", (Object)responseJson);
            return Either.left(Arrays.asList("Registration failed!", "No such registration in progress."));
        }
        try {
            RegistrationResult registration = this.rp.finishRegistration(FinishRegistrationOptions.builder().request(request.getPublicKeyCredentialCreationOptions()).response(response.getCredential()).build());
            if (this.userStorage.userExists(request.getUsername())) {
                boolean permissionGranted = false;
                boolean isValidSession = request.getSessionToken().map(token -> this.sessions.isSessionForUser(request.getPublicKeyCredentialCreationOptions().getUser().getId(), (ByteArray)token)).orElse(false);
                logger.debug("Session token: {}", request.getSessionToken());
                logger.debug("Valid session: {}", (Object)isValidSession);
                if (isValidSession) {
                    permissionGranted = true;
                    logger.info("Session token accepted for user {}", (Object)request.getPublicKeyCredentialCreationOptions().getUser().getId());
                }
                logger.debug("permissionGranted: {}", (Object)permissionGranted);
                if (!permissionGranted) {
                    throw new RegistrationFailedException(new IllegalArgumentException(String.format("User %s already exists", request.getUsername())));
                }
            }
            return Either.right(new SuccessfulRegistrationResult(request, response, this.addRegistration(request.getPublicKeyCredentialCreationOptions().getUser(), request.getCredentialNickname(), response, registration), registration.isAttestationTrusted(), this.sessions.createSession(request.getPublicKeyCredentialCreationOptions().getUser().getId())));
        }
        catch (RegistrationFailedException e) {
            logger.debug("fail finishRegistration responseJson: {}", (Object)responseJson, (Object)e);
            return Either.left(Arrays.asList("Registration failed!", e.getMessage()));
        }
        catch (Exception e) {
            logger.error("fail finishRegistration responseJson: {}", (Object)responseJson, (Object)e);
            return Either.left(Arrays.asList("Registration failed unexpectedly; this is likely a bug.", e.getMessage()));
        }
    }

    public Either<List<String>, SuccessfulU2fRegistrationResult> finishU2fRegistration(String responseJson) throws ExecutionException {
        logger.trace("finishU2fRegistration responseJson: {}", (Object)responseJson);
        U2fRegistrationResponse response = null;
        try {
            response = (U2fRegistrationResponse)this.jsonMapper.readValue(responseJson, U2fRegistrationResponse.class);
        }
        catch (IOException e) {
            logger.error("JSON error in finishU2fRegistration; responseJson: {}", (Object)responseJson, (Object)e);
            return Either.left(Arrays.asList("Registration failed!", "Failed to decode response object.", e.getMessage()));
        }
        RegistrationRequest request = (RegistrationRequest)this.registerRequestStorage.getIfPresent((Object)response.getRequestId());
        this.registerRequestStorage.invalidate((Object)response.getRequestId());
        if (request == null) {
            logger.debug("fail finishU2fRegistration responseJson: {}", (Object)responseJson);
            return Either.left(Arrays.asList("Registration failed!", "No such registration in progress."));
        }
        try {
            ExceptionUtil.assure((boolean)U2fVerifier.verify((AppId)this.rp.getAppId().get(), request, response), (String)"Failed to verify signature.", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Failed to verify U2F signature.", (Throwable)e);
            return Either.left(Arrays.asList("Failed to verify signature.", e.getMessage()));
        }
        X509Certificate attestationCert = null;
        try {
            attestationCert = CertificateParser.parseDer((byte[])response.getCredential().getU2fResponse().getAttestationCertAndSignature().getBytes());
        }
        catch (CertificateException e) {
            logger.error("Failed to parse attestation certificate: {}", (Object)response.getCredential().getU2fResponse().getAttestationCertAndSignature(), (Object)e);
        }
        Optional<Object> attestation = Optional.empty();
        try {
            if (attestationCert != null) {
                attestation = Optional.of(this.metadataService.getAttestation(Collections.singletonList(attestationCert)));
            }
        }
        catch (CertificateEncodingException e) {
            logger.error("Failed to resolve attestation", (Throwable)e);
        }
        U2fRegistrationResult result = U2fRegistrationResult.builder().keyId(PublicKeyCredentialDescriptor.builder().id(response.getCredential().getU2fResponse().getKeyHandle()).build()).attestationTrusted(attestation.map(Attestation::isTrusted).orElse(false)).publicKeyCose(WebAuthnServer.rawEcdaKeyToCose(response.getCredential().getU2fResponse().getPublicKey())).attestationMetadata(attestation).build();
        return Either.right(new SuccessfulU2fRegistrationResult(request, response, this.addRegistration(request.getPublicKeyCredentialCreationOptions().getUser(), request.getCredentialNickname(), 0L, result), result.isAttestationTrusted(), Optional.of(new AttestationCertInfo(response.getCredential().getU2fResponse().getAttestationCertAndSignature())), request.getUsername(), this.sessions.createSession(request.getPublicKeyCredentialCreationOptions().getUser().getId())));
    }

    public Either<List<String>, AssertionRequestWrapper> startAuthentication(Optional<String> username) {
        logger.trace("startAuthentication username: {}", username);
        if (username.isPresent() && !this.userStorage.userExists(username.get())) {
            return Either.left(Collections.singletonList("The username \"" + username.get() + "\" is not registered."));
        }
        AssertionRequestWrapper request = new AssertionRequestWrapper(WebAuthnServer.generateRandom(32), this.rp.startAssertion(StartAssertionOptions.builder().username(username).build()));
        this.assertRequestStorage.put((Object)request.getRequestId(), (Object)request);
        return Either.right(request);
    }

    public Either<List<String>, SuccessfulAuthenticationResult> finishAuthentication(String responseJson) {
        AssertionResponse response;
        logger.trace("finishAuthentication responseJson: {}", (Object)responseJson);
        try {
            response = (AssertionResponse)this.jsonMapper.readValue(responseJson, AssertionResponse.class);
        }
        catch (IOException e) {
            logger.debug("Failed to decode response object", (Throwable)e);
            return Either.left(Arrays.asList("Assertion failed!", "Failed to decode response object.", e.getMessage()));
        }
        AssertionRequestWrapper request = (AssertionRequestWrapper)this.assertRequestStorage.getIfPresent((Object)response.getRequestId());
        this.assertRequestStorage.invalidate((Object)response.getRequestId());
        if (request == null) {
            return Either.left(Arrays.asList("Assertion failed!", "No such assertion in progress."));
        }
        try {
            AssertionResult result = this.rp.finishAssertion(FinishAssertionOptions.builder().request(request.getRequest()).response(response.getCredential()).build());
            if (result.isSuccess()) {
                try {
                    this.userStorage.updateSignatureCount(result);
                }
                catch (Exception e) {
                    logger.error("Failed to update signature count for user \"{}\", credential \"{}\"", new Object[]{result.getUsername(), response.getCredential().getId(), e});
                }
                return Either.right(new SuccessfulAuthenticationResult(request, response, this.userStorage.getRegistrationsByUsername(result.getUsername()), result.getUsername(), this.sessions.createSession(result.getUserHandle()), result.getWarnings()));
            }
            return Either.left(Collections.singletonList("Assertion failed: Invalid assertion."));
        }
        catch (AssertionFailedException e) {
            logger.debug("Assertion failed", (Throwable)e);
            return Either.left(Arrays.asList("Assertion failed!", e.getMessage()));
        }
        catch (Exception e) {
            logger.error("Assertion failed", (Throwable)e);
            return Either.left(Arrays.asList("Assertion failed unexpectedly; this is likely a bug.", e.getMessage()));
        }
    }

    public Either<List<String>, DeregisterCredentialResult> deregisterCredential(@NonNull ByteArray sessionToken, ByteArray credentialId) {
        if (sessionToken == null) {
            throw new NullPointerException("sessionToken is marked non-null but is null");
        }
        logger.trace("deregisterCredential session: {}, credentialId: {}", (Object)sessionToken, (Object)credentialId);
        if (credentialId == null || credentialId.getBytes().length == 0) {
            return Either.left(Collections.singletonList("Credential ID must not be empty."));
        }
        Optional<ByteArray> session = this.sessions.getSession(sessionToken);
        if (session.isPresent()) {
            ByteArray userHandle = session.get();
            Optional username = this.userStorage.getUsernameForUserHandle(userHandle);
            if (username.isPresent()) {
                Optional<CredentialRegistration> credReg = this.userStorage.getRegistrationByUsernameAndCredentialId((String)username.get(), credentialId);
                if (credReg.isPresent()) {
                    this.userStorage.removeRegistrationByUsername((String)username.get(), credReg.get());
                    return Either.right(new DeregisterCredentialResult(credReg.get(), !this.userStorage.userExists((String)username.get())));
                }
                return Either.left(Collections.singletonList("Credential ID not registered:" + credentialId));
            }
            return Either.left(Collections.singletonList("Invalid user handle"));
        }
        return Either.left(Collections.singletonList("Invalid session"));
    }

    public <T> Either<List<String>, T> deleteAccount(String username, Supplier<T> onSuccess) {
        logger.trace("deleteAccount username: {}", (Object)username);
        if (username == null || username.isEmpty()) {
            return Either.left(Collections.singletonList("Username must not be empty."));
        }
        boolean removed = this.userStorage.removeAllRegistrations(username);
        if (removed) {
            return Either.right(onSuccess.get());
        }
        return Either.left(Collections.singletonList("Username not registered:" + username));
    }

    private CredentialRegistration addRegistration(UserIdentity userIdentity, Optional<String> nickname, RegistrationResponse response, RegistrationResult result) {
        return this.addRegistration(userIdentity, nickname, ((AuthenticatorAttestationResponse)response.getCredential().getResponse()).getAttestation().getAuthenticatorData().getSignatureCounter(), RegisteredCredential.builder().credentialId(result.getKeyId().getId()).userHandle(userIdentity.getId()).publicKeyCose(result.getPublicKeyCose()).signatureCount(((AuthenticatorAttestationResponse)response.getCredential().getResponse()).getParsedAuthenticatorData().getSignatureCounter()).build(), result.getAttestationMetadata());
    }

    private CredentialRegistration addRegistration(UserIdentity userIdentity, Optional<String> nickname, long signatureCount, U2fRegistrationResult result) {
        return this.addRegistration(userIdentity, nickname, signatureCount, RegisteredCredential.builder().credentialId(result.getKeyId().getId()).userHandle(userIdentity.getId()).publicKeyCose(result.getPublicKeyCose()).signatureCount(signatureCount).build(), result.getAttestationMetadata());
    }

    private CredentialRegistration addRegistration(UserIdentity userIdentity, Optional<String> nickname, long signatureCount, RegisteredCredential credential, Optional<Attestation> attestationMetadata) {
        CredentialRegistration reg = CredentialRegistration.builder().userIdentity(userIdentity).credentialNickname(nickname).registrationTime(this.clock.instant()).credential(credential).signatureCount(signatureCount).attestationMetadata(attestationMetadata).build();
        logger.debug("Adding registration: user: {}, nickname: {}, credential: {}", new Object[]{userIdentity, nickname, credential});
        this.userStorage.addRegistrationByUsername(userIdentity.getName(), reg);
        return reg;
    }

    static ByteArray rawEcdaKeyToCose(ByteArray key) {
        byte[] keyBytes = key.getBytes();
        if (keyBytes.length != 64 && (keyBytes.length != 65 || keyBytes[0] != 4)) {
            throw new IllegalArgumentException(String.format("Raw key must be 64 bytes long or be 65 bytes long and start with 0x04, was %d bytes starting with %02x", keyBytes.length, keyBytes[0]));
        }
        int start = keyBytes.length == 64 ? 0 : 1;
        HashMap<Long, Object> coseKey = new HashMap<Long, Object>();
        coseKey.put(1L, 2L);
        coseKey.put(3L, COSEAlgorithmIdentifier.ES256.getId());
        coseKey.put(-1L, 1L);
        coseKey.put(-2L, Arrays.copyOfRange(keyBytes, start, start + 32));
        coseKey.put(-3L, Arrays.copyOfRange(keyBytes, start + 32, start + 64));
        return new ByteArray(CBORObject.FromObject(coseKey).EncodeToBytes());
    }

    public void setAssertRequestStorage(Cache<ByteArray, AssertionRequestWrapper> assertRequestStorage) {
        this.assertRequestStorage = assertRequestStorage;
    }

    public void setRegisterRequestStorage(Cache<ByteArray, RegistrationRequest> registerRequestStorage) {
        this.registerRequestStorage = registerRequestStorage;
    }

    public void setUserStorage(RegistrationStorage userStorage) {
        this.userStorage = userStorage;
    }

    public void setSessions(SessionManager sessions) {
        this.sessions = sessions;
    }

    public void setTrustResolver(TrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    private static class AuthDataSerializer
    extends JsonSerializer<AuthenticatorData> {
        private AuthDataSerializer() {
        }

        public void serialize(AuthenticatorData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("rpIdHash", value.getRpIdHash().getHex());
            gen.writeObjectField("flags", (Object)value.getFlags());
            gen.writeNumberField("signatureCounter", value.getSignatureCounter());
            value.getAttestedCredentialData().ifPresent(acd -> {
                try {
                    gen.writeObjectFieldStart("attestedCredentialData");
                    gen.writeStringField("aaguid", acd.getAaguid().getHex());
                    gen.writeStringField("credentialId", acd.getCredentialId().getHex());
                    gen.writeStringField("publicKey", acd.getCredentialPublicKey().getHex());
                    gen.writeEndObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            gen.writeObjectField("extensions", (Object)value.getExtensions());
            gen.writeEndObject();
        }
    }

    public static final class DeregisterCredentialResult {
        private final boolean success = true;
        private final CredentialRegistration droppedRegistration;
        private final boolean accountDeleted;

        public DeregisterCredentialResult(CredentialRegistration droppedRegistration, boolean accountDeleted) {
            this.droppedRegistration = droppedRegistration;
            this.accountDeleted = accountDeleted;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public CredentialRegistration getDroppedRegistration() {
            return this.droppedRegistration;
        }

        public boolean isAccountDeleted() {
            return this.accountDeleted;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeregisterCredentialResult)) {
                return false;
            }
            DeregisterCredentialResult other = (DeregisterCredentialResult)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.isAccountDeleted() != other.isAccountDeleted()) {
                return false;
            }
            CredentialRegistration this$droppedRegistration = this.getDroppedRegistration();
            CredentialRegistration other$droppedRegistration = other.getDroppedRegistration();
            return !(this$droppedRegistration == null ? other$droppedRegistration != null : !((Object)this$droppedRegistration).equals(other$droppedRegistration));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + (this.isAccountDeleted() ? 79 : 97);
            CredentialRegistration $droppedRegistration = this.getDroppedRegistration();
            result = result * 59 + ($droppedRegistration == null ? 43 : ((Object)$droppedRegistration).hashCode());
            return result;
        }

        public String toString() {
            return "WebAuthnServer.DeregisterCredentialResult(success=" + this.isSuccess() + ", droppedRegistration=" + this.getDroppedRegistration() + ", accountDeleted=" + this.isAccountDeleted() + ")";
        }
    }

    public static final class SuccessfulAuthenticationResult {
        private final boolean success = true;
        private final AssertionRequestWrapper request;
        private final AssertionResponse response;
        private final Collection<CredentialRegistration> registrations;
        @JsonSerialize(using=AuthDataSerializer.class)
        private final AuthenticatorData authData;
        private final String username;
        private final ByteArray sessionToken;
        private final List<String> warnings;

        public SuccessfulAuthenticationResult(AssertionRequestWrapper request, AssertionResponse response, Collection<CredentialRegistration> registrations, String username, ByteArray sessionToken, List<String> warnings) {
            this(request, response, registrations, ((AuthenticatorAssertionResponse)response.getCredential().getResponse()).getParsedAuthenticatorData(), username, sessionToken, warnings);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public AssertionRequestWrapper getRequest() {
            return this.request;
        }

        public AssertionResponse getResponse() {
            return this.response;
        }

        public Collection<CredentialRegistration> getRegistrations() {
            return this.registrations;
        }

        public AuthenticatorData getAuthData() {
            return this.authData;
        }

        public String getUsername() {
            return this.username;
        }

        public ByteArray getSessionToken() {
            return this.sessionToken;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuccessfulAuthenticationResult)) {
                return false;
            }
            SuccessfulAuthenticationResult other = (SuccessfulAuthenticationResult)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            AssertionRequestWrapper this$request = this.getRequest();
            AssertionRequestWrapper other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            AssertionResponse this$response = this.getResponse();
            AssertionResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            Collection<CredentialRegistration> this$registrations = this.getRegistrations();
            Collection<CredentialRegistration> other$registrations = other.getRegistrations();
            if (this$registrations == null ? other$registrations != null : !((Object)this$registrations).equals(other$registrations)) {
                return false;
            }
            AuthenticatorData this$authData = this.getAuthData();
            AuthenticatorData other$authData = other.getAuthData();
            if (this$authData == null ? other$authData != null : !this$authData.equals(other$authData)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$sessionToken = this.getSessionToken();
            ByteArray other$sessionToken = other.getSessionToken();
            if (this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken)) {
                return false;
            }
            List<String> this$warnings = this.getWarnings();
            List<String> other$warnings = other.getWarnings();
            return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            AssertionRequestWrapper $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            AssertionResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            Collection<CredentialRegistration> $registrations = this.getRegistrations();
            result = result * 59 + ($registrations == null ? 43 : ((Object)$registrations).hashCode());
            AuthenticatorData $authData = this.getAuthData();
            result = result * 59 + ($authData == null ? 43 : $authData.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $sessionToken = this.getSessionToken();
            result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
            List<String> $warnings = this.getWarnings();
            result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
            return result;
        }

        public String toString() {
            return "WebAuthnServer.SuccessfulAuthenticationResult(success=" + this.isSuccess() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", registrations=" + this.getRegistrations() + ", authData=" + this.getAuthData() + ", username=" + this.getUsername() + ", sessionToken=" + this.getSessionToken() + ", warnings=" + this.getWarnings() + ")";
        }

        public SuccessfulAuthenticationResult(AssertionRequestWrapper request, AssertionResponse response, Collection<CredentialRegistration> registrations, AuthenticatorData authData, String username, ByteArray sessionToken, List<String> warnings) {
            this.request = request;
            this.response = response;
            this.registrations = registrations;
            this.authData = authData;
            this.username = username;
            this.sessionToken = sessionToken;
            this.warnings = warnings;
        }
    }

    public static final class AttestationCertInfo {
        private final ByteArray der;
        private final String text;

        public AttestationCertInfo(ByteArray certDer) {
            this.der = certDer;
            X509Certificate cert = null;
            try {
                cert = CertificateParser.parseDer((byte[])certDer.getBytes());
            }
            catch (CertificateException e) {
                logger.error("Failed to parse attestation certificate");
            }
            this.text = cert == null ? null : cert.toString();
        }

        public ByteArray getDer() {
            return this.der;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttestationCertInfo)) {
                return false;
            }
            AttestationCertInfo other = (AttestationCertInfo)o;
            ByteArray this$der = this.getDer();
            ByteArray other$der = other.getDer();
            if (this$der == null ? other$der != null : !this$der.equals(other$der)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $der = this.getDer();
            result = result * 59 + ($der == null ? 43 : $der.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "WebAuthnServer.AttestationCertInfo(der=" + this.getDer() + ", text=" + this.getText() + ")";
        }
    }

    public final class SuccessfulU2fRegistrationResult {
        private final boolean success = true;
        private final RegistrationRequest request;
        private final U2fRegistrationResponse response;
        private final CredentialRegistration registration;
        private final boolean attestationTrusted;
        private final Optional<AttestationCertInfo> attestationCert;
        private final String username;
        private final ByteArray sessionToken;

        public SuccessfulU2fRegistrationResult(RegistrationRequest request, U2fRegistrationResponse response, CredentialRegistration registration, boolean attestationTrusted, Optional<AttestationCertInfo> attestationCert, String username, ByteArray sessionToken) {
            this.request = request;
            this.response = response;
            this.registration = registration;
            this.attestationTrusted = attestationTrusted;
            this.attestationCert = attestationCert;
            this.username = username;
            this.sessionToken = sessionToken;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public RegistrationRequest getRequest() {
            return this.request;
        }

        public U2fRegistrationResponse getResponse() {
            return this.response;
        }

        public CredentialRegistration getRegistration() {
            return this.registration;
        }

        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        public Optional<AttestationCertInfo> getAttestationCert() {
            return this.attestationCert;
        }

        public String getUsername() {
            return this.username;
        }

        public ByteArray getSessionToken() {
            return this.sessionToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuccessfulU2fRegistrationResult)) {
                return false;
            }
            SuccessfulU2fRegistrationResult other = (SuccessfulU2fRegistrationResult)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            RegistrationRequest this$request = this.getRequest();
            RegistrationRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            U2fRegistrationResponse this$response = this.getResponse();
            U2fRegistrationResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            CredentialRegistration this$registration = this.getRegistration();
            CredentialRegistration other$registration = other.getRegistration();
            if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
                return false;
            }
            Optional<AttestationCertInfo> this$attestationCert = this.getAttestationCert();
            Optional<AttestationCertInfo> other$attestationCert = other.getAttestationCert();
            if (this$attestationCert == null ? other$attestationCert != null : !((Object)this$attestationCert).equals(other$attestationCert)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$sessionToken = this.getSessionToken();
            ByteArray other$sessionToken = other.getSessionToken();
            return !(this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            RegistrationRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            U2fRegistrationResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            CredentialRegistration $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            Optional<AttestationCertInfo> $attestationCert = this.getAttestationCert();
            result = result * 59 + ($attestationCert == null ? 43 : ((Object)$attestationCert).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $sessionToken = this.getSessionToken();
            result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
            return result;
        }

        public String toString() {
            return "WebAuthnServer.SuccessfulU2fRegistrationResult(success=" + this.isSuccess() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", registration=" + this.getRegistration() + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationCert=" + this.getAttestationCert() + ", username=" + this.getUsername() + ", sessionToken=" + this.getSessionToken() + ")";
        }
    }

    public static final class SuccessfulRegistrationResult {
        private final boolean success = true;
        private final RegistrationRequest request;
        private final RegistrationResponse response;
        private final CredentialRegistration registration;
        private final boolean attestationTrusted;
        private final Optional<AttestationCertInfo> attestationCert;
        @JsonSerialize(using=AuthDataSerializer.class)
        private final AuthenticatorData authData;
        private final String username;
        private final ByteArray sessionToken;

        public SuccessfulRegistrationResult(RegistrationRequest request, RegistrationResponse response, CredentialRegistration registration, boolean attestationTrusted, ByteArray sessionToken) {
            this.request = request;
            this.response = response;
            this.registration = registration;
            this.attestationTrusted = attestationTrusted;
            this.attestationCert = Optional.ofNullable(((AuthenticatorAttestationResponse)response.getCredential().getResponse()).getAttestation().getAttestationStatement().get("x5c")).map(certs -> certs.get(0)).flatMap(certDer -> {
                try {
                    return Optional.of(new ByteArray(certDer.binaryValue()));
                }
                catch (IOException e) {
                    logger.error("Failed to get binary value from x5c element: {}", certDer, (Object)e);
                    return Optional.empty();
                }
            }).map(AttestationCertInfo::new);
            this.authData = ((AuthenticatorAttestationResponse)response.getCredential().getResponse()).getParsedAuthenticatorData();
            this.username = request.getUsername();
            this.sessionToken = sessionToken;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public RegistrationRequest getRequest() {
            return this.request;
        }

        public RegistrationResponse getResponse() {
            return this.response;
        }

        public CredentialRegistration getRegistration() {
            return this.registration;
        }

        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        public Optional<AttestationCertInfo> getAttestationCert() {
            return this.attestationCert;
        }

        public AuthenticatorData getAuthData() {
            return this.authData;
        }

        public String getUsername() {
            return this.username;
        }

        public ByteArray getSessionToken() {
            return this.sessionToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuccessfulRegistrationResult)) {
                return false;
            }
            SuccessfulRegistrationResult other = (SuccessfulRegistrationResult)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            RegistrationRequest this$request = this.getRequest();
            RegistrationRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            RegistrationResponse this$response = this.getResponse();
            RegistrationResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            CredentialRegistration this$registration = this.getRegistration();
            CredentialRegistration other$registration = other.getRegistration();
            if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
                return false;
            }
            Optional<AttestationCertInfo> this$attestationCert = this.getAttestationCert();
            Optional<AttestationCertInfo> other$attestationCert = other.getAttestationCert();
            if (this$attestationCert == null ? other$attestationCert != null : !((Object)this$attestationCert).equals(other$attestationCert)) {
                return false;
            }
            AuthenticatorData this$authData = this.getAuthData();
            AuthenticatorData other$authData = other.getAuthData();
            if (this$authData == null ? other$authData != null : !this$authData.equals(other$authData)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$sessionToken = this.getSessionToken();
            ByteArray other$sessionToken = other.getSessionToken();
            return !(this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            RegistrationRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            RegistrationResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            CredentialRegistration $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            Optional<AttestationCertInfo> $attestationCert = this.getAttestationCert();
            result = result * 59 + ($attestationCert == null ? 43 : ((Object)$attestationCert).hashCode());
            AuthenticatorData $authData = this.getAuthData();
            result = result * 59 + ($authData == null ? 43 : $authData.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $sessionToken = this.getSessionToken();
            result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
            return result;
        }

        public String toString() {
            return "WebAuthnServer.SuccessfulRegistrationResult(success=" + this.isSuccess() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", registration=" + this.getRegistration() + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationCert=" + this.getAttestationCert() + ", authData=" + this.getAuthData() + ", username=" + this.getUsername() + ", sessionToken=" + this.getSessionToken() + ")";
        }
    }
}

