/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.util.Optional;
import lombok.NonNull;

public final class AssertionRequestWrapper {
    @NonNull
    private final ByteArray requestId;
    @NonNull
    private final PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
    @NonNull
    private final Optional<String> username;
    @JsonIgnore
    @NonNull
    private final transient AssertionRequest request;

    public AssertionRequestWrapper(@NonNull ByteArray requestId, @NonNull AssertionRequest request) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.requestId = requestId;
        this.publicKeyCredentialRequestOptions = request.getPublicKeyCredentialRequestOptions();
        this.username = request.getUsername();
        this.request = request;
    }

    @NonNull
    public ByteArray getRequestId() {
        return this.requestId;
    }

    @NonNull
    public PublicKeyCredentialRequestOptions getPublicKeyCredentialRequestOptions() {
        return this.publicKeyCredentialRequestOptions;
    }

    @NonNull
    public Optional<String> getUsername() {
        return this.username;
    }

    @NonNull
    public AssertionRequest getRequest() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionRequestWrapper)) {
            return false;
        }
        AssertionRequestWrapper other = (AssertionRequestWrapper)o;
        ByteArray this$requestId = this.getRequestId();
        ByteArray other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        PublicKeyCredentialRequestOptions this$publicKeyCredentialRequestOptions = this.getPublicKeyCredentialRequestOptions();
        PublicKeyCredentialRequestOptions other$publicKeyCredentialRequestOptions = other.getPublicKeyCredentialRequestOptions();
        if (this$publicKeyCredentialRequestOptions == null ? other$publicKeyCredentialRequestOptions != null : !this$publicKeyCredentialRequestOptions.equals(other$publicKeyCredentialRequestOptions)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !((Object)this$username).equals(other$username));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        PublicKeyCredentialRequestOptions $publicKeyCredentialRequestOptions = this.getPublicKeyCredentialRequestOptions();
        result = result * 59 + ($publicKeyCredentialRequestOptions == null ? 43 : $publicKeyCredentialRequestOptions.hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        return result;
    }

    public String toString() {
        return "AssertionRequestWrapper(requestId=" + this.getRequestId() + ", publicKeyCredentialRequestOptions=" + this.getPublicKeyCredentialRequestOptions() + ", username=" + this.getUsername() + ", request=" + this.getRequest() + ")";
    }
}

