/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yubico.core.SessionManager;
import com.yubico.webauthn.data.ByteArray;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class DefaultSessionManager
implements SessionManager {
    private Cache<ByteArray, ByteArray> sessionIdsToUsers = DefaultSessionManager.newCache();
    private Cache<ByteArray, ByteArray> usersToSessionIds = DefaultSessionManager.newCache();

    private static <K, V> Cache<K, V> newCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Override
    public ByteArray createSession(@NonNull ByteArray userHandle) throws ExecutionException {
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        ByteArray sessionId = (ByteArray)this.usersToSessionIds.get((Object)userHandle, () -> SessionManager.generateRandom(32));
        this.sessionIdsToUsers.put((Object)sessionId, (Object)userHandle);
        return sessionId;
    }

    @Override
    public Optional<ByteArray> getSession(@NonNull ByteArray token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return Optional.ofNullable((ByteArray)this.sessionIdsToUsers.getIfPresent((Object)token));
    }
}

