/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.yubico.webauthn.data.ByteArray;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;

public interface SessionManager {
    public static ByteArray generateRandom(int length) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return new ByteArray(bytes);
    }

    public ByteArray createSession(@NonNull ByteArray var1) throws ExecutionException;

    public Optional<ByteArray> getSession(@NonNull ByteArray var1);

    default public boolean isSessionForUser(@NonNull ByteArray claimedUserHandle, @NonNull ByteArray token) {
        if (claimedUserHandle == null) {
            throw new NullPointerException("claimedUserHandle is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        Objects.requireNonNull(claimedUserHandle);
        return this.getSession(token).map(arg_0 -> ((ByteArray)claimedUserHandle).equals(arg_0)).orElse(false);
    }

    default public boolean isSessionForUser(@NonNull ByteArray claimedUserHandle, @NonNull Optional<ByteArray> token) {
        if (claimedUserHandle == null) {
            throw new NullPointerException("claimedUserHandle is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return token.map(t -> this.isSessionForUser(claimedUserHandle, (ByteArray)t)).orElse(false);
    }
}

