/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.data;

import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.data.UserIdentity;
import java.time.Instant;
import java.util.Optional;

public final class CredentialRegistration {
    private final long signatureCount;
    private final UserIdentity userIdentity;
    private final Optional<String> credentialNickname;
    private final Instant registrationTime;
    private final RegisteredCredential credential;
    private final Optional<Attestation> attestationMetadata;

    public String getUsername() {
        return this.userIdentity.getName();
    }

    CredentialRegistration(long signatureCount, UserIdentity userIdentity, Optional<String> credentialNickname, Instant registrationTime, RegisteredCredential credential, Optional<Attestation> attestationMetadata) {
        this.signatureCount = signatureCount;
        this.userIdentity = userIdentity;
        this.credentialNickname = credentialNickname;
        this.registrationTime = registrationTime;
        this.credential = credential;
        this.attestationMetadata = attestationMetadata;
    }

    public static CredentialRegistrationBuilder builder() {
        return new CredentialRegistrationBuilder();
    }

    public long getSignatureCount() {
        return this.signatureCount;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public Optional<String> getCredentialNickname() {
        return this.credentialNickname;
    }

    public Instant getRegistrationTime() {
        return this.registrationTime;
    }

    public RegisteredCredential getCredential() {
        return this.credential;
    }

    public Optional<Attestation> getAttestationMetadata() {
        return this.attestationMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialRegistration)) {
            return false;
        }
        CredentialRegistration other = (CredentialRegistration)o;
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        UserIdentity this$userIdentity = this.getUserIdentity();
        UserIdentity other$userIdentity = other.getUserIdentity();
        if (this$userIdentity == null ? other$userIdentity != null : !this$userIdentity.equals(other$userIdentity)) {
            return false;
        }
        Optional<String> this$credentialNickname = this.getCredentialNickname();
        Optional<String> other$credentialNickname = other.getCredentialNickname();
        if (this$credentialNickname == null ? other$credentialNickname != null : !((Object)this$credentialNickname).equals(other$credentialNickname)) {
            return false;
        }
        Instant this$registrationTime = this.getRegistrationTime();
        Instant other$registrationTime = other.getRegistrationTime();
        if (this$registrationTime == null ? other$registrationTime != null : !((Object)this$registrationTime).equals(other$registrationTime)) {
            return false;
        }
        RegisteredCredential this$credential = this.getCredential();
        RegisteredCredential other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
            return false;
        }
        Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
        Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
        return !(this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        UserIdentity $userIdentity = this.getUserIdentity();
        result = result * 59 + ($userIdentity == null ? 43 : $userIdentity.hashCode());
        Optional<String> $credentialNickname = this.getCredentialNickname();
        result = result * 59 + ($credentialNickname == null ? 43 : ((Object)$credentialNickname).hashCode());
        Instant $registrationTime = this.getRegistrationTime();
        result = result * 59 + ($registrationTime == null ? 43 : ((Object)$registrationTime).hashCode());
        RegisteredCredential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
        Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
        result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "CredentialRegistration(signatureCount=" + this.getSignatureCount() + ", userIdentity=" + this.getUserIdentity() + ", credentialNickname=" + this.getCredentialNickname() + ", registrationTime=" + this.getRegistrationTime() + ", credential=" + this.getCredential() + ", attestationMetadata=" + this.getAttestationMetadata() + ")";
    }

    public CredentialRegistration withSignatureCount(long signatureCount) {
        return this.signatureCount == signatureCount ? this : new CredentialRegistration(signatureCount, this.userIdentity, this.credentialNickname, this.registrationTime, this.credential, this.attestationMetadata);
    }

    public CredentialRegistration withUserIdentity(UserIdentity userIdentity) {
        return this.userIdentity == userIdentity ? this : new CredentialRegistration(this.signatureCount, userIdentity, this.credentialNickname, this.registrationTime, this.credential, this.attestationMetadata);
    }

    public CredentialRegistration withCredentialNickname(Optional<String> credentialNickname) {
        return this.credentialNickname == credentialNickname ? this : new CredentialRegistration(this.signatureCount, this.userIdentity, credentialNickname, this.registrationTime, this.credential, this.attestationMetadata);
    }

    public CredentialRegistration withRegistrationTime(Instant registrationTime) {
        return this.registrationTime == registrationTime ? this : new CredentialRegistration(this.signatureCount, this.userIdentity, this.credentialNickname, registrationTime, this.credential, this.attestationMetadata);
    }

    public CredentialRegistration withCredential(RegisteredCredential credential) {
        return this.credential == credential ? this : new CredentialRegistration(this.signatureCount, this.userIdentity, this.credentialNickname, this.registrationTime, credential, this.attestationMetadata);
    }

    public CredentialRegistration withAttestationMetadata(Optional<Attestation> attestationMetadata) {
        return this.attestationMetadata == attestationMetadata ? this : new CredentialRegistration(this.signatureCount, this.userIdentity, this.credentialNickname, this.registrationTime, this.credential, attestationMetadata);
    }

    public static class CredentialRegistrationBuilder {
        private long signatureCount;
        private UserIdentity userIdentity;
        private Optional<String> credentialNickname;
        private Instant registrationTime;
        private RegisteredCredential credential;
        private Optional<Attestation> attestationMetadata;

        CredentialRegistrationBuilder() {
        }

        public CredentialRegistrationBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        public CredentialRegistrationBuilder userIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public CredentialRegistrationBuilder credentialNickname(Optional<String> credentialNickname) {
            this.credentialNickname = credentialNickname;
            return this;
        }

        public CredentialRegistrationBuilder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        public CredentialRegistrationBuilder credential(RegisteredCredential credential) {
            this.credential = credential;
            return this;
        }

        public CredentialRegistrationBuilder attestationMetadata(Optional<Attestation> attestationMetadata) {
            this.attestationMetadata = attestationMetadata;
            return this;
        }

        public CredentialRegistration build() {
            return new CredentialRegistration(this.signatureCount, this.userIdentity, this.credentialNickname, this.registrationTime, this.credential, this.attestationMetadata);
        }

        public String toString() {
            return "CredentialRegistration.CredentialRegistrationBuilder(signatureCount=" + this.signatureCount + ", userIdentity=" + this.userIdentity + ", credentialNickname=" + this.credentialNickname + ", registrationTime=" + this.registrationTime + ", credential=" + this.credential + ", attestationMetadata=" + this.attestationMetadata + ")";
        }
    }
}

