/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.ByteArray;
import lombok.NonNull;

public final class U2fCredentialResponse {
    private final ByteArray keyHandle;
    private final ByteArray publicKey;
    private final ByteArray attestationCertAndSignature;
    private final ByteArray clientDataJSON;

    @JsonCreator
    public U2fCredentialResponse(@JsonProperty(value="keyHandle") @NonNull ByteArray keyHandle, @JsonProperty(value="publicKey") @NonNull ByteArray publicKey, @JsonProperty(value="attestationCertAndSignature") @NonNull ByteArray attestationCertAndSignature, @JsonProperty(value="clientDataJSON") @NonNull ByteArray clientDataJSON) {
        if (keyHandle == null) {
            throw new NullPointerException("keyHandle is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (attestationCertAndSignature == null) {
            throw new NullPointerException("attestationCertAndSignature is marked non-null but is null");
        }
        if (clientDataJSON == null) {
            throw new NullPointerException("clientDataJSON is marked non-null but is null");
        }
        this.keyHandle = keyHandle;
        this.publicKey = publicKey;
        this.attestationCertAndSignature = attestationCertAndSignature;
        this.clientDataJSON = clientDataJSON;
    }

    public ByteArray getKeyHandle() {
        return this.keyHandle;
    }

    public ByteArray getPublicKey() {
        return this.publicKey;
    }

    public ByteArray getAttestationCertAndSignature() {
        return this.attestationCertAndSignature;
    }

    public ByteArray getClientDataJSON() {
        return this.clientDataJSON;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof U2fCredentialResponse)) {
            return false;
        }
        U2fCredentialResponse other = (U2fCredentialResponse)o;
        ByteArray this$keyHandle = this.getKeyHandle();
        ByteArray other$keyHandle = other.getKeyHandle();
        if (this$keyHandle == null ? other$keyHandle != null : !this$keyHandle.equals(other$keyHandle)) {
            return false;
        }
        ByteArray this$publicKey = this.getPublicKey();
        ByteArray other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        ByteArray this$attestationCertAndSignature = this.getAttestationCertAndSignature();
        ByteArray other$attestationCertAndSignature = other.getAttestationCertAndSignature();
        if (this$attestationCertAndSignature == null ? other$attestationCertAndSignature != null : !this$attestationCertAndSignature.equals(other$attestationCertAndSignature)) {
            return false;
        }
        ByteArray this$clientDataJSON = this.getClientDataJSON();
        ByteArray other$clientDataJSON = other.getClientDataJSON();
        return !(this$clientDataJSON == null ? other$clientDataJSON != null : !this$clientDataJSON.equals(other$clientDataJSON));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteArray $keyHandle = this.getKeyHandle();
        result = result * 59 + ($keyHandle == null ? 43 : $keyHandle.hashCode());
        ByteArray $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        ByteArray $attestationCertAndSignature = this.getAttestationCertAndSignature();
        result = result * 59 + ($attestationCertAndSignature == null ? 43 : $attestationCertAndSignature.hashCode());
        ByteArray $clientDataJSON = this.getClientDataJSON();
        result = result * 59 + ($clientDataJSON == null ? 43 : $clientDataJSON.hashCode());
        return result;
    }

    public String toString() {
        return "U2fCredentialResponse(keyHandle=" + this.getKeyHandle() + ", publicKey=" + this.getPublicKey() + ", attestationCertAndSignature=" + this.getAttestationCertAndSignature() + ", clientDataJSON=" + this.getClientDataJSON() + ")";
    }
}

