/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.data;

import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class U2fRegistrationResult {
    @NonNull
    private final PublicKeyCredentialDescriptor keyId;
    private final boolean attestationTrusted;
    @NonNull
    private final ByteArray publicKeyCose;
    @NonNull
    private final List<String> warnings;
    @NonNull
    private final Optional<Attestation> attestationMetadata;

    private static List<String> $default$warnings() {
        return Collections.emptyList();
    }

    private static Optional<Attestation> $default$attestationMetadata() {
        return Optional.empty();
    }

    U2fRegistrationResult(@NonNull PublicKeyCredentialDescriptor keyId, boolean attestationTrusted, @NonNull ByteArray publicKeyCose, @NonNull List<String> warnings, @NonNull Optional<Attestation> attestationMetadata) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        if (warnings == null) {
            throw new NullPointerException("warnings is marked non-null but is null");
        }
        if (attestationMetadata == null) {
            throw new NullPointerException("attestationMetadata is marked non-null but is null");
        }
        this.keyId = keyId;
        this.attestationTrusted = attestationTrusted;
        this.publicKeyCose = publicKeyCose;
        this.warnings = warnings;
        this.attestationMetadata = attestationMetadata;
    }

    public static U2fRegistrationResultBuilder builder() {
        return new U2fRegistrationResultBuilder();
    }

    @NonNull
    public PublicKeyCredentialDescriptor getKeyId() {
        return this.keyId;
    }

    public boolean isAttestationTrusted() {
        return this.attestationTrusted;
    }

    @NonNull
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    @NonNull
    public List<String> getWarnings() {
        return this.warnings;
    }

    @NonNull
    public Optional<Attestation> getAttestationMetadata() {
        return this.attestationMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof U2fRegistrationResult)) {
            return false;
        }
        U2fRegistrationResult other = (U2fRegistrationResult)o;
        if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
            return false;
        }
        PublicKeyCredentialDescriptor this$keyId = this.getKeyId();
        PublicKeyCredentialDescriptor other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        if (this$publicKeyCose == null ? other$publicKeyCose != null : !this$publicKeyCose.equals(other$publicKeyCose)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
        Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
        return !(this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
        PublicKeyCredentialDescriptor $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : $publicKeyCose.hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
        result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "U2fRegistrationResult(keyId=" + this.getKeyId() + ", attestationTrusted=" + this.isAttestationTrusted() + ", publicKeyCose=" + this.getPublicKeyCose() + ", warnings=" + this.getWarnings() + ", attestationMetadata=" + this.getAttestationMetadata() + ")";
    }

    public static class U2fRegistrationResultBuilder {
        private PublicKeyCredentialDescriptor keyId;
        private boolean attestationTrusted;
        private ByteArray publicKeyCose;
        private boolean warnings$set;
        private List<String> warnings$value;
        private boolean attestationMetadata$set;
        private Optional<Attestation> attestationMetadata$value;

        U2fRegistrationResultBuilder() {
        }

        public U2fRegistrationResultBuilder keyId(@NonNull PublicKeyCredentialDescriptor keyId) {
            if (keyId == null) {
                throw new NullPointerException("keyId is marked non-null but is null");
            }
            this.keyId = keyId;
            return this;
        }

        public U2fRegistrationResultBuilder attestationTrusted(boolean attestationTrusted) {
            this.attestationTrusted = attestationTrusted;
            return this;
        }

        public U2fRegistrationResultBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        public U2fRegistrationResultBuilder warnings(@NonNull List<String> warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings is marked non-null but is null");
            }
            this.warnings$value = warnings;
            this.warnings$set = true;
            return this;
        }

        public U2fRegistrationResultBuilder attestationMetadata(@NonNull Optional<Attestation> attestationMetadata) {
            if (attestationMetadata == null) {
                throw new NullPointerException("attestationMetadata is marked non-null but is null");
            }
            this.attestationMetadata$value = attestationMetadata;
            this.attestationMetadata$set = true;
            return this;
        }

        public U2fRegistrationResult build() {
            List<String> warnings$value = this.warnings$value;
            if (!this.warnings$set) {
                warnings$value = U2fRegistrationResult.$default$warnings();
            }
            Optional<Attestation> attestationMetadata$value = this.attestationMetadata$value;
            if (!this.attestationMetadata$set) {
                attestationMetadata$value = U2fRegistrationResult.$default$attestationMetadata();
            }
            return new U2fRegistrationResult(this.keyId, this.attestationTrusted, this.publicKeyCose, warnings$value, attestationMetadata$value);
        }

        public String toString() {
            return "U2fRegistrationResult.U2fRegistrationResultBuilder(keyId=" + this.keyId + ", attestationTrusted=" + this.attestationTrusted + ", publicKeyCose=" + this.publicKeyCose + ", warnings$value=" + this.warnings$value + ", attestationMetadata$value=" + this.attestationMetadata$value + ")";
        }
    }
}

