/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.util;

import java.util.Optional;
import java.util.function.Function;

public final class Either<L, R> {
    private final boolean isRight;
    private final L leftValue;
    private final R rightValue;

    private Either(R rightValue) {
        this.isRight = true;
        this.leftValue = null;
        this.rightValue = rightValue;
    }

    private Either(boolean dummy, L leftValue) {
        this.isRight = false;
        this.leftValue = leftValue;
        this.rightValue = null;
    }

    public final boolean isLeft() {
        return !this.isRight();
    }

    public final boolean isRight() {
        return this.isRight;
    }

    public final Optional<L> left() {
        if (this.isLeft()) {
            return Optional.of(this.leftValue);
        }
        throw new IllegalStateException("Cannot call left() on a right value.");
    }

    public final Optional<R> right() {
        if (this.isRight()) {
            return Optional.of(this.rightValue);
        }
        throw new IllegalStateException("Cannot call right() on a left value.");
    }

    public final <RO> Either<L, RO> map(Function<R, RO> func) {
        return this.flatMap(r -> Either.right(func.apply(r)));
    }

    public final <RO> Either<L, RO> flatMap(Function<R, Either<L, RO>> func) {
        if (this.isRight()) {
            return func.apply(this.rightValue);
        }
        return Either.left(this.leftValue);
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Either<L, R>(false, value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either<L, R>(value);
    }
}

