/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.databind.JsonNode;
import com.yubico.data.RegistrationRequest;
import com.yubico.data.U2fRegistrationResponse;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.U2fRawRegisterResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.extension.appid.AppId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class U2fVerifier {
    public static boolean verify(AppId appId, RegistrationRequest request, U2fRegistrationResponse response) throws CertificateException, IOException, Base64UrlException {
        ByteArray appIdHash = Crypto.sha256((String)appId.getId());
        ByteArray clientDataHash = Crypto.sha256((ByteArray)response.getCredential().getU2fResponse().getClientDataJSON());
        JsonNode clientData = JacksonCodecs.json().readTree(response.getCredential().getU2fResponse().getClientDataJSON().getBytes());
        String challengeBase64 = clientData.get("challenge").textValue();
        ExceptionUtil.assure((boolean)request.getPublicKeyCredentialCreationOptions().getChallenge().equals((Object)ByteArray.fromBase64Url((String)challengeBase64)), (String)"Wrong challenge.", (Object[])new Object[0]);
        ByteArrayInputStream attestationCertAndSignatureStream = new ByteArrayInputStream(response.getCredential().getU2fResponse().getAttestationCertAndSignature().getBytes());
        X509Certificate attestationCert = CertificateParser.parseDer((InputStream)attestationCertAndSignatureStream);
        byte[] signatureBytes = new byte[((InputStream)attestationCertAndSignatureStream).available()];
        attestationCertAndSignatureStream.read(signatureBytes);
        ByteArray signature = new ByteArray(signatureBytes);
        return new U2fRawRegisterResponse(response.getCredential().getU2fResponse().getPublicKey(), response.getCredential().getU2fResponse().getKeyHandle(), attestationCert, signature).verifySignature(appIdHash, clientDataHash);
    }
}

