/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TicketGrantingTicketCheckAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketCheckAction.class);
    private final CentralAuthenticationService centralAuthenticationService;

    public Event doExecute(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            return new Event((Object)this, "notExists");
        }
        try {
            Ticket ticket = this.centralAuthenticationService.getTicket(tgtId, Ticket.class);
            if (ticket != null && !ticket.isExpired()) {
                return new Event((Object)this, "valid");
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.trace("Could not retrieve ticket id [{}] from registry.", (Object)e.getMessage());
        }
        return new Event((Object)this, "invalid");
    }

    @Generated
    public TicketGrantingTicketCheckAction(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

