/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public class InitializeLoginAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializeLoginAction.class);
    protected final ServicesManager servicesManager;
    protected final CasConfigurationProperties casProperties;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        LOGGER.trace("Initialized login sequence");
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        if (service == null && !this.casProperties.getSso().isAllowMissingServiceParameter()) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            LOGGER.warn("No service authentication request is available at [{}]. CAS is configured to disable the flow.", (Object)request.getRequestURL());
            throw new NoSuchFlowExecutionException(requestContext.getFlowExecutionContext().getKey(), (Exception)new UnauthorizedServiceException("screen.service.required.message", "Service is required"));
        }
        return this.success();
    }

    protected static boolean isLoginFlowActive(RequestContext requestContext) {
        return requestContext.getActiveFlow().getId().equalsIgnoreCase("login");
    }

    @Generated
    public InitializeLoginAction(ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
    }
}

