/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ConfirmLogoutAction
extends AbstractAction {
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final CasCookieBuilder ticketGrantingTicketCookieGenerator;

    public Event doExecute(RequestContext requestContext) {
        String tgtId = this.getTicketGrantingTicket(requestContext);
        if (StringUtils.isNotBlank((CharSequence)tgtId)) {
            TicketGrantingTicket ticket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(tgtId, TicketGrantingTicket.class);
            WebUtils.putAuthentication((Authentication)ticket.getAuthentication(), (RequestContext)requestContext);
            WebUtils.putTicketGrantingTicket((RequestContext)requestContext, (TicketGrantingTicket)ticket);
        }
        return this.success();
    }

    private String getTicketGrantingTicket(RequestContext context) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            return this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        return tgtId;
    }

    @Generated
    public ConfirmLogoutAction(CentralAuthenticationService centralAuthenticationService, CasCookieBuilder ticketGrantingTicketCookieGenerator) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }
}

