/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FinishLogoutAction
extends AbstractLogoutAction {
    @Override
    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) {
        String logoutRedirect = (String)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class);
        if (StringUtils.isNotBlank((CharSequence)logoutRedirect)) {
            return new EventFactorySupport().event((Object)this, "redirect");
        }
        String logoutPostUrl = WebUtils.getLogoutPostUrl((RequestContext)context);
        Map logoutPostData = WebUtils.getLogoutPostData((RequestContext)context);
        if (StringUtils.isNotBlank((CharSequence)logoutPostUrl) && logoutPostData != null) {
            MutableAttributeMap flowScope = context.getFlowScope();
            flowScope.put("originalUrl", (Object)logoutPostUrl);
            flowScope.put("parameters", (Object)logoutPostData);
            return new EventFactorySupport().event((Object)this, "post");
        }
        return new EventFactorySupport().event((Object)this, "finish");
    }
}

