/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.FlowExecutionExceptionResolver;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.GatewayServicesManagementCheckAction;
import org.apereo.cas.web.flow.GenerateServiceTicketAction;
import org.apereo.cas.web.flow.ServiceAuthorizationCheckAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.InitialAuthenticationAction;
import org.apereo.cas.web.flow.login.CreateTicketGrantingTicketAction;
import org.apereo.cas.web.flow.login.GenericSuccessViewAction;
import org.apereo.cas.web.flow.login.InitialAuthenticationRequestValidationAction;
import org.apereo.cas.web.flow.login.InitialFlowSetupAction;
import org.apereo.cas.web.flow.login.InitializeLoginAction;
import org.apereo.cas.web.flow.login.RedirectUnauthorizedServiceUrlAction;
import org.apereo.cas.web.flow.login.RenderLoginAction;
import org.apereo.cas.web.flow.login.SendTicketGrantingTicketAction;
import org.apereo.cas.web.flow.login.ServiceWarningAction;
import org.apereo.cas.web.flow.login.SetServiceUnauthorizedRedirectUrlAction;
import org.apereo.cas.web.flow.login.TicketGrantingTicketCheckAction;
import org.apereo.cas.web.flow.login.VerifyRequiredServiceAction;
import org.apereo.cas.web.flow.logout.ConfirmLogoutAction;
import org.apereo.cas.web.flow.logout.FinishLogoutAction;
import org.apereo.cas.web.flow.logout.FrontChannelLogoutAction;
import org.apereo.cas.web.flow.logout.LogoutAction;
import org.apereo.cas.web.flow.logout.LogoutViewSetupAction;
import org.apereo.cas.web.flow.logout.TerminateSessionAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.webflow.execution.Action;

@Configuration(value="casSupportActionsConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class CasSupportActionsConfiguration {
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="logoutManager")
    private ObjectProvider<LogoutManager> logoutManager;
    @Autowired
    @Qualifier(value="authenticationEventExecutionPlan")
    private ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CasCookieBuilder> warnCookieGenerator;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private ObjectProvider<AdaptiveAuthenticationPolicy> adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="rankedAuthenticationProviderWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> rankedAuthenticationProviderWebflowEventResolver;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="singleSignOnParticipationStrategy")
    private ObjectProvider<SingleSignOnParticipationStrategy> webflowSingleSignOnParticipationStrategy;
    @Autowired
    @Qualifier(value="principalElectionStrategy")
    private ObjectProvider<PrincipalElectionStrategy> principalElectionStrategy;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    @Qualifier(value="logoutExecutionPlan")
    private ObjectProvider<LogoutExecutionPlan> logoutExecutionPlan;

    @Bean
    @RefreshScope
    public HandlerExceptionResolver errorHandlerResolver() {
        return new FlowExecutionExceptionResolver();
    }

    @ConditionalOnMissingBean(name={"authenticationViaFormAction"})
    @Bean
    @RefreshScope
    public Action authenticationViaFormAction() {
        return new InitialAuthenticationAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getObject(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getObject());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"serviceAuthorizationCheck"})
    @Bean
    public Action serviceAuthorizationCheck() {
        return new ServiceAuthorizationCheckAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"sendTicketGrantingTicketAction"})
    @Bean
    public Action sendTicketGrantingTicketAction() {
        return new SendTicketGrantingTicketAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (SingleSignOnParticipationStrategy)this.webflowSingleSignOnParticipationStrategy.getObject());
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"createTicketGrantingTicketAction"})
    @Bean
    public Action createTicketGrantingTicketAction() {
        return new CreateTicketGrantingTicketAction((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject());
    }

    @ConditionalOnMissingBean(name={"finishLogoutAction"})
    @Bean
    @RefreshScope
    public Action finishLogoutAction() {
        return new FinishLogoutAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), (ServicesManager)this.servicesManager.getObject(), (LogoutExecutionPlan)this.logoutExecutionPlan.getObject(), this.casProperties);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"logoutAction"})
    public Action logoutAction() {
        return new LogoutAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), (ServicesManager)this.servicesManager.getObject(), (LogoutExecutionPlan)this.logoutExecutionPlan.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"initializeLoginAction"})
    @Bean
    @RefreshScope
    public Action initializeLoginAction() {
        return new InitializeLoginAction((ServicesManager)this.servicesManager.getObject(), this.casProperties);
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"setServiceUnauthorizedRedirectUrlAction"})
    @Bean
    public Action setServiceUnauthorizedRedirectUrlAction() {
        return new SetServiceUnauthorizedRedirectUrlAction((ServicesManager)this.servicesManager.getObject());
    }

    @ConditionalOnMissingBean(name={"renderLoginFormAction"})
    @Bean
    @RefreshScope
    public Action renderLoginFormAction() {
        return new RenderLoginAction((ServicesManager)this.servicesManager.getObject(), this.casProperties, (ApplicationContext)this.applicationContext);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"initialFlowSetupAction"})
    public Action initialFlowSetupAction() {
        return new InitialFlowSetupAction(CollectionUtils.wrap((Object)((ArgumentExtractor)this.argumentExtractor.getObject())), (ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (CasCookieBuilder)this.warnCookieGenerator.getObject(), this.casProperties, (AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject(), (SingleSignOnParticipationStrategy)this.webflowSingleSignOnParticipationStrategy.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"verifyRequiredServiceAction"})
    public Action verifyRequiredServiceAction() {
        return new VerifyRequiredServiceAction((ServicesManager)this.servicesManager.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), this.casProperties, (TicketRegistrySupport)this.ticketRegistrySupport.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"initialAuthenticationRequestValidationAction"})
    public Action initialAuthenticationRequestValidationAction() {
        return new InitialAuthenticationRequestValidationAction((CasWebflowEventResolver)this.rankedAuthenticationProviderWebflowEventResolver.getObject());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"genericSuccessViewAction"})
    public Action genericSuccessViewAction() {
        return new GenericSuccessViewAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (ServicesManager)this.servicesManager.getObject(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getObject()), this.casProperties);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"redirectUnauthorizedServiceUrlAction"})
    public Action redirectUnauthorizedServiceUrlAction() {
        return new RedirectUnauthorizedServiceUrlAction((ServicesManager)this.servicesManager.getObject(), (ApplicationContext)this.applicationContext);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"generateServiceTicketAction"})
    public Action generateServiceTicketAction() {
        return new GenerateServiceTicketAction((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), (CentralAuthenticationService)this.centralAuthenticationService.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), (ServicesManager)this.servicesManager.getObject(), (PrincipalElectionStrategy)this.principalElectionStrategy.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"gatewayServicesManagementCheck"})
    @RefreshScope
    public Action gatewayServicesManagementCheck() {
        return new GatewayServicesManagementCheckAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"frontChannelLogoutAction"})
    public Action frontChannelLogoutAction() {
        return new FrontChannelLogoutAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), (ServicesManager)this.servicesManager.getObject(), (LogoutExecutionPlan)this.logoutExecutionPlan.getObject(), this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"ticketGrantingTicketCheckAction"})
    public Action ticketGrantingTicketCheckAction() {
        return new TicketGrantingTicketCheckAction((CentralAuthenticationService)this.centralAuthenticationService.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"terminateSessionAction"})
    @RefreshScope
    public Action terminateSessionAction() {
        return new TerminateSessionAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (CasCookieBuilder)this.warnCookieGenerator.getObject(), this.casProperties.getLogout(), (LogoutManager)this.logoutManager.getObject(), this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"confirmLogoutAction"})
    @RefreshScope
    public Action confirmLogoutAction() {
        return new ConfirmLogoutAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), (ServicesManager)this.servicesManager.getObject(), (LogoutExecutionPlan)this.logoutExecutionPlan.getObject(), this.casProperties);
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"logoutViewSetupAction"})
    public Action logoutViewSetupAction() {
        return new LogoutViewSetupAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (CasCookieBuilder)this.ticketGrantingTicketCookieGenerator.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), (ServicesManager)this.servicesManager.getObject(), (LogoutExecutionPlan)this.logoutExecutionPlan.getObject(), this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceWarningAction"})
    @RefreshScope
    public Action serviceWarningAction() {
        return new ServiceWarningAction((CentralAuthenticationService)this.centralAuthenticationService.getObject(), (AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), (CasCookieBuilder)this.warnCookieGenerator.getObject(), (PrincipalElectionStrategy)this.principalElectionStrategy.getObject());
    }
}

