/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.flow.WebflowLoginDecoratorProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.decorator.GroovyLoginWebflowDecorator;
import org.apereo.cas.web.flow.decorator.RestfulLoginWebflowDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RenderLoginAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderLoginAction.class);
    protected final ServicesManager servicesManager;
    protected final CasConfigurationProperties casProperties;
    protected final ApplicationContext applicationContext;

    protected Event doExecute(RequestContext requestContext) {
        WebflowLoginDecoratorProperties decorator = this.casProperties.getWebflow().getLoginDecorator();
        Resource groovyScript = decorator.getGroovy().getLocation();
        if (groovyScript != null) {
            LOGGER.trace("Decorating login webflow using [{}]", (Object)groovyScript);
            GroovyLoginWebflowDecorator groovy = new GroovyLoginWebflowDecorator(groovyScript);
            groovy.decorate(requestContext, this.applicationContext);
            return null;
        }
        String url = decorator.getRest().getUrl();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            LOGGER.trace("Decorating login webflow REST endpoint [{}]", (Object)url);
            RestfulLoginWebflowDecorator rest = new RestfulLoginWebflowDecorator(decorator.getRest());
            rest.decorate(requestContext, this.applicationContext);
            return null;
        }
        return null;
    }

    @Generated
    public RenderLoginAction(ServicesManager servicesManager, CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
    }
}

