/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractLogoutAction
extends AbstractAction {
    private static final String NO_CACHE = "no-cache";
    private static final String CACHE_CONTROL = "Cache-Control";
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    protected final ArgumentExtractor argumentExtractor;
    protected final ServicesManager servicesManager;
    protected final LogoutExecutionPlan logoutExecutionPlan;
    protected final CasConfigurationProperties casProperties;

    public Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        this.preventCaching(response);
        Optional.ofNullable(this.argumentExtractor.extractService(request)).filter(service -> {
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            return registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed();
        }).ifPresent(service -> WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service));
        return this.doInternalExecute(request, response, context);
    }

    protected abstract Event doInternalExecute(HttpServletRequest var1, HttpServletResponse var2, RequestContext var3);

    protected void preventCaching(HttpServletResponse response) {
        response.setHeader("Pragma", NO_CACHE);
        response.setDateHeader("Expires", 1L);
        response.setHeader(CACHE_CONTROL, NO_CACHE);
        response.addHeader(CACHE_CONTROL, "no-store");
    }

    @Generated
    public AbstractLogoutAction(CentralAuthenticationService centralAuthenticationService, CasCookieBuilder ticketGrantingTicketCookieGenerator, ArgumentExtractor argumentExtractor, ServicesManager servicesManager, LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.argumentExtractor = argumentExtractor;
        this.servicesManager = servicesManager;
        this.logoutExecutionPlan = logoutExecutionPlan;
        this.casProperties = casProperties;
    }
}

