/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutHttpMessage;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FrontChannelLogoutAction
extends AbstractLogoutAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontChannelLogoutAction.class);

    public FrontChannelLogoutAction(CentralAuthenticationService centralAuthenticationService, CasCookieBuilder ticketGrantingTicketCookieGenerator, ArgumentExtractor argumentExtractor, ServicesManager servicesManager, LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
        super(centralAuthenticationService, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
    }

    @Override
    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) {
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)context);
        if (logoutRequests == null || logoutRequests.isEmpty()) {
            return this.getFinishLogoutEvent();
        }
        if (this.casProperties.getSlo().isDisabled()) {
            LOGGER.debug("Single logout callbacks are disabled");
            return this.getFinishLogoutEvent();
        }
        HashMap logoutUrls = new HashMap();
        logoutRequests.stream().filter(r -> r.getStatus() == LogoutRequestStatus.NOT_ATTEMPTED).forEach(r -> {
            LOGGER.debug("Using logout url [{}] for front-channel logout requests", (Object)r.getLogoutUrl().toExternalForm());
            this.logoutExecutionPlan.getSingleLogoutServiceMessageHandlers().stream().sorted(Comparator.comparing(SingleLogoutServiceMessageHandler::getOrder)).filter(handler -> handler.supports(r.getExecutionRequest(), r.getService())).forEach(handler -> {
                SingleLogoutMessage logoutMessage = handler.createSingleLogoutMessage(r);
                LOGGER.debug("Front-channel logout message to send to [{}] is [{}]", (Object)r.getLogoutUrl(), (Object)logoutMessage);
                LogoutHttpMessage msg = new LogoutHttpMessage(r.getLogoutUrl(), logoutMessage.getPayload(), true);
                logoutUrls.put(r, msg);
                r.setStatus(LogoutRequestStatus.SUCCESS);
                r.getService().setLoggedOutAlready(true);
            });
        });
        if (!logoutUrls.isEmpty()) {
            WebUtils.putLogoutUrls((RequestContext)context, logoutUrls);
            return new EventFactorySupport().event((Object)this, "propagate");
        }
        return this.getFinishLogoutEvent();
    }

    private Event getFinishLogoutEvent() {
        return new EventFactorySupport().event((Object)this, "finish");
    }
}

