/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TerminateSessionAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateSessionAction.class);
    public static final String REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED = "LogoutRequestConfirmed";
    protected final EventFactorySupport eventFactorySupport = new EventFactorySupport();
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    protected final CasCookieBuilder warnCookieGenerator;
    protected final LogoutProperties logoutProperties;
    protected final LogoutManager logoutManager;
    protected final ConfigurableApplicationContext applicationContext;

    public Event doExecute(RequestContext requestContext) {
        Boolean terminateSession = (Boolean)FunctionUtils.doIf((boolean)this.logoutProperties.isConfirmLogout(), () -> TerminateSessionAction.isLogoutRequestConfirmed(requestContext), () -> Boolean.TRUE).get();
        if (terminateSession.booleanValue()) {
            return this.terminate(requestContext);
        }
        return this.eventFactorySupport.event((Object)this, "warn");
    }

    protected String getTicketGrantingTicket(RequestContext context) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            return this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        return tgtId;
    }

    protected Event terminate(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        String tgtId = this.getTicketGrantingTicket(context);
        if (StringUtils.isNotBlank((CharSequence)tgtId)) {
            LOGGER.trace("Destroying SSO session linked to ticket-granting ticket [{}]", (Object)tgtId);
            List<SingleLogoutRequestContext> logoutRequests = this.initiateSingleLogout(tgtId, request, response);
            WebUtils.putLogoutRequests((RequestContext)context, logoutRequests);
        }
        LOGGER.trace("Removing CAS cookies");
        this.ticketGrantingTicketCookieGenerator.removeCookie(response);
        this.warnCookieGenerator.removeCookie(response);
        TerminateSessionAction.destroyApplicationSession(request, response);
        LOGGER.debug("Terminated all CAS sessions successfully.");
        if (StringUtils.isNotBlank((CharSequence)this.logoutProperties.getRedirectUrl())) {
            WebUtils.putLogoutRedirectUrl((RequestContext)context, (String)this.logoutProperties.getRedirectUrl());
            return this.eventFactorySupport.event((Object)this, "redirect");
        }
        return this.eventFactorySupport.success((Object)this);
    }

    protected static boolean isLogoutRequestConfirmed(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        return request.getParameterMap().containsKey(REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED);
    }

    protected static void destroyApplicationSession(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.trace("Destroying application session");
        JEEContext context = new JEEContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        manager.removeProfiles();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Object requestedUrl = session.getAttribute("pac4jRequestedUrl");
            session.invalidate();
            if (requestedUrl != null && !requestedUrl.equals("")) {
                request.getSession(true).setAttribute("pac4jRequestedUrl", requestedUrl);
            }
        }
    }

    protected List<SingleLogoutRequestContext> initiateSingleLogout(String ticketGrantingTicketId, HttpServletRequest request, HttpServletResponse response) {
        try {
            LOGGER.trace("Removing ticket [{}] from registry...", (Object)ticketGrantingTicketId);
            TicketGrantingTicket ticket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            LOGGER.debug("Ticket [{}] found. Processing logout requests and then deleting the ticket...", (Object)ticket.getId());
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)ticket.getAuthentication());
            List logoutRequests = this.logoutManager.performLogout(SingleLogoutExecutionRequest.builder().ticketGrantingTicket(ticket).httpServletRequest(Optional.of(request)).httpServletResponse(Optional.of(response)).build());
            this.centralAuthenticationService.deleteTicket(ticketGrantingTicketId);
            this.applicationContext.publishEvent((ApplicationEvent)new CasTicketGrantingTicketDestroyedEvent((Object)this, ticket));
            return logoutRequests;
        }
        catch (InvalidTicketException e) {
            LOGGER.debug("Ticket-granting ticket [{}] cannot be found in the ticket registry.", (Object)ticketGrantingTicketId);
            return new ArrayList<SingleLogoutRequestContext>(0);
        }
    }

    @Generated
    public TerminateSessionAction(CentralAuthenticationService centralAuthenticationService, CasCookieBuilder ticketGrantingTicketCookieGenerator, CasCookieBuilder warnCookieGenerator, LogoutProperties logoutProperties, LogoutManager logoutManager, ConfigurableApplicationContext applicationContext) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.logoutProperties = logoutProperties;
        this.logoutManager = logoutManager;
        this.applicationContext = applicationContext;
    }
}

