/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CreateTicketGrantingTicketAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTicketGrantingTicketAction.class);
    private final CasWebflowEventResolutionConfigurationContext webflowEventResolutionConfigurationContext;

    public Event doExecute(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)context);
        AuthenticationResultBuilder authenticationResultBuilder = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
        LOGGER.trace("Finalizing authentication transactions and issuing ticket-granting ticket");
        AuthenticationResult authenticationResult = this.webflowEventResolutionConfigurationContext.getAuthenticationSystemSupport().finalizeAllAuthenticationTransactions(authenticationResultBuilder, (Service)service);
        LOGGER.trace("Finalizing authentication event...");
        Authentication authentication = this.buildFinalAuthentication(authenticationResult);
        String ticketGrantingTicket = this.determineTicketGrantingTicketId(context);
        LOGGER.debug("Creating ticket-granting ticket, potentially based on [{}]", (Object)ticketGrantingTicket);
        TicketGrantingTicket tgt = this.createOrUpdateTicketGrantingTicket(authenticationResult, authentication, ticketGrantingTicket);
        if (registeredService != null && registeredService.getAccessStrategy() != null) {
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
        }
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
        WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)context);
        WebUtils.putAuthentication((Authentication)tgt.getAuthentication(), (RequestContext)context);
        LOGGER.trace("Calculating authentication warning messages...");
        Collection<MessageDescriptor> warnings = CreateTicketGrantingTicketAction.calculateAuthenticationWarningMessages(tgt, context.getMessageContext());
        if (!warnings.isEmpty()) {
            LocalAttributeMap attributes = new LocalAttributeMap("authenticationWarnings", warnings);
            return new EventFactorySupport().event((Object)this, "successWithWarnings", (AttributeMap)attributes);
        }
        return this.success();
    }

    private static Collection<MessageDescriptor> calculateAuthenticationWarningMessages(TicketGrantingTicket tgtId, MessageContext messageContext) {
        Set entries = tgtId.getAuthentication().getSuccesses().entrySet();
        List messages = entries.stream().map(entry -> ((AuthenticationHandlerExecutionResult)entry.getValue()).getWarnings()).filter(entry -> !entry.isEmpty()).collect(Collectors.toList());
        messages.add(tgtId.getAuthentication().getWarnings());
        return messages.stream().flatMap(Collection::stream).peek(message -> CreateTicketGrantingTicketAction.addMessageDescriptorToMessageContext(messageContext, message)).collect(Collectors.toSet());
    }

    private static boolean areAuthenticationsEssentiallyEqual(Authentication auth1, Authentication auth2) {
        if (auth1 == null || auth2 == null) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)auth1.getPrincipal(), (Object)auth2.getPrincipal());
        builder.append((Object)auth1.getCredentials(), (Object)auth2.getCredentials());
        builder.append((Object)auth1.getSuccesses(), (Object)auth2.getSuccesses());
        builder.append((Object)auth1.getAttributes(), (Object)auth2.getAttributes());
        return builder.isEquals();
    }

    private String determineTicketGrantingTicketId(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String ticketGrantingTicketId = this.webflowEventResolutionConfigurationContext.getTicketGrantingTicketCookieGenerator().retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId)) {
            return WebUtils.getTicketGrantingTicketId((RequestContext)context);
        }
        return ticketGrantingTicketId;
    }

    private boolean shouldIssueTicketGrantingTicket(Authentication authentication, String ticketGrantingTicket) {
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicket)) {
            return true;
        }
        LOGGER.trace("Located ticket-granting ticket in the context. Retrieving associated authentication");
        Authentication authenticationFromTgt = this.webflowEventResolutionConfigurationContext.getTicketRegistrySupport().getAuthenticationFrom(ticketGrantingTicket);
        if (authenticationFromTgt == null) {
            LOGGER.debug("Authentication session associated with [{}] is no longer valid", (Object)ticketGrantingTicket);
            this.webflowEventResolutionConfigurationContext.getCentralAuthenticationService().deleteTicket(ticketGrantingTicket);
            return true;
        }
        if (CreateTicketGrantingTicketAction.areAuthenticationsEssentiallyEqual(authentication, authenticationFromTgt)) {
            LOGGER.debug("Resulting authentication matches the authentication from context");
            return false;
        }
        LOGGER.debug("Resulting authentication is different from the context");
        return true;
    }

    protected static void addMessageDescriptorToMessageContext(MessageContext context, MessageDescriptor warning) {
        MessageBuilder builder = new MessageBuilder().warning().code(warning.getCode()).defaultText(warning.getDefaultMessage()).args((Object[])warning.getParams());
        context.addMessage(builder.build());
    }

    protected Authentication buildFinalAuthentication(AuthenticationResult authenticationResult) {
        return authenticationResult.getAuthentication();
    }

    protected TicketGrantingTicket createOrUpdateTicketGrantingTicket(AuthenticationResult authenticationResult, Authentication authentication, String ticketGrantingTicket) {
        try {
            if (this.shouldIssueTicketGrantingTicket(authentication, ticketGrantingTicket)) {
                if (StringUtils.isNotBlank((CharSequence)ticketGrantingTicket)) {
                    LOGGER.trace("Removing existing ticket-granting ticket [{}]", (Object)ticketGrantingTicket);
                    this.webflowEventResolutionConfigurationContext.getTicketRegistry().deleteTicket(ticketGrantingTicket);
                }
                LOGGER.trace("Attempting to issue a new ticket-granting ticket...");
                return this.webflowEventResolutionConfigurationContext.getCentralAuthenticationService().createTicketGrantingTicket(authenticationResult);
            }
            LOGGER.debug("Updating the existing ticket-granting ticket [{}]...", (Object)ticketGrantingTicket);
            TicketGrantingTicket tgt = (TicketGrantingTicket)this.webflowEventResolutionConfigurationContext.getCentralAuthenticationService().getTicket(ticketGrantingTicket, TicketGrantingTicket.class);
            tgt.getAuthentication().update(authentication);
            this.webflowEventResolutionConfigurationContext.getCentralAuthenticationService().updateTicket((Ticket)tgt);
            return tgt;
        }
        catch (PrincipalException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new InvalidTicketException(ticketGrantingTicket);
        }
    }

    @Generated
    public CreateTicketGrantingTicketAction(CasWebflowEventResolutionConfigurationContext webflowEventResolutionConfigurationContext) {
        this.webflowEventResolutionConfigurationContext = webflowEventResolutionConfigurationContext;
    }
}

