/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GenericSuccessViewAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericSuccessViewAction.class);
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final CasConfigurationProperties casProperties;

    public Optional<Authentication> getAuthentication(String ticketGrantingTicketId) {
        try {
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            return Optional.of(ticketGrantingTicket.getAuthentication());
        }
        catch (InvalidTicketException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            LOGGER.warn("In the absence of valid ticket-granting ticket, the authentication cannot be determined");
            return Optional.empty();
        }
    }

    protected Event doExecute(RequestContext requestContext) {
        String redirectUrl = this.casProperties.getView().getDefaultRedirectUrl();
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            WebApplicationService service = (WebApplicationService)this.serviceFactory.createService(redirectUrl);
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            requestContext.getExternalContext().requestExternalRedirect(service.getId());
        } else {
            String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
            this.getAuthentication(tgt).ifPresent(authn -> {
                WebUtils.putAuthentication((Authentication)authn, (RequestContext)requestContext);
                WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
                if (this.casProperties.getView().isAuthorizedServicesOnSuccessfulLogin()) {
                    List authorizedServices = this.servicesManager.getAllServices().stream().filter(registeredService -> {
                        try {
                            return RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (String)authn.getPrincipal().getId(), (Map)CollectionUtils.merge((Map[])new Map[]{authn.getAttributes(), authn.getPrincipal().getAttributes()}));
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                            return false;
                        }
                    }).collect(Collectors.toList());
                    WebUtils.putAuthorizedServices((RequestContext)requestContext, authorizedServices);
                }
            });
        }
        return this.success();
    }

    @Generated
    public GenericSuccessViewAction(CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, ServiceFactory<WebApplicationService> serviceFactory, CasConfigurationProperties casProperties) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.servicesManager = servicesManager;
        this.serviceFactory = serviceFactory;
        this.casProperties = casProperties;
    }
}

