/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceWarningAction
extends AbstractAction {
    public static final String PARAMETER_NAME_IGNORE_WARNING = "ignorewarn";
    private final CentralAuthenticationService centralAuthenticationService;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final CasCookieBuilder warnCookieGenerator;
    private final PrincipalElectionStrategy principalElectionStrategy;

    protected Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicket)) {
            throw new InvalidTicketException((Throwable)new AuthenticationException("No ticket-granting ticket could be found in the context"), ticketGrantingTicket);
        }
        Authentication authentication = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicket);
        if (authentication == null) {
            throw new InvalidTicketException((Throwable)new AuthenticationException("No authentication found for ticket " + ticketGrantingTicket), ticketGrantingTicket);
        }
        Credential credential = WebUtils.getCredential((RequestContext)context);
        AuthenticationResultBuilder authenticationResultBuilder = this.authenticationSystemSupport.establishAuthenticationContextFromInitial(authentication, credential);
        AuthenticationResult authenticationResult = authenticationResultBuilder.build(this.principalElectionStrategy, (Service)service);
        ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, (Service)service, authenticationResult);
        WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
        if (request.getParameterMap().containsKey(PARAMETER_NAME_IGNORE_WARNING) && Boolean.parseBoolean(request.getParameter(PARAMETER_NAME_IGNORE_WARNING))) {
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            this.warnCookieGenerator.removeCookie(response);
        }
        return new Event((Object)this, "redirect");
    }

    @Generated
    public ServiceWarningAction(CentralAuthenticationService centralAuthenticationService, AuthenticationSystemSupport authenticationSystemSupport, TicketRegistrySupport ticketRegistrySupport, CasCookieBuilder warnCookieGenerator, PrincipalElectionStrategy principalElectionStrategy) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.warnCookieGenerator = warnCookieGenerator;
        this.principalElectionStrategy = principalElectionStrategy;
    }
}

