/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.FlowExecutionExceptionResolver;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.GatewayServicesManagementCheckAction;
import org.apereo.cas.web.flow.GenerateServiceTicketAction;
import org.apereo.cas.web.flow.PopulateSpringSecurityContextAction;
import org.apereo.cas.web.flow.ServiceAuthorizationCheckAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.InitialAuthenticationAction;
import org.apereo.cas.web.flow.login.CreateTicketGrantingTicketAction;
import org.apereo.cas.web.flow.login.GenericSuccessViewAction;
import org.apereo.cas.web.flow.login.InitialAuthenticationRequestValidationAction;
import org.apereo.cas.web.flow.login.InitialFlowSetupAction;
import org.apereo.cas.web.flow.login.InitializeLoginAction;
import org.apereo.cas.web.flow.login.RedirectUnauthorizedServiceUrlAction;
import org.apereo.cas.web.flow.login.RenderLoginAction;
import org.apereo.cas.web.flow.login.SendTicketGrantingTicketAction;
import org.apereo.cas.web.flow.login.ServiceWarningAction;
import org.apereo.cas.web.flow.login.SetServiceUnauthorizedRedirectUrlAction;
import org.apereo.cas.web.flow.login.TicketGrantingTicketCheckAction;
import org.apereo.cas.web.flow.login.VerifyRequiredServiceAction;
import org.apereo.cas.web.flow.logout.ConfirmLogoutAction;
import org.apereo.cas.web.flow.logout.FinishLogoutAction;
import org.apereo.cas.web.flow.logout.FrontChannelLogoutAction;
import org.apereo.cas.web.flow.logout.LogoutAction;
import org.apereo.cas.web.flow.logout.LogoutViewSetupAction;
import org.apereo.cas.web.flow.logout.TerminateSessionAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.webflow.execution.Action;

@Configuration(value="CasSupportActionsConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
public class CasSupportActionsConfiguration {

    @Configuration(value="CasSupportActionsExecutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportActionsExecutionConfiguration {
        @ConditionalOnMissingBean(name={"authenticationViaFormAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action authenticationViaFormAction(@Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
            return new InitialAuthenticationAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"serviceAuthorizationCheck"})
        @Bean
        public Action serviceAuthorizationCheck(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
            return new ServiceAuthorizationCheckAction(servicesManager, authenticationRequestServiceSelectionStrategies);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"sendTicketGrantingTicketAction"})
        @Bean
        public Action sendTicketGrantingTicketAction(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy) {
            return new SendTicketGrantingTicketAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, webflowSingleSignOnParticipationStrategy);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"createTicketGrantingTicketAction"})
        @Bean
        public Action createTicketGrantingTicketAction(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new CreateTicketGrantingTicketAction(casWebflowConfigurationContext);
        }

        @ConditionalOnMissingBean(name={"finishLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action finishLogoutAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return new FinishLogoutAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"logoutAction"})
        public Action logoutAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return new LogoutAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
        }

        @ConditionalOnMissingBean(name={"initializeLoginAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action initializeLoginAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new InitializeLoginAction(servicesManager, casProperties);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"setServiceUnauthorizedRedirectUrlAction"})
        @Bean
        public Action setServiceUnauthorizedRedirectUrlAction(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new SetServiceUnauthorizedRedirectUrlAction(servicesManager);
        }

        @ConditionalOnMissingBean(name={"renderLoginFormAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action renderLoginFormAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new RenderLoginAction(servicesManager, casProperties, (ApplicationContext)applicationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initialFlowSetupAction"})
        public Action initialFlowSetupAction(CasConfigurationProperties casProperties, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
            return new InitialFlowSetupAction(CollectionUtils.wrap((Object)argumentExtractor), servicesManager, authenticationRequestServiceSelectionStrategies, ticketGrantingTicketCookieGenerator, warnCookieGenerator, casProperties, authenticationEventExecutionPlan, webflowSingleSignOnParticipationStrategy, ticketRegistrySupport);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"verifyRequiredServiceAction"})
        public Action verifyRequiredServiceAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
            return new VerifyRequiredServiceAction(servicesManager, ticketGrantingTicketCookieGenerator, casProperties, ticketRegistrySupport);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initialAuthenticationRequestValidationAction"})
        public Action initialAuthenticationRequestValidationAction(@Qualifier(value="rankedAuthenticationProviderWebflowEventResolver") CasWebflowEventResolver rankedAuthenticationProviderWebflowEventResolver) {
            return new InitialAuthenticationRequestValidationAction(rankedAuthenticationProviderWebflowEventResolver);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"genericSuccessViewAction"})
        public Action genericSuccessViewAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new GenericSuccessViewAction(centralAuthenticationService, servicesManager, webApplicationServiceFactory, casProperties);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"redirectUnauthorizedServiceUrlAction"})
        public Action redirectUnauthorizedServiceUrlAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new RedirectUnauthorizedServiceUrlAction(servicesManager, (ApplicationContext)applicationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"generateServiceTicketAction"})
        public Action generateServiceTicketAction(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy) {
            return new GenerateServiceTicketAction(authenticationSystemSupport, centralAuthenticationService, ticketRegistrySupport, authenticationRequestServiceSelectionStrategies, servicesManager, principalElectionStrategy);
        }

        @Bean
        @ConditionalOnMissingBean(name={"gatewayServicesManagementCheck"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action gatewayServicesManagementCheck(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
            return new GatewayServicesManagementCheckAction(servicesManager, authenticationRequestServiceSelectionStrategies);
        }

        @Bean
        @ConditionalOnMissingBean(name={"frontChannelLogoutAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action frontChannelLogoutAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return new FrontChannelLogoutAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"ticketGrantingTicketCheckAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action ticketGrantingTicketCheckAction(@Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new TicketGrantingTicketCheckAction(centralAuthenticationService);
        }

        @Bean
        @ConditionalOnMissingBean(name={"terminateSessionAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action terminateSessionAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="logoutManager") LogoutManager logoutManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultSingleLogoutRequestExecutor") SingleLogoutRequestExecutor defaultSingleLogoutRequestExecutor) {
            return new TerminateSessionAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, warnCookieGenerator, casProperties.getLogout(), logoutManager, applicationContext, defaultSingleLogoutRequestExecutor);
        }

        @Bean
        @ConditionalOnMissingBean(name={"confirmLogoutAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action confirmLogoutAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return new ConfirmLogoutAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"logoutViewSetupAction"})
        public Action logoutViewSetupAction(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return new LogoutViewSetupAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceWarningAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action serviceWarningAction(@Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy) {
            return new ServiceWarningAction(centralAuthenticationService, authenticationSystemSupport, ticketRegistrySupport, warnCookieGenerator, principalElectionStrategy);
        }

        @Bean
        @ConditionalOnMissingBean(name={"populateSpringSecurityContextAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action populateSpringSecurityContextAction() {
            return new PopulateSpringSecurityContextAction();
        }
    }

    @Configuration(value="CasSupportActionsExceptionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportActionsExceptionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerExceptionResolver errorHandlerResolver() {
            return new FlowExecutionExceptionResolver();
        }
    }
}

