/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.ArrayList;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CasCaptchaWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCaptchaWebflowConfigurer.class);

    public CasCaptchaWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createInitialRecaptchaEnabledAction(flow);
            this.createValidateRecaptchaAction(flow);
        }
    }

    private void createValidateRecaptchaAction(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        ArrayList currentActions = new ArrayList();
        state.getActionList().forEach(currentActions::add);
        currentActions.forEach(a -> state.getActionList().remove(a));
        state.getActionList().add((Action)this.createEvaluateAction("validateCaptchaAction"));
        currentActions.forEach(a -> state.getActionList().add(a));
        state.getTransitionSet().add(this.createTransition("captchaError", "initializeLoginForm"));
    }

    private void createInitialRecaptchaEnabledAction(Flow flow) {
        flow.getStartActionList().add(new Action(){

            public Event execute(RequestContext requestContext) {
                WebUtils.putRecaptchaSiteKeyIntoFlowScope((RequestContext)requestContext, (Object)CasCaptchaWebflowConfigurer.this.casProperties.getGoogleRecaptcha().getSiteKey());
                WebUtils.putRecaptchaInvisibleIntoFlowScope((RequestContext)requestContext, (Object)CasCaptchaWebflowConfigurer.this.casProperties.getGoogleRecaptcha().isInvisible());
                WebUtils.putRecaptchaPositionIntoFlowScope((RequestContext)requestContext, (Object)CasCaptchaWebflowConfigurer.this.casProperties.getGoogleRecaptcha().getPosition());
                return new EventFactorySupport().success((Object)this);
            }
        });
    }
}

