/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.CheckConsentRequiredAction;
import org.apereo.cas.web.flow.ConfirmConsentAction;
import org.apereo.cas.web.flow.ConsentWebflowConfigurer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casConsentWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnBean(name={"consentRepository"})
@ConditionalOnProperty(prefix="cas.consent", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CasConsentWebflowConfiguration {
    @Autowired
    @Qualifier(value="attributeDefinitionStore")
    private ObjectProvider<AttributeDefinitionStore> attributeDefinitionStore;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="consentEngine")
    private ObjectProvider<ConsentEngine> consentEngine;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="consentActivationStrategy")
    private ObjectProvider<ConsentActivationStrategy> consentActivationStrategy;

    @ConditionalOnMissingBean(name={"checkConsentRequiredAction"})
    @Bean
    public Action checkConsentRequiredAction() {
        return new CheckConsentRequiredAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), (ConsentEngine)this.consentEngine.getObject(), this.casProperties, (AttributeDefinitionStore)this.attributeDefinitionStore.getObject(), this.applicationContext, (ConsentActivationStrategy)this.consentActivationStrategy.getObject());
    }

    @ConditionalOnMissingBean(name={"confirmConsentAction"})
    @Bean
    public Action confirmConsentAction() {
        return new ConfirmConsentAction((ServicesManager)this.servicesManager.getObject(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), (ConsentEngine)this.consentEngine.getObject(), this.casProperties, (AttributeDefinitionStore)this.attributeDefinitionStore.getObject(), this.applicationContext);
    }

    @ConditionalOnMissingBean(name={"consentWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer consentWebflowConfigurer() {
        return new ConsentWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"consentCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer consentCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.consentWebflowConfigurer());
    }
}

