/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.time.temporal.ChronoUnit;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.consent.ConsentReminderOptions;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.AbstractConsentAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ConfirmConsentAction
extends AbstractConsentAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfirmConsentAction.class);

    public ConfirmConsentAction(ServicesManager servicesManager, AuthenticationServiceSelectionPlan strategies, ConsentEngine consentEngine, CasConfigurationProperties casProperties, AttributeDefinitionStore attributeDefinitionStore, ConfigurableApplicationContext applicationContext) {
        super(casProperties, servicesManager, strategies, consentEngine, attributeDefinitionStore, applicationContext);
    }

    public Event doExecute(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        WebApplicationService webService = WebUtils.getService((RequestContext)requestContext);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)webService);
        RegisteredService registeredService = this.getRegisteredServiceForConsent(requestContext, service);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        int optionValue = Integer.parseInt(request.getParameter("option"));
        ConsentReminderOptions option = ConsentReminderOptions.valueOf((int)optionValue);
        long reminder = Long.parseLong(request.getParameter("reminder"));
        String reminderTimeUnit = request.getParameter("reminderTimeUnit");
        ChronoUnit unit = ChronoUnit.valueOf(reminderTimeUnit.toUpperCase());
        LOGGER.debug("Storing consent decision for service [{}]", (Object)service);
        this.consentEngine.storeConsentDecision(service, registeredService, authentication, reminder, unit, option);
        return new EventFactorySupport().success((Object)this);
    }
}

